<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/TR/WD-xsl">

<!-- XSL Stylesheet template - Experimental document stylesheet -->
<!-- This is designed to handle an experimental document XML, XHTML, CML and chimeral CML -->
<!-- note: code is occasionally collapsed for formatting reasons -->
<!-- note: some parts are experimental, normally commented -->
<!-- Please see http://www.xml-cml.org/chimeral/ or http://www.ch.ic.ac.uk/chimeral -->
<!-- Comments to me at: karne@innocent.com -->

<!-- ************************************************************ -->
<!-- * Default all unmatched nodes to XHTML and parse to output * -->
<!-- ******** text and CDATA nodes are displayed as text ******** -->
<!-- ************************************************************ -->
<xsl:template match="*"><xsl:copy><xsl:apply-templates select="@*"/><xsl:apply-templates/></xsl:copy></xsl:template>
<xsl:template match="@*"><xsl:copy><xsl:apply-templates/></xsl:copy></xsl:template>
<xsl:template match="textNode()"><xsl:value-of /></xsl:template>
<xsl:template match="cdata()"><xsl:value-of/></xsl:template>

<!-- ************************************************************ -->
<!-- *************** Special Formatting Elements **************** -->
<!-- ************************************************************ -->
<xsl:template match="docml:lt">&lt;</xsl:template>
<xsl:template match="docml:gt">&gt;</xsl:template>
<xsl:template match="docml:comment"><!-- ignore --></xsl:template>
<xsl:template match="docml:break"><!-- ignore --></xsl:template>

<!-- ************************************************************ -->
<!-- ******************* Ignore certain blocks ****************** -->
<!-- ******************** used as code stores ******************* -->
<!-- ************************************************************ -->
<xsl:template match="svg"><!-- ignore --></xsl:template>
<xsl:template match="cml"><!-- ignore --></xsl:template>
<xsl:template match="svg[@docml:display='hide']"></xsl:template>
<xsl:template match="cml[@docml:display='hide']"></xsl:template>

<!-- ************************************************************ -->
<!-- ************************** Code **************************** -->
<!-- ************************************************************ -->
<xsl:template match="docml:code"><pre><xsl:apply-templates/></pre></xsl:template>
<xsl:template match="docml:code[@display='hide']"></xsl:template>
<xsl:template match="docml:code[@display='inline']"><font class="code"><xsl:apply-templates/></font></xsl:template>

<!-- ************************************************************ -->
<!-- ******************** Build XHTML page ********************** -->
<!-- ************************************************************ -->
<xsl:template match="/"><xsl:apply-templates/></xsl:template>
<xsl:template match="docml:document | document">
<html><head><title><xsl:value-of select="@title"/> - <xsl:value-of select="@id"/></title>
</head>
<!-- ****** CSS ****** -->
<link type="text/css" rel="stylesheet" href="schema+style/document.css"/>
<!-- ***** JavaScript ***** -->
<script>
function Display(island){
var source = island.innerHTML;
document.all.item("out").innerHTML = source;
}
function RunChooser(island){
var source = island.innerHTML;
document.all.item("ChooseHold").innerHTML = source;
}
function Initialise(){
<!-- for JME -->
<xsl:for-each select="//*[@type='molecule' and @display='jme'] | //*[@type='molecule' and @display='jmeSimple'] ">
document.JME_<xsl:value-of select="@idref"/>.readMolecule(jmeoutput_<xsl:value-of select="@idref"/>.value);</xsl:for-each>
<!-- for JMol -->
<xsl:for-each select="//*[@type='molecule' and @display='jmol']">
document.JMolApplet_<xsl:value-of select="@idref"/>.setModelToRenderFromXYZString(jmoloutput_<xsl:value-of select="@idref"/>.value, 'T');</xsl:for-each>
<!-- for JUMBO3
<xsl:for-each select="//*[@type='molecule' and @display='svg']">loadMol('carotene.xml');</xsl:for-each> -->
<!--alert(document.all.item("cmlinput_<xsl:value-of select="@idref"/>").innerHTML);-->
Display(buttons);
}
</script>
<!-- ***** JUMBO3 script ***** -->
<!--<xsl:if test="//docml:link[@type='molecule' and @display='svg']"><script src="display.js"></script></xsl:if>-->

<!-- ***** XML data islands ***** -->
<xml id="buttons">
<xsl:if test="//docml:chapter[1] | //docml:subsection[1]"><input type="button" value="Show Index" onCLick="Display(index)"/></xsl:if>
<xsl:if test="//Signature | //dsig:Signature"><input type="button" value="Show Signature" onCLick="Display(signature)"/></xsl:if>
</xml>
<xml id="signature">
<!-- ***************************************************** -->
<!-- ****************** Build Signature ****************** -->
<!-- ***************************************************** -->
<xsl:if test="//docml:chapter[1] | //docml:subsection[1]"><input type="button" value="Show Index" onCLick="Display(index)"/></xsl:if>
<input type="button" value="Hide Signature" onCLick="Display(buttons)"/>
<xsl:if test="//Signature | //dsig:Signature"><xsl:apply-templates select="//Signature | //dsig:Signature"/>
<xsl:if test="//Signature">This stylesheet expects signatures to be namespaced 'dsig:'. Please correct your xml.</xsl:if>
<xsl:for-each select="//dsig:Signature">
<p><table align="center" width="80%">
	<tr><td class="box_coloured">
	<b>Object signed:</b> 
	<xsl:choose>
		<xsl:when test="dsig:SignedInfo/dsig:Reference[@URI='']">Document</xsl:when>
		<xsl:when test="dsig:SignedInfo/dsig:Reference[@URI]"><xsl:value-of select="dsig:SignedInfo/dsig:Reference/@URI"/></xsl:when>
		<xsl:otherwise>Unknown</xsl:otherwise>
	</xsl:choose>
<br/><b>Signed by:</b> <xsl:value-of select="KeyInfo/X509Data/X509SubjectName | dsig:KeyInfo/dsig:X509Data/dsig:X509SubjectName"/>
<br/><b>Digest Value:</b> <xsl:value-of select="dsig:SignedInfo/dsig:Reference/dsig:DigestValue"/>
<br/><b>Signature Value:</b> <xsl:value-of select="dsig:SignatureValue"/>
<br/><br/><font size="-2"><b>Canonicalization Algorithm:</b> <a target="new"><xsl:attribute name="href"><xsl:value-of select="dsig:SignedInfo/dsig:CanonicalizationMethod/@Algorithm"/></xsl:attribute><xsl:value-of select="dsig:SignedInfo/dsig:CanonicalizationMethod/@Algorithm"/></a>
<br/><b>Signature Algorithm:</b> <a target="new"><xsl:attribute name="href"><xsl:value-of select="dsig:SignedInfo/dsig:SignatureMethod/@Algorithm"/></xsl:attribute><xsl:value-of select="dsig:SignedInfo/dsig:SignatureMethod/@Algorithm"/></a>
<br/><b>Transform Algorithm:</b> <a target="new"><xsl:attribute name="href"><xsl:value-of select="dsig:SignedInfo/dsig:Reference/dsig:Transforms/dsig:Transform/@Algorithm"/></xsl:attribute><xsl:value-of select="dsig:SignedInfo/dsig:Reference/dsig:Transforms/dsig:Transform/@Algorithm"/></a>
<br/><b>Digest Algorithm:</b> <a target="new"><xsl:attribute name="href"><xsl:value-of select="dsig:SignedInfo/dsig:Reference/dsig:DigestMethod/@Algorithm"/></xsl:attribute><xsl:value-of select="dsig:SignedInfo/dsig:Reference/dsig:DigestMethod/@Algorithm"/></a></font>
<p><i>Please see the document source for full key</i></p>
	</td></tr>
</table></p>
</xsl:for-each>
</xsl:if>
</xml>
<xml id="index">
<!-- ***************************************************** -->
<!-- ******************** Build index ******************** -->
<!-- ************** sorry this is so long! *************** -->
<!-- ***************************************************** -->
<xsl:if test="//docml:chapter[1] | //docml:subsection[1]"><input type="button" value="Hide Index" onCLick="Display(buttons)"/></xsl:if>
<xsl:if test="//Signature | //dsig:Signature"><input type="button" value="Show Signature" onCLick="Display(signature)"/></xsl:if>
<p><table align="center" width="80%"><tr><td align="center" class="box_coloured"><table align="center"><tr><td colspan="3" align="center" class="subtitle">Index</td></tr>
<!-- **** chapter **** -->
<xsl:for-each select="docml:chapter"><tr><td align="center" class="subtitle"><xsl:choose><xsl:when test=".[@index='0' or @index='']"> <xsl:eval>formatIndex(childNumber(this), "1")</xsl:eval></xsl:when><xsl:when test=".[@index]"> <xsl:value-of select="@index"/></xsl:when><xsl:otherwise></xsl:otherwise></xsl:choose></td><td width="50" align="center">-</td><td class="subtitle"><xsl:element name="A"><xsl:attribute name="HREF">#<xsl:value-of select="@id"/></xsl:attribute><xsl:value-of select="@title"/></xsl:element></td></tr>
<!-- **** chapter/docml:box/docml:label **** -->
<xsl:for-each select="docml:box/docml:label">
<tr><td colspan="2"></td><td><xsl:choose><xsl:when test=".[@type='figure']">Figure </xsl:when><xsl:when test=".[@type='scheme']">Scheme </xsl:when><xsl:when test=".[@type='table']">Table </xsl:when><xsl:otherwise></xsl:otherwise></xsl:choose><xsl:if test=".[@index='0' or @index='']"><xsl:for-each select="ancestor(docml:chapter)"><xsl:choose><xsl:when test=".[@index='0' or @index='']"><xsl:eval>formatIndex(childNumber(this), "1")</xsl:eval>.</xsl:when><xsl:when test=".[@index]"><xsl:value-of select="@index"/>.</xsl:when><xsl:otherwise></xsl:otherwise></xsl:choose></xsl:for-each><xsl:for-each select="ancestor(docml:subsection)"><xsl:choose><xsl:when test=".[@index='0' or @index='']"><xsl:eval>formatIndex(childNumber(this), "1")</xsl:eval>.</xsl:when><xsl:when test=".[@index]"><xsl:value-of select="@index"/>.</xsl:when><xsl:otherwise></xsl:otherwise></xsl:choose></xsl:for-each></xsl:if><xsl:choose><xsl:when test=".[@index='0' or @index='']"><xsl:eval>formatIndex(childNumber(this), "1")</xsl:eval>: </xsl:when><xsl:when test=".[@index]"><xsl:value-of select="@index"/>: </xsl:when><xsl:otherwise></xsl:otherwise></xsl:choose><xsl:element name="A"><xsl:attribute name="HREF">#<xsl:value-of select="@id"/></xsl:attribute><xsl:apply-templates/></xsl:element></td></tr></xsl:for-each>
<!-- **** chapter/subsection **** -->
<xsl:for-each select="docml:subsection"><tr><td align="center" class="subsubtitle"><xsl:if test=".[@index]"><xsl:for-each select="ancestor(docml:chapter)"><xsl:choose><xsl:when test=".[@index='0' or @index='']"><xsl:eval>formatIndex(childNumber(this), "1")</xsl:eval>.</xsl:when><xsl:when test=".[@index]"><xsl:value-of select="@index"/>.</xsl:when><xsl:otherwise></xsl:otherwise></xsl:choose></xsl:for-each><xsl:choose><xsl:when test=".[@index='0' or @index='']"><xsl:eval>formatIndex(childNumber(this), "1")</xsl:eval> </xsl:when><xsl:when test=".[@index]"><xsl:value-of select="@index"/> </xsl:when><xsl:otherwise></xsl:otherwise></xsl:choose></xsl:if></td><td align="center">-</td><td class="subsubtitle"><xsl:element name="A"><xsl:attribute name="HREF">#<xsl:value-of select="@id"/></xsl:attribute><xsl:value-of select="@title"/></xsl:element></td></tr>
<!-- **** chapter/subsection/docml:box/docml:label **** -->
<xsl:for-each select="docml:box/docml:label">
<tr><td colspan="2"></td><td><xsl:choose><xsl:when test=".[@type='figure']">Figure </xsl:when><xsl:when test=".[@type='scheme']">Scheme </xsl:when><xsl:when test=".[@type='table']">Table </xsl:when><xsl:otherwise></xsl:otherwise></xsl:choose><xsl:if test=".[@index='0' or @index='']"><xsl:for-each select="ancestor(docml:chapter)"><xsl:choose><xsl:when test=".[@index='0' or @index='']"><xsl:eval>formatIndex(childNumber(this), "1")</xsl:eval>.</xsl:when><xsl:when test=".[@index]"><xsl:value-of select="@index"/>.</xsl:when><xsl:otherwise></xsl:otherwise></xsl:choose></xsl:for-each><xsl:for-each select="ancestor(docml:subsection)"><xsl:choose><xsl:when test=".[@index='0' or @index='']"><xsl:eval>formatIndex(childNumber(this), "1")</xsl:eval>.</xsl:when><xsl:when test=".[@index]"><xsl:value-of select="@index"/>.</xsl:when><xsl:otherwise></xsl:otherwise></xsl:choose></xsl:for-each></xsl:if><xsl:choose><xsl:when test=".[@index='0' or @index='']"><xsl:eval>formatIndex(childNumber(this), "1")</xsl:eval>: </xsl:when><xsl:when test=".[@index]"><xsl:value-of select="@index"/>: </xsl:when><xsl:otherwise></xsl:otherwise></xsl:choose><xsl:element name="A"><xsl:attribute name="HREF">#<xsl:value-of select="@id"/></xsl:attribute><xsl:apply-templates/></xsl:element></td></tr></xsl:for-each></xsl:for-each></xsl:for-each>
<!-- **** appendix **** -->
<xsl:for-each select="docml:appendix"><tr><td align="center" class="subtitle"><xsl:choose><xsl:when test=".[@index='0' or @index='']"><xsl:eval>formatIndex(childNumber(this), "A")</xsl:eval></xsl:when><xsl:when test=".[@index]"><xsl:value-of select="@index"/></xsl:when><xsl:otherwise></xsl:otherwise></xsl:choose></td><td align="center">-</td><td class="subtitle"><xsl:element name="A"><xsl:attribute name="HREF">#<xsl:value-of select="@id"/></xsl:attribute><xsl:value-of select="@title"/></xsl:element></td></tr>
<!-- **** appendix/subsection/docml:box/docml:label **** -->
<xsl:for-each select="docml:box/docml:label">
<tr><td colspan="2"></td><td><xsl:choose><xsl:when test=".[@type='figure']">Figure </xsl:when><xsl:when test=".[@type='scheme']">Scheme </xsl:when><xsl:when test=".[@type='table']">Table </xsl:when><xsl:otherwise></xsl:otherwise></xsl:choose><xsl:if test=".[@index='0' or @index='']"><xsl:for-each select="ancestor(docml:chapter)"><xsl:choose><xsl:when test=".[@index='0' or @index='']"><xsl:eval>formatIndex(childNumber(this), "1")</xsl:eval>.</xsl:when><xsl:when test=".[@index]"><xsl:value-of select="@index"/>.</xsl:when><xsl:otherwise></xsl:otherwise></xsl:choose></xsl:for-each><xsl:for-each select="ancestor(docml:subsection)"><xsl:choose><xsl:when test=".[@index='0' or @index='']"><xsl:eval>formatIndex(childNumber(this), "1")</xsl:eval>.</xsl:when><xsl:when test=".[@index]"><xsl:value-of select="@index"/>.</xsl:when><xsl:otherwise></xsl:otherwise></xsl:choose></xsl:for-each></xsl:if><xsl:choose><xsl:when test=".[@index='0' or @index='']"><xsl:eval>formatIndex(childNumber(this), "1")</xsl:eval>: </xsl:when><xsl:when test=".[@index]"><xsl:value-of select="@index"/>: </xsl:when><xsl:otherwise></xsl:otherwise></xsl:choose><xsl:element name="A"><xsl:attribute name="HREF">#<xsl:value-of select="@id"/></xsl:attribute><xsl:apply-templates/></xsl:element></td></tr></xsl:for-each>
</xsl:for-each>
<!-- **** bibliography **** -->
<xsl:for-each select="docml:bibliography">
<tr><td></td><td></td><td class="subtitle"><xsl:element name="A"><xsl:attribute name="HREF">#<xsl:value-of select="@id"/></xsl:attribute><xsl:value-of select="@title"/></xsl:element></td></tr>
</xsl:for-each>
</table></td></tr></table>
</p></xml>
<!-- ***** Initialise JME, Jmol etc. ***** -->
<body onLoad="Initialise()">
<!-- ****** title ****** -->
<p class="maintitle"><xsl:value-of select="@title"/></p>
<xsl:apply-templates select="docml:metadata | docml:abstract"/>
<!-- ****** Index/Signature Holder ****** -->
<div id="out"></div>
<xsl:apply-templates select="docml:chapter | docml:bibliography | docml:appendix | Signature | dsig:Signature"/>
</body></html>	
</xsl:template>

<!-- ************************************************************ -->
<!-- ************************ Signature ************************** -->
<!-- ************************************************************ -->
<xsl:template match="Signature | dsig:Signature">
<xsl:apply-templates/>
</xsl:template>
<!-- ignore the following -->
<xsl:template match="SignedInfo | dsig:SignedInfo"></xsl:template>
<xsl:template match="SignatureValue | dsig:SignatureValue"></xsl:template>
<xsl:template match="KeyInfo | dsig:KeyInfo"></xsl:template>

<!-- ************************************************************ -->
<!-- ************************** metadata ************************ -->
<!-- ************************************************************ -->
<xsl:template match="docml:metadata">
<!-- *** authors *** -->
<p class="authors">
<xsl:for-each select="docml:list/docml:author[0] | docml:author"><xsl:apply-templates select="."/><sup><xsl:for-each select="id(@idref)"><xsl:eval>formatIndex(childNumber(this), "1")</xsl:eval></xsl:for-each></sup></xsl:for-each>
<xsl:for-each select="docml:list/docml:author[not(end()) and index() $gt$ 0]">, <xsl:apply-templates select="."/><sup><xsl:for-each select="id(@idref)"><xsl:eval>formatIndex(childNumber(this), "1")</xsl:eval></xsl:for-each></sup></xsl:for-each>
<xsl:for-each select="docml:list/docml:author[end() and index() $gt$ 0]"> and <xsl:apply-templates select="."/><sup><xsl:for-each select="id(@idref)"><xsl:eval>formatIndex(childNumber(this), "1")</xsl:eval></xsl:for-each></sup></xsl:for-each></p>
<!-- *** institutions *** -->
<p class="institution"><xsl:for-each select="docml:list/docml:institution">(<xsl:eval>formatIndex(childNumber(this), "1")</xsl:eval>) <xsl:value-of/>  - </xsl:for-each>
<!-- *** date *** -->
<span class="date"><xsl:for-each select="docml:date[@*='creation']"><xsl:choose><xsl:when test="docml:month[.='1']">January </xsl:when><xsl:when test="docml:month[.='2']">February </xsl:when><xsl:when test="docml:month[.='3']">March </xsl:when><xsl:when test="docml:month[.='4']">April </xsl:when><xsl:when test="docml:month[.='5']">May </xsl:when><xsl:when test="docml:month[.='6']">June </xsl:when><xsl:when test="docml:month[.='7']">July </xsl:when><xsl:when test="docml:month[.='8']">August </xsl:when><xsl:when test="docml:month[.='9']">September </xsl:when><xsl:when test="docml:month[.='10']">October</xsl:when><xsl:when test="docml:month[.='11']">November</xsl:when><xsl:when test="docml:month[.='12']">December</xsl:when><xsl:otherwise></xsl:otherwise></xsl:choose><xsl:value-of select="docml:day"/>, <xsl:value-of select="docml:year"/></xsl:for-each></span></p><hr/>
</xsl:template>
<xsl:template match="docml:author" xml:space="preserve">
<xsl:choose>
<xsl:when test="@email"><xsl:element name="a"><xsl:attribute name="href">mailto:<xsl:value-of select="@email"/></xsl:attribute><xsl:attribute name="title">Email <xsl:value-of select="docml:name[@type='first']"/> <xsl:value-of select="text()"/><xsl:value-of select="docml:name[@type='family']"/> at <xsl:value-of select="@email"/></xsl:attribute>  <xsl:value-of select="text()"/> <xsl:value-of select="docml:name[@type='first']"/> <xsl:value-of select="docml:name[@type='family']"/></xsl:element>  </xsl:when>
<xsl:otherwise><xsl:value-of select="text()"/> <xsl:value-of select="docml:name[@type='first']"/> <xsl:value-of select="docml:name[@type='family']"/></xsl:otherwise>
</xsl:choose></xsl:template>

<!-- ************************************************************ -->
<!-- ************************ abstract ************************** -->
<!-- ************************************************************ -->
<xsl:template match="docml:abstract">
<table width="90%" align="center"><tr><td class="abstract">
<xsl:apply-templates/></td></tr></table><hr/>
</xsl:template>

<!-- ************************************************************ -->
<!-- ************************* Chapter ************************** -->
<!-- ************************************************************ -->
<!-- if @index exists: force index number if greater than 0, if 0 then calculate -->
<xsl:template match="docml:chapter">
<p class="title"><xsl:element name="a"><xsl:attribute name="name"><xsl:value-of select="@id"/></xsl:attribute></xsl:element>
<xsl:choose>
	<xsl:when test=".[@index='0' or @index='']"><xsl:eval>formatIndex(childNumber(this), "1")</xsl:eval> - </xsl:when>
	<xsl:when test=".[@index]"><xsl:value-of select="@index"/> - </xsl:when>
	<xsl:otherwise></xsl:otherwise>
</xsl:choose>
<xsl:value-of select="@title"/></p>
<xsl:apply-templates/>
</xsl:template>

<!-- ************************************************************ -->
<!-- ************************ Subsection ************************ -->
<!-- ************************************************************ -->
<xsl:template match="docml:subsection">
<p class="subtitle"><xsl:element name="a"><xsl:attribute name="name"><xsl:value-of select="@id"/></xsl:attribute></xsl:element>
<xsl:if test=".[@index]">
<xsl:for-each select="ancestor(docml:chapter)">
	<xsl:choose>
		<xsl:when test=".[@index='0' or @index='']">
		<xsl:eval>formatIndex(childNumber(this), "1")</xsl:eval>.</xsl:when>
		<xsl:when test=".[@index]">
		<xsl:value-of select="@index"/>.</xsl:when>
		<xsl:otherwise></xsl:otherwise>
	</xsl:choose>
</xsl:for-each>
<xsl:choose>
	<xsl:when test=".[@index='0' or @index='']"><xsl:eval>formatIndex(childNumber(this), "1")</xsl:eval> - </xsl:when>
	<xsl:when test=".[@index]"><xsl:value-of select="@index"/> - </xsl:when>
	<xsl:otherwise></xsl:otherwise>
</xsl:choose></xsl:if>
<xsl:value-of select="@title"/></p>
<xsl:apply-templates/>
</xsl:template>

<!-- ************************************************************ -->
<!-- ************************* Appendix ************************* -->
<!-- ************************************************************ -->
<xsl:template match="docml:appendix">
<p class="title"><xsl:element name="a"><xsl:attribute name="name"><xsl:value-of select="@id"/></xsl:attribute></xsl:element>
Appendix 
<xsl:choose>
	<xsl:when test=".[@index='0' or @index='']"><xsl:eval>formatIndex(childNumber(this), "A")</xsl:eval> - </xsl:when>
	<xsl:when test=".[@index]"><xsl:value-of select="@index"/> - </xsl:when>
	<xsl:otherwise> - </xsl:otherwise>
</xsl:choose>
<xsl:value-of select="@title"/></p>
<xsl:apply-templates/>
<hr width="95%"/>
</xsl:template>

<!-- ************************************************************ -->
<!-- *********************** Bibliography *********************** -->
<!-- ************************************************************ -->
<xsl:template match="docml:bibliography">
<p class="title"><a name="bibliography"/>
<xsl:value-of select="@title"/></p>
<xsl:apply-templates select="p | P"/>
<ol><xsl:for-each select="docml:ref" order-by="docml:index">
	<xsl:element name="li"><xsl:attribute name="value"><xsl:value-of select="docml:index"/></xsl:attribute><xsl:element name="a"><xsl:attribute name="name"><xsl:value-of select="@id"/></xsl:attribute></xsl:element>
	<xsl:choose>
		<xsl:when test="docml:publication">
		<!-- *** assume journal citation *** -->
			<xsl:apply-templates select="text()"/>
			<xsl:apply-templates select="docml:list/docml:author[0] | docml:author"/>
			<xsl:for-each select="docml:list/docml:author[not(end()) and index() $gt$ 0]">, <xsl:apply-templates select="."/></xsl:for-each>
			<xsl:for-each select="docml:list/docml:author[end() and index() $gt$ 0]"> and <xsl:apply-templates select="."/></xsl:for-each>,
			<i><xsl:value-of select="docml:publication"/>, </i>
			<xsl:if test="docml:date"><xsl:value-of select="docml:date"/>, </xsl:if>
			<xsl:if test="docml:volume"><b><xsl:value-of select="docml:volume"/>, </b></xsl:if>
			<xsl:if test="docml:page[@type='first']"><xsl:value-of select="docml:page[@type='first']"/></xsl:if>
			<xsl:if test="docml:page[@type='last']">-<xsl:value-of select="docml:page[@type='last']"/></xsl:if>
			<xsl:if test="@href"> <i> <xsl:element name="A"><xsl:attribute name="HREF"><xsl:value-of select="@href"/></xsl:attribute>(www)</xsl:element></i></xsl:if>
		</xsl:when>
		<xsl:otherwise>
		<!-- *** assume web citation *** -->
			<xsl:apply-templates select="text()"/>
			<xsl:if test="docml:list[docml:author] | docml:author">
			<xsl:apply-templates select="docml:list/docml:author[0] | docml:author"/>
			<xsl:for-each select="docml:list/docml:author[not(end()) and index() $gt$ 0]">, <xsl:apply-templates select="."/></xsl:for-each>
			<xsl:for-each select="docml:list/docml:author[end()]"> and <xsl:apply-templates select="."/></xsl:for-each>, </xsl:if>
			<xsl:value-of select="docml:title"/>, 
			<i><xsl:element name="A"><xsl:attribute name="HREF"><xsl:value-of select="@href"/></xsl:attribute>(<xsl:value-of select="@href"/>)</xsl:element></i>
		</xsl:otherwise>
	</xsl:choose>
	</xsl:element>
</xsl:for-each></ol>
</xsl:template>


<!-- ************************************************************ -->
<!-- ************************** Label *************************** -->
<!-- ************************************************************ -->
<xsl:template match="docml:label">
<!-- if an index number is given force it, esle calculate, if @index not exist then no number -->
<font size="-1"><b><xsl:element name="a"><xsl:attribute name="name"><xsl:value-of select="@id"/></xsl:attribute></xsl:element>
<xsl:choose>
	<xsl:when test=".[@type='figure']">Figure </xsl:when>
	<xsl:when test=".[@type='scheme']">Scheme </xsl:when>
	<xsl:when test=".[@type='table']">Table </xsl:when>
	<xsl:otherwise></xsl:otherwise>
</xsl:choose>
<xsl:if test=".[@index='0' or @index='']">
<xsl:for-each select="ancestor(docml:chapter)">
	<xsl:choose>
		<xsl:when test=".[@index='0' or @index='']">
		<xsl:eval>formatIndex(childNumber(this), "1")</xsl:eval>.</xsl:when>
		<xsl:when test=".[@index]">
		<xsl:value-of select="@index"/>.</xsl:when>
		<xsl:otherwise></xsl:otherwise>
	</xsl:choose>
</xsl:for-each>
<xsl:for-each select="ancestor(docml:subsection)">
	<xsl:choose>
		<xsl:when test=".[@index='0' or @index='']">
		<xsl:eval>formatIndex(childNumber(this), "1")</xsl:eval>.</xsl:when>
		<xsl:when test=".[@index]">
		<xsl:value-of select="@index"/>.</xsl:when>
		<xsl:otherwise></xsl:otherwise>
	</xsl:choose>
</xsl:for-each></xsl:if>
<xsl:choose>
	<xsl:when test=".[@index='0' or @index='']"><xsl:eval>formatIndex(childNumber(this), "1")</xsl:eval>: </xsl:when>
	<xsl:when test=".[@index]"><xsl:value-of select="@index"/>: </xsl:when>
	<xsl:otherwise></xsl:otherwise>
</xsl:choose></b><i>
<xsl:apply-templates/></i></font>
</xsl:template>

<!-- ************************************************************ -->
<!-- *************************** box **************************** -->
<!-- ************************************************************ -->
<xsl:template match="docml:box">
<table align="center" width="95%">
<xsl:choose>
<xsl:when test=".[@rows='1' and @cols='1']">
	<tr><td class="box_coloured"><xsl:apply-templates select="docml:label"/></td></tr>
	<tr><td><xsl:attribute name="class">box_<xsl:value-of select="@type"/></xsl:attribute><xsl:if test="./*[1][@display or @xhtml:align='center']"><xsl:attribute name="align">center</xsl:attribute></xsl:if><xsl:apply-templates select="./*[1]"/></td></tr></xsl:when>
<xsl:when test=".[@rows='1' and @cols='2']">
	<tr><td colspan="2" class="box_coloured"><xsl:apply-templates select="docml:label"/></td></tr>
	<tr><td width="50%"><xsl:attribute name="class">box_<xsl:value-of select="@type"/></xsl:attribute><xsl:if test="./*[1][@display or @xhtml:align='center']"><xsl:attribute name="align">center</xsl:attribute></xsl:if><xsl:apply-templates select="./*[1]"/></td><td width="50%"><xsl:attribute name="class">box_<xsl:value-of select="@type"/></xsl:attribute><xsl:if test="./*[2][@display or @xhtml:align='center']"><xsl:attribute name="align">center</xsl:attribute></xsl:if><xsl:apply-templates select="./*[2]"/></td></tr></xsl:when>
<xsl:when test=".[@rows='1' and @cols='3']">
	<tr><td colspan="3" class="box_coloured"><xsl:apply-templates select="docml:label"/></td></tr>
	<tr><td width="33.3%"><xsl:attribute name="class">box_<xsl:value-of select="@type"/></xsl:attribute><xsl:if test="./*[1][@display or @xhtml:align='center']"><xsl:attribute name="align">center</xsl:attribute></xsl:if><xsl:apply-templates select="./*[1]"/></td><td width="33.3%"><xsl:attribute name="class">box_<xsl:value-of select="@type"/></xsl:attribute><xsl:if test="./*[2][@display or @xhtml:align='center']"><xsl:attribute name="align">center</xsl:attribute></xsl:if><xsl:apply-templates select="./*[2]"/></td><td width="33.3%"><xsl:attribute name="class">box_<xsl:value-of select="@type"/></xsl:attribute><xsl:if test="./*[3][@display or @xhtml:align='center']"><xsl:attribute name="align">center</xsl:attribute></xsl:if><xsl:apply-templates select="./*[3]"/></td></tr></xsl:when>
<xsl:when test=".[@rows='2' and @cols='1']">
	<tr><td class="box_coloured"><xsl:apply-templates select="docml:label"/></td></tr>
	<tr><td><xsl:attribute name="class">box_<xsl:value-of select="@type"/></xsl:attribute><xsl:if test="./*[1][@display or @xhtml:align='center']"><xsl:attribute name="align">center</xsl:attribute></xsl:if><xsl:apply-templates select="./*[1]"/></td></tr><tr><td><xsl:attribute name="class">box_<xsl:value-of select="@type"/></xsl:attribute><xsl:if test="./*[2][@display or @xhtml:align='center']"><xsl:attribute name="align">center</xsl:attribute></xsl:if><xsl:apply-templates select="./*[2]"/></td></tr></xsl:when>
<xsl:when test=".[@rows='2' and @cols='2']">
	<tr><td colspan="2" class="box_coloured"><xsl:apply-templates select="docml:label"/></td></tr>
	<tr><td width="50%"><xsl:attribute name="class">box_<xsl:value-of select="@type"/></xsl:attribute><xsl:if test="./*[1][@display or @xhtml:align='center']"><xsl:attribute name="align">center</xsl:attribute></xsl:if><xsl:apply-templates select="./*[1]"/></td><td width="50%"><xsl:attribute name="class">box_<xsl:value-of select="@type"/></xsl:attribute><xsl:if test="./*[2][@display or @xhtml:align='center']"><xsl:attribute name="align">center</xsl:attribute></xsl:if><xsl:apply-templates select="./*[2]"/></td></tr><tr><td width="50%"><xsl:attribute name="class">box_<xsl:value-of select="@type"/></xsl:attribute><xsl:if test="./*[3][@display or @xhtml:align='center']"><xsl:attribute name="align">center</xsl:attribute></xsl:if><xsl:apply-templates select="./*[3]"/></td><td width="50%"><xsl:attribute name="class">box_<xsl:value-of select="@type"/></xsl:attribute><xsl:if test="./*[4][@display or @xhtml:align='center']"><xsl:attribute name="align">center</xsl:attribute></xsl:if><xsl:apply-templates select="./*[4]"/></td></tr></xsl:when>
<xsl:when test=".[@rows='2' and @cols='3']">
	<tr><td colspan="3" class="box_coloured"><xsl:apply-templates select="docml:label"/></td></tr>
	<tr><td width="33.3%"><xsl:attribute name="class">box_<xsl:value-of select="@type"/></xsl:attribute><xsl:if test="./*[1][@display or @xhtml:align='center']"><xsl:attribute name="align">center</xsl:attribute></xsl:if><xsl:apply-templates select="./*[1]"/></td><td width="33.3%"><xsl:attribute name="class">box_<xsl:value-of select="@type"/></xsl:attribute><xsl:if test="./*[2][@display or @xhtml:align='center']"><xsl:attribute name="align">center</xsl:attribute></xsl:if><xsl:apply-templates select="./*[2]"/></td><td width="33.3%"><xsl:attribute name="class">box_<xsl:value-of select="@type"/></xsl:attribute><xsl:if test="./*[3][@display or @xhtml:align='center']"><xsl:attribute name="align">center</xsl:attribute></xsl:if><xsl:apply-templates select="./*[3]"/></td></tr><tr><td width="33.3%"><xsl:attribute name="class">box_<xsl:value-of select="@type"/></xsl:attribute><xsl:if test="./*[4][@display or @xhtml:align='center']"><xsl:attribute name="align">center</xsl:attribute></xsl:if><xsl:apply-templates select="./*[4]"/></td><td width="33.3%"><xsl:attribute name="class">box_<xsl:value-of select="@type"/></xsl:attribute><xsl:if test="./*[5][@display or @xhtml:align='center']"><xsl:attribute name="align">center</xsl:attribute></xsl:if><xsl:apply-templates select="./*[5]"/></td><td width="33.3%"><xsl:attribute name="class">box_<xsl:value-of select="@type"/></xsl:attribute><xsl:if test="./*[6][@display or @xhtml:align='center']"><xsl:attribute name="align">center</xsl:attribute></xsl:if><xsl:apply-templates select="./*[6]"/></td></tr></xsl:when>
<xsl:otherwise><div class="error">/ERROR - unsupported box size/</div></xsl:otherwise>
</xsl:choose>
</table>
</xsl:template>

<!-- ************************************************************ -->
<!-- *********************** Link: broken ************************ -->
<!-- ************************************************************ -->
<xsl:template match="docml:link">
<div class="error">/ERROR - undefined or unsupported link - <xsl:value-of select="@type"/> <xsl:value-of select="@display"/> <xsl:value-of select="@idref"/>/</div>
</xsl:template>

<!-- ************************************************************ -->
<!-- ************************ Link: ref ************************* -->
<!-- ************************************************************ -->
<xsl:template match="docml:link[@type='ref']">
<sup><xsl:for-each select="id(@idref)">
<xsl:element name="a"><xsl:attribute name="href">#<xsl:value-of select="@id"/></xsl:attribute>
<xsl:attribute name="title" xml:space="preserve"><xsl:choose><xsl:when test="docml:publication"><xsl:for-each select="docml:list/docml:author[0] | docml:author"><xsl:value-of/></xsl:for-each><xsl:for-each select="docml:list/docml:author[not(end()) and index() $gt$ 0]">, <xsl:value-of/></xsl:for-each><xsl:for-each select="docml:list/docml:author[end()]"> and <xsl:value-of/></xsl:for-each>,<xsl:value-of select="docml:publication"/>,<xsl:if test="docml:date"><xsl:value-of select="docml:date"/>, </xsl:if><xsl:if test="docml:volume"><xsl:value-of select="docml:volume"/>, </xsl:if><xsl:if test="docml:pages"><xsl:value-of select="docml:pages"/></xsl:if><xsl:if test="@href"> (<xsl:value-of select="@href"/>)</xsl:if></xsl:when><xsl:otherwise><xsl:apply-templates select="text()"/><xsl:if test="docml:list[docml:author] | docml:author"><xsl:apply-templates select="docml:list/docml:author[0] | docml:author"/><xsl:for-each select="docml:list/docml:author[not(end()) and index() $gt$ 0]">, <xsl:apply-templates select="."/></xsl:for-each><xsl:for-each select="docml:list/docml:author[end()]"> and <xsl:apply-templates select="."/></xsl:for-each>, </xsl:if><xsl:value-of select="docml:title"/>, (<xsl:value-of select="@href"/>)</xsl:otherwise></xsl:choose></xsl:attribute>
<xsl:value-of select="docml:index"/>
</xsl:element></xsl:for-each></sup>
</xsl:template>

<!-- ************************************************************ -->
<!-- *********************** Link: label ************************ -->
<!-- ************************************************************ -->
<xsl:template match="docml:link[@type='label' or @type='figure']">
<xsl:for-each select="id(@idref)">
<xsl:element name="a"><xsl:attribute name="href">#<xsl:value-of select="@id"/></xsl:attribute>
<xsl:attribute name="title"><xsl:value-of select="text()"/></xsl:attribute>
<xsl:choose>
	<xsl:when test=".[@type='figure']">Figure </xsl:when>
	<xsl:when test=".[@type='scheme']">Scheme </xsl:when>
	<xsl:when test=".[@type='table']">Table </xsl:when>
	<xsl:otherwise>Label </xsl:otherwise>
</xsl:choose>
<xsl:if test=".[@index='0' or @index='']">
<xsl:for-each select="ancestor(docml:chapter)">
	<xsl:choose>
		<xsl:when test=".[@index='0' or @index='']">
		<xsl:eval>formatIndex(childNumber(this), "1")</xsl:eval>.</xsl:when>
		<xsl:when test=".[@index]">
		<xsl:value-of select="@index"/>.</xsl:when>
		<xsl:otherwise></xsl:otherwise>
	</xsl:choose>
</xsl:for-each>
<xsl:for-each select="ancestor(docml:subsection)">
	<xsl:choose>
		<xsl:when test=".[@index='0' or @index='']">
		<xsl:eval>formatIndex(childNumber(this), "1")</xsl:eval>.</xsl:when>
		<xsl:when test=".[@index]">
		<xsl:value-of select="@index"/>.</xsl:when>
		<xsl:otherwise></xsl:otherwise>
	</xsl:choose>
</xsl:for-each></xsl:if>
<xsl:choose>
	<xsl:when test=".[@index='0' or @index='']"><xsl:eval>formatIndex(childNumber(this), "1")</xsl:eval> </xsl:when>
	<xsl:when test=".[@index]"><xsl:value-of select="@index"/></xsl:when>
	<xsl:otherwise></xsl:otherwise>
</xsl:choose></xsl:element></xsl:for-each>
</xsl:template>

<!-- ************************************************************ -->
<!-- ****************** Link: label external ******************** -->
<!-- ************************************************************ -->
<xsl:template match="docml:link[@type='label' and @href]">
<xsl:element name="a"><xsl:attribute name="href"><xsl:value-of select="@href"/></xsl:attribute>
<xsl:attribute name="title">External (<xsl:value-of select="@href"/>): <xsl:value-of select="@alt"/></xsl:attribute><font color="#FF0000">##footnote:<xsl:value-of select="@alt"/>#</font></xsl:element>
</xsl:template>

<!-- ************************************************************ -->
<!-- ************************ Link: code ************************ -->
<!-- ************************************************************ -->
<xsl:template match="docml:link[@type='code']">
<xsl:for-each select="id(@idref)" xml:space="preserve"><pre><xsl:apply-templates/></pre></xsl:for-each>
</xsl:template>

<!-- ************************************************************ -->
<!-- ************************ Link: glos ************************ -->
<!-- ************************************************************ -->
<xsl:template match="docml:link[@type='glos']">
<xsl:for-each select="id(@idref)" xml:space="preserve">
<xsl:element name="a">
<xsl:attribute name="href">#<xsl:value-of select="@id"/></xsl:attribute>
<xsl:attribute name="title">Glossary: <xsl:value-of select="@title"/></xsl:attribute><xsl:apply-templates select="."/></xsl:element>
</xsl:for-each>
</xsl:template>

<!-- ************************************************************ -->
<!-- ********************** Link: external ********************** -->
<!-- ************************************************************ -->
<xsl:template match="docml:link[@type='external'] | a[@href] | A[@HREF]">
<xsl:element name="a">
<xsl:attribute name="href"><xsl:value-of select="@href | @HREF"/></xsl:attribute>
<xsl:attribute name="target">new</xsl:attribute>
<xsl:attribute name="title">External Link: <xsl:value-of select="@title | @TITLE"/> (<xsl:value-of select="@href | @HREF"/>)</xsl:attribute>
<xsl:apply-templates/>
</xsl:element>
</xsl:template>


<!-- ************************************************************ -->
<!-- ******************** Link: external image ****************** -->
<!-- ************************************************************ -->
<xsl:template match="docml:link[@type='external' and @display='image'] | img | IMG">
<xsl:element name="img">
<xsl:attribute name="src"><xsl:value-of select="@href | @src | @SRC"/></xsl:attribute>
<xsl:attribute name="width"><xsl:value-of select="@width | @WIDTH"/></xsl:attribute>
<xsl:attribute name="height"><xsl:value-of select="@height | @HEIGHT"/></xsl:attribute>
<xsl:attribute name="alt">External Image: <xsl:value-of select="@alt | @ALT"/></xsl:attribute>
<xsl:attribute name="border">0</xsl:attribute>
</xsl:element>
</xsl:template>

<!-- ************************************************************ -->
<!-- ******************** Link: external svg ******************** -->
<!-- ************************************************************ -->
<xsl:template match="docml:link[@type='external' and @display='svg']">
<xsl:element name="embed">
<xsl:attribute name="name">svg_<xsl:value-of select="@href"/></xsl:attribute>
<xsl:attribute name="src"><xsl:value-of select="@href"/></xsl:attribute>
<xsl:attribute name="width"><xsl:value-of select="@width"/></xsl:attribute>
<xsl:attribute name="height"><xsl:value-of select="@height"/></xsl:attribute>
<xsl:attribute name="type">image/svg</xsl:attribute>
<xsl:attribute name="alt">Please install the SVG plugin (Adobe)</xsl:attribute>
</xsl:element>
</xsl:template>

<!-- ************************************************************ -->
<!-- ****************** Link: external molFile ****************** -->
<!-- ************************************************************ -->
<xsl:template match="docml:link[@type='external' and @display='molFile']">
<xsl:element name="embed">
<xsl:attribute name="name">molFile_<xsl:value-of select="@href"/></xsl:attribute>
<xsl:attribute name="src"><xsl:value-of select="@href"/></xsl:attribute>
<xsl:attribute name="width"><xsl:value-of select="@width"/></xsl:attribute>
<xsl:attribute name="height"><xsl:value-of select="@height"/></xsl:attribute>
<xsl:attribute name="type">image/mol</xsl:attribute>
<xsl:attribute name="frank">yes</xsl:attribute>
<xsl:attribute name="spiny">18</xsl:attribute>
<xsl:attribute name="startspin">true</xsl:attribute>
<xsl:attribute name="display3D">spacefill</xsl:attribute>
<xsl:attribute name="bgcolor"><xsl:choose><xsl:when test="../.[@type='coloured']">#EEEEFF</xsl:when><xsl:otherwise>#FFFFFF</xsl:otherwise></xsl:choose></xsl:attribute>
<xsl:attribute name="alt">Please install the Chime plugin (or similar)</xsl:attribute>
</xsl:element>
</xsl:template>

<!-- ************************************************************ -->
<!-- ************************ chemistry ************************* -->
<!-- ************************************************************ -->

<!-- ************************************************************ -->
<!-- ********************** Link: datasheet ********************* -->
<!-- ************************************************************ -->
<xsl:template match="docml:link[@type='molecule' and @display='datasheet']">
<xsl:for-each select="id(@idref)">
<table class="box_coloured"><tr><td>
	<font color="#0000AA">Molecule ID:</font></td><td>
	<font color="#0000AA">Formula:</font></td><td>
	<font color="#0000AA">CAS:</font></td><td>
	<font color="#0000AA">ACX:</font></td><td>
	<font color="#0000AA">DOT:</font></td><td>
	<font color="#0000AA">RTECS:</font></td><td>
	<font color="#0000AA">MW:</font></td></tr><tr><td class="box_white">		
	<xsl:value-of select="@id"/></td><td class="box_white">
	<xsl:value-of select="formula"/></td><td class="box_white">
	<xsl:value-of select="*[@title = 'CAS']"/></td><td class="box_white">
	<xsl:value-of select="*[@title = 'ACX']"/></td><td class="box_white">
	<xsl:value-of select="*[@title = 'DOT']"/></td><td class="box_white">
	<xsl:value-of select="*[@title = 'RTECS']"/></td><td class="box_white">
	<xsl:value-of select="*[@title = 'molecule weight' or @title = 'molecular weight']"/></td></tr><tr><td>
	<font color="#0000AA">Melting Point:</font>
	</td><td class="box_white">
	<xsl:value-of select="*[@title = 'melting point']"/>
	<xsl:value-of select="*[@title = 'melting point']/@units"/>
	</td><td>
	<font color="#0000AA">Spec. Gravity:</font>
	</td><td class="box_white">
	<xsl:value-of select="*[@title = 'specific gravity']"/>
	</td><td>
	<font color="#0000AA">Water Sol.:</font>
	</td><td colspan="3" class="box_white">
	<xsl:value-of select="*[@title = 'water solubility']"/>
	<xsl:value-of select="*[@title = 'water solubility']/@convention"/>
	</td></tr>
	<tr><td><font color="#0000AA">Alternate Names:</font></td>
	<td colspan="6" class="box_white"><xsl:for-each select="list[@title = 'alternate names']/string[@title = 'name']"><xsl:value-of select="text()"/>, </xsl:for-each></td></tr>
	<tr><td><font color="#0000AA">Comments:</font></td>
	<td colspan="6" class="box_white"><xsl:value-of select="*[@title = 'comments']"/></td></tr>
</table>
</xsl:for-each>
</xsl:template>

<!-- ************************************************************ -->
<!-- ************************ Link: crystal ********************** -->
<!-- ************************************************************ -->
<xsl:template match="docml:link[@type='crystal']">
/ERROR - cystal not yet supported/
</xsl:template>

<!-- ************************************************************ -->
<!-- ************************ Link: molRaw ********************** -->
<!-- ************************************************************ -->
<xsl:template match="docml:link[@type='molecule' and @display='molRaw']">
<!-- set default row and col of 10:80 unless specified -->
<xsl:element name="textarea" xml:space="preserve"><xsl:attribute name="rows"><xsl:choose><xsl:when test="@rows | @ROWS"><xsl:value-of select="@rows | @ROWS"/></xsl:when><xsl:otherwise>10</xsl:otherwise></xsl:choose></xsl:attribute><xsl:attribute name="cols"><xsl:choose><xsl:when test="@cols | COLS"><xsl:value-of select="@cols | @COLS"/></xsl:when><xsl:otherwise>80</xsl:otherwise></xsl:choose></xsl:attribute><xsl:for-each select="id(@idref)" xml:space="preserve">
<xsl:value-of select="@title"/>
CMLconvert0828001552<xsl:choose><xsl:when test="*/*/*[@*='z3']">3D</xsl:when><xsl:otherwise>2D</xsl:otherwise></xsl:choose> 1 0.00366  0.00000     0
From CML - date inaccurate
<xsl:for-each select="*/atom[end()]"><xsl:if expr="(childNumber(this) &lt; 100)"> </xsl:if><xsl:if expr="(childNumber(this) &lt; 10)"> </xsl:if><xsl:eval>formatIndex(childNumber(this), "1")</xsl:eval></xsl:for-each><xsl:for-each select="*/bond[end()]"><xsl:if expr="(childNumber(this) &lt; 100)"> </xsl:if><xsl:if expr="(childNumber(this) &lt; 10)"> </xsl:if><xsl:eval>formatIndex(childNumber(this), "1")</xsl:eval></xsl:for-each>  0  0  0  0              0 v2000<xsl:for-each select="*/atom">
<xsl:for-each select="*[@*='x3' or @*='x2']"> <xsl:if test=".[. $lt$ 100]"> </xsl:if><xsl:if test=".[. $lt$ 10]"> </xsl:if><xsl:if test=".[. $gt$ 0]"> </xsl:if><xsl:value-of/></xsl:for-each> <xsl:for-each select="*[@*='y3' or @*='y2']"><xsl:if test=".[. $lt$ 10000]"> </xsl:if><xsl:if test=".[. $lt$ 10]"> </xsl:if><xsl:if test=".[. $gt$ 0]"> </xsl:if><xsl:value-of/></xsl:for-each> <xsl:choose><xsl:when test="*[@*='z3']"><xsl:for-each select="*[@*='z3']"><xsl:if test=".[. $lt$ 10000]"> </xsl:if><xsl:if test=".[. $lt$ 10]"> </xsl:if><xsl:if test=".[. $gt$ 0]"> </xsl:if><xsl:value-of/></xsl:for-each></xsl:when><xsl:otherwise>   0.0000</xsl:otherwise></xsl:choose> <xsl:for-each select="*[@*='elementType']"><xsl:value-of select="."/><xsl:if test=".[. = 'H']"> </xsl:if><xsl:if test=".[. = 'B']"> </xsl:if><xsl:if test=".[. = 'C']"> </xsl:if><xsl:if test=".[. = 'N']"> </xsl:if><xsl:if test=".[. = 'O']"> </xsl:if><xsl:if test=".[. = 'F']"> </xsl:if><xsl:if test=".[. = 'P']"> </xsl:if><xsl:if test=".[. = 'S']"> </xsl:if><xsl:if test=".[. = 'I']"> </xsl:if><xsl:if test=".[. = 'K']"> </xsl:if><xsl:if test=".[. = 'R']"> </xsl:if><xsl:if test=".[. = 'M']"> </xsl:if><xsl:if test=".[. = 'X']"> </xsl:if></xsl:for-each>  0  0  0  0  0</xsl:for-each>
<xsl:for-each select="*/bond"><xsl:for-each select="*[@*='atomRef']"><xsl:for-each select="//atom[@id = context()]"><xsl:if expr="(childNumber(this) &lt; 100)"> </xsl:if><xsl:if expr="(childNumber(this) &lt; 10)"> </xsl:if><xsl:eval>formatIndex(childNumber(this), "1")</xsl:eval></xsl:for-each></xsl:for-each><xsl:for-each select="*[@*='order']"><xsl:if test=".[. $lt$ 100]"> </xsl:if><xsl:if test=".[. $lt$ 10]"> </xsl:if><xsl:value-of select="."/></xsl:for-each>  0  0  0
</xsl:for-each>M  END
</xsl:for-each></xsl:element>
</xsl:template>

<!-- ************************************************************ -->
<!-- ************************ Link: xyzRaw ********************** -->
<!-- ************************************************************ -->
<xsl:template match="docml:link[@type='molecule' and @display='xyzRaw']">
<!-- set default row and col of 10:80 unless specified -->
<xsl:element name="textarea" xml:space="preserve"><xsl:attribute name="rows"><xsl:choose><xsl:when test="@rows | @ROWS"><xsl:value-of select="@rows | @ROWS"/></xsl:when><xsl:otherwise>10</xsl:otherwise></xsl:choose></xsl:attribute><xsl:attribute name="cols"><xsl:choose><xsl:when test="@cols | COLS"><xsl:value-of select="@cols | @COLS"/></xsl:when><xsl:otherwise>80</xsl:otherwise></xsl:choose></xsl:attribute><xsl:for-each select="id(@idref)" xml:space="preserve">
<xsl:for-each select="*/atom[end()]"><xsl:eval>formatIndex(childNumber(this), "1")</xsl:eval></xsl:for-each>
<xsl:value-of select="@title"/><xsl:for-each select="*/atom">
<xsl:for-each select="*[@*='elementType']"><xsl:value-of select="."/><xsl:if test=".[. = 'H']"> </xsl:if><xsl:if test=".[. = 'B']"> </xsl:if><xsl:if test=".[. = 'C']"> </xsl:if><xsl:if test=".[. = 'N']"> </xsl:if><xsl:if test=".[. = 'O']"> </xsl:if><xsl:if test=".[. = 'F']"> </xsl:if><xsl:if test=".[. = 'P']"> </xsl:if><xsl:if test=".[. = 'S']"> </xsl:if><xsl:if test=".[. = 'I']"> </xsl:if><xsl:if test=".[. = 'K']"> </xsl:if><xsl:if test=".[. = 'R']"> </xsl:if><xsl:if test=".[. = 'M']"> </xsl:if><xsl:if test=".[. = 'X']"> </xsl:if></xsl:for-each> <xsl:for-each select="*[@*='x3' or @*='x2']">  <xsl:if test=".[. $lt$ 100]"> </xsl:if><xsl:if test=".[. $lt$ 10]"> </xsl:if><xsl:if test=".[. $gt$ 0]"> </xsl:if><xsl:value-of/></xsl:for-each> <xsl:for-each select="*[@*='y3' or @*='y2']">    <xsl:if test=".[. $lt$ 10000]"> </xsl:if><xsl:if test=".[. $lt$ 10]"> </xsl:if><xsl:if test=".[. $gt$ 0]"> </xsl:if><xsl:value-of/></xsl:for-each> <xsl:choose><xsl:when test="*[@*='z3']"><xsl:for-each select="*[@*='z3']">    <xsl:if test=".[. $lt$ 10000]"> </xsl:if><xsl:if test=".[. $lt$ 10]"> </xsl:if><xsl:if test=".[. $gt$ 0]"> </xsl:if><xsl:value-of/></xsl:for-each></xsl:when><xsl:otherwise>    0.0000</xsl:otherwise></xsl:choose></xsl:for-each>
</xsl:for-each></xsl:element>
</xsl:template>

<!-- ************************************************************ -->
<!-- ************************ Link: jmeRaw ********************** -->
<!-- ************************************************************ -->
<xsl:template match="docml:link[@type='molecule' and @display='jmeRaw']">
<!-- set default row and col of 5:80 unless specified -->
<xsl:element name="textarea" xml:space="preserve"><xsl:attribute name="rows"><xsl:choose><xsl:when test="@rows | @ROWS"><xsl:value-of select="@rows | @ROWS"/></xsl:when><xsl:otherwise>5</xsl:otherwise></xsl:choose></xsl:attribute><xsl:attribute name="cols"><xsl:choose><xsl:when test="@cols | COLS"><xsl:value-of select="@cols | @COLS"/></xsl:when><xsl:otherwise>80</xsl:otherwise></xsl:choose></xsl:attribute><xsl:for-each select="id(@idref)" xml:space="preserve"><xsl:for-each select="*/atom[end()]"><xsl:eval>formatIndex(childNumber(this), "1")</xsl:eval></xsl:for-each> <xsl:for-each select="*/bond[end()]"><xsl:eval>formatIndex(childNumber(this), "1")</xsl:eval></xsl:for-each><xsl:for-each select="*/atom"> <xsl:value-of select="*[@* = 'elementType']"/> <xsl:value-of select="*[@* = 'x3' or @* = 'x2']"/> <xsl:value-of select="*[@* = 'y3' or @* = 'y2']"/></xsl:for-each><xsl:for-each select="*/bond"><xsl:for-each select="*[@* = 'atomRef']"> <xsl:for-each select="//atom[@id = context()]"><xsl:eval>formatIndex(childNumber(this), "1")</xsl:eval></xsl:for-each></xsl:for-each> <xsl:value-of select="*[@* = 'order']"/></xsl:for-each>
</xsl:for-each></xsl:element>
</xsl:template>

<!-- ************************************************************ -->
<!-- *********************** Link: jcampRaw ********************* -->
<!-- ************************************************************ -->
<xsl:template match="docml:link[@type='spectrum' and @display='jcampRaw']">
<textarea><xsl:attribute name="rows"><xsl:choose><xsl:when test="@rows"><xsl:value-of select="@rows"/></xsl:when><xsl:otherwise>10</xsl:otherwise></xsl:choose></xsl:attribute>
<xsl:attribute name="cols"><xsl:choose><xsl:when test="@cols"><xsl:value-of select="@cols"/></xsl:when><xsl:otherwise>80</xsl:otherwise></xsl:choose></xsl:attribute><xsl:for-each select="id(@idref)">
##TITLE= <xsl:value-of select="@title"/>
##<xsl:value-of select="@convention"/>
##DATA TYPE= <xsl:value-of select="*[@title='datatype']"/>
##XUNITS= <xsl:value-of select="*[@title='xunits']"/>
##YUNITS= <xsl:value-of select="*[@title='yunits']"/>
##FIRSTX= <xsl:value-of select="*[@title='firstx']"/>
##LASTX= <xsl:value-of select="*[@title='lastx']"/>
##FIRSTY= <xsl:value-of select="*[@title='firsty']"/>
##MINY= <xsl:value-of select="*[@title='miny']"/>
##MAXY= <xsl:value-of select="*[@title='miny']"/>
##NPOINTS= <xsl:value-of select="*[@title='npoints']"/>
<xsl:for-each select="*[@title='peak table' and @convention='(XY..XY)']">##PEAK TABLE= (XY..XY)<xsl:for-each select="coordinate2"><xsl:value-of/> </xsl:for-each></xsl:for-each><xsl:for-each select="*[@title='xypairs' and @convention='(XY..XY)']">##XYDATA= (X++(Y..Y))<xsl:for-each select="coordinate2">
<xsl:value-of/> </xsl:for-each></xsl:for-each><xsl:for-each select="*[@title='peak table' and @convention='(XYM)']" xml:space="preserve">##XYDATA= (XYM)<xsl:for-each select="coordinate3"><xsl:value-of/> 
</xsl:for-each></xsl:for-each>
##END=
</xsl:for-each></textarea>
</xsl:template>

<!-- ************************************************************ -->
<!-- ************************* Link: jme ************************ -->
<!-- ************************************************************ -->
<xsl:template match="docml:link[@type='molecule' and @display='jme'] | docml:link[@type='molecule' and @display='jmeSimple']">
<applet code="JME.class" archive="applets/JME.jar">
<xsl:attribute name="name">JME_<xsl:value-of select="@idref"/></xsl:attribute>
<xsl:attribute name="width"><xsl:choose><xsl:when test="@width"><xsl:value-of select="@width"/></xsl:when><xsl:otherwise>100%</xsl:otherwise></xsl:choose></xsl:attribute>
<xsl:attribute name="height"><xsl:choose><xsl:when test="@height"><xsl:value-of select="@height"/></xsl:when><xsl:otherwise>100%</xsl:otherwise></xsl:choose></xsl:attribute>
<xsl:if test=".[@display='jmeSimple']"><param name="options" value="depict"/></xsl:if>
You have to enable Java and JavaScript on your machine !</applet>
	<!-- hidden form element contains the jme source -->
	<xsl:element name="input">
		<xsl:attribute name="name">jmeoutput_<xsl:value-of select="@idref"/></xsl:attribute>
		<xsl:attribute name="type">hidden</xsl:attribute>
		<xsl:attribute name="value"><xsl:for-each select="id(@idref)" xml:space="preserve"><xsl:for-each select="*/atom[end()]"><xsl:eval>formatIndex(childNumber(this), "1")</xsl:eval></xsl:for-each> <xsl:for-each select="*/bond[end()]"><xsl:eval>formatIndex(childNumber(this), "1")</xsl:eval></xsl:for-each><xsl:for-each select="*/atom"> <xsl:value-of select="*[@* = 'elementType']"/> <xsl:value-of select="*[@* = 'x3' or @* = 'x2']"/> <xsl:value-of select="*[@* = 'y3' or @* = 'y2']"/></xsl:for-each><xsl:for-each select="*/bond"><xsl:for-each select="*[@* = 'atomRef']"> <xsl:for-each select="//atom[@id = context()]"><xsl:eval>formatIndex(childNumber(this), "1")</xsl:eval></xsl:for-each></xsl:for-each> <xsl:value-of select="*[@* = 'order']"/></xsl:for-each>
</xsl:for-each></xsl:attribute>
	</xsl:element>
</xsl:template>

<!-- ************************************************************ -->
<!-- ************************* Link: jmol *********************** -->
<!-- ************************************************************ -->
<xsl:template match="docml:link[@type='molecule' and @display='jmol']">
<applet code="org.openscience.miniJmol.JmolApplet.class" archive="applets/JmolApplet.jar">
<xsl:attribute name="name">JMolApplet_<xsl:value-of select="@idref"/></xsl:attribute>
<xsl:attribute name="width"><xsl:choose><xsl:when test="@width"><xsl:value-of select="@width"/></xsl:when><xsl:otherwise>300</xsl:otherwise></xsl:choose></xsl:attribute>
<xsl:attribute name="height"><xsl:choose><xsl:when test="@height"><xsl:value-of select="@height"/></xsl:when><xsl:otherwise>300</xsl:otherwise></xsl:choose></xsl:attribute>
You have to enable Java and JavaScript on your machine !</applet>
<input name="jmolcolour" type="hidden" value="#EEEEFF"/>
<xsl:element name="input">
	<xsl:attribute name="name">jmoloutput_<xsl:value-of select="@idref"/></xsl:attribute>
	<xsl:attribute name="type">hidden</xsl:attribute>
	<xsl:attribute name="value"><xsl:for-each select="id(@idref)" xml:space="preserve">
<xsl:for-each select="*/atom[end()]"><xsl:eval>formatIndex(childNumber(this), "1")</xsl:eval></xsl:for-each>%
<xsl:value-of select="@title"/><xsl:for-each select="*/atom">%
<xsl:for-each select="*[@*='elementType']"><xsl:value-of select="."/><xsl:if test=".[. = 'H']"> </xsl:if><xsl:if test=".[. = 'B']"> </xsl:if><xsl:if test=".[. = 'C']"> </xsl:if><xsl:if test=".[. = 'N']"> </xsl:if><xsl:if test=".[. = 'O']"> </xsl:if><xsl:if test=".[. = 'F']"> </xsl:if><xsl:if test=".[. = 'P']"> </xsl:if><xsl:if test=".[. = 'S']"> </xsl:if><xsl:if test=".[. = 'I']"> </xsl:if><xsl:if test=".[. = 'K']"> </xsl:if><xsl:if test=".[. = 'R']"> </xsl:if><xsl:if test=".[. = 'M']"> </xsl:if><xsl:if test=".[. = 'X']"> </xsl:if></xsl:for-each> <xsl:for-each select="*[@*='x3' or @*='x2']">  <xsl:if test=".[. $lt$ 100]"> </xsl:if><xsl:if test=".[. $lt$ 10]"> </xsl:if><xsl:if test=".[. $gt$ 0]"> </xsl:if><xsl:value-of/></xsl:for-each> <xsl:for-each select="*[@*='y3' or @*='y2']">    <xsl:if test=".[. $lt$ 10000]"> </xsl:if><xsl:if test=".[. $lt$ 10]"> </xsl:if><xsl:if test=".[. $gt$ 0]"> </xsl:if><xsl:value-of/></xsl:for-each> <xsl:choose><xsl:when test="*[@*='z3']"><xsl:for-each select="*[@*='z3']">    <xsl:if test=".[. $lt$ 10000]"> </xsl:if><xsl:if test=".[. $lt$ 10]"> </xsl:if><xsl:if test=".[. $gt$ 0]"> </xsl:if><xsl:value-of/></xsl:for-each></xsl:when><xsl:otherwise>    0.0000</xsl:otherwise></xsl:choose></xsl:for-each>%
</xsl:for-each></xsl:attribute>
	</xsl:element>
</xsl:template>

<!-- ************************************************************ -->
<!-- *********************** Link: jspec ************************ -->
<!-- ************************************************************ -->
<xsl:template match="docml:link[@type='spectrum' and @display='jspec']">
<xsl:element name="applet">
<xsl:attribute name="code">Visua.class</xsl:attribute>
<xsl:attribute name="archive">applets/Jspec.jar</xsl:attribute>
<xsl:attribute name="width"><xsl:choose><xsl:when test="@width"><xsl:value-of select="@width"/></xsl:when><xsl:otherwise>400</xsl:otherwise></xsl:choose></xsl:attribute>
<xsl:attribute name="height"><xsl:choose><xsl:when test="@height"><xsl:value-of select="@height"/></xsl:when><xsl:otherwise>250</xsl:otherwise></xsl:choose></xsl:attribute>
<xsl:for-each select="id(@idref)">
<xsl:element name="param">
	<xsl:attribute name="name">SOURCE</xsl:attribute>
	<xsl:attribute name="value" xml:space="preserve">
##TITLE= <xsl:value-of select="@title"/>
##<xsl:value-of select="@convention"/>
##DATA TYPE= <xsl:value-of select="*[@title='datatype']"/>
##XUNITS= <xsl:value-of select="*[@title='xunits']"/>
##YUNITS= <xsl:value-of select="*[@title='yunits']"/>
##FIRSTX= <xsl:value-of select="*[@title='firstx']"/>
##LASTX= <xsl:value-of select="*[@title='lastx']"/>
##FIRSTY= <xsl:value-of select="*[@title='firsty']"/>
##MINY= <xsl:value-of select="*[@title='miny']"/>
##MAXY= <xsl:value-of select="*[@title='miny']"/>
##NPOINTS= <xsl:value-of select="*[@title='npoints']"/>
<xsl:for-each select="*[@title='peak table' and @convention='(XY..XY)']">##PEAK TABLE= (XY..XY)<xsl:for-each select="coordinate2">
<xsl:value-of/>,</xsl:for-each></xsl:for-each><xsl:for-each select="*[@title='xypairs' and @convention='(XY..XY)']">##XYDATA= (X++(Y..Y))<xsl:for-each select="coordinate2">
<xsl:value-of/>,</xsl:for-each></xsl:for-each><xsl:for-each select="*[@title='peak table' and @convention='(XYM)']" xml:space="preserve">##XYDATA= (XYM)<xsl:for-each select="coordinate3"><xsl:value-of/>,
</xsl:for-each></xsl:for-each>
##END=</xsl:attribute></xsl:element>
<!-- Reverses IR spectra -->
<xsl:if test="*[@title='datatype' and .='INFRARED SPECTRUM']">
	<param name="WAY" value="REVERSE"/>
</xsl:if></xsl:for-each></xsl:element>
</xsl:template>

<!-- ************************************************************ -->
<!-- ************************* Link: marvin ********************* -->
<!-- ************************************************************ -->
<xsl:template match="docml:link[@type='molecule' and @display='marvin']">
<xsl:element name="applet">
<xsl:attribute name="code">MView</xsl:attribute>
<xsl:attribute name="archive">applets/marvin.jar</xsl:attribute>
<xsl:attribute name="width"><xsl:choose><xsl:when test="@width"><xsl:value-of select="@width"/></xsl:when><xsl:otherwise>300</xsl:otherwise></xsl:choose></xsl:attribute>
<xsl:attribute name="height"><xsl:choose><xsl:when test="@height"><xsl:value-of select="@height"/></xsl:when><xsl:otherwise>300</xsl:otherwise></xsl:choose></xsl:attribute>
<xsl:element name="param">
		<xsl:attribute name="name">mol</xsl:attribute>
		<xsl:attribute name="value"><xsl:for-each select="id(@idref)" xml:space="preserve">
<xsl:value-of select="@title"/>\
CMLconvert0828001552<xsl:choose><xsl:when test="*/*/*[@*='z3']">3D</xsl:when><xsl:otherwise>2D</xsl:otherwise></xsl:choose> 1 0.00366  0.00000     0\
From CML - date inaccurate\
<xsl:for-each select="*/atom[end()]"><xsl:if expr="(childNumber(this) &lt; 100)"> </xsl:if><xsl:if expr="(childNumber(this) &lt; 10)"> </xsl:if><xsl:eval>formatIndex(childNumber(this), "1")</xsl:eval></xsl:for-each><xsl:for-each select="*/bond[end()]"><xsl:if expr="(childNumber(this) &lt; 100)"> </xsl:if><xsl:if expr="(childNumber(this) &lt; 10)"> </xsl:if><xsl:eval>formatIndex(childNumber(this), "1")</xsl:eval></xsl:for-each>  0  0  0  0              0 v2000\<xsl:for-each select="*/atom">
<xsl:for-each select="*[@*='x3' or @*='x2']"> <xsl:if test=".[. $lt$ 100]"> </xsl:if><xsl:if test=".[. $lt$ 10]"> </xsl:if><xsl:if test=".[. $gt$ 0]"> </xsl:if><xsl:value-of/></xsl:for-each> <xsl:for-each select="*[@*='y3' or @*='y2']"><xsl:if test=".[. $lt$ 10000]"> </xsl:if><xsl:if test=".[. $lt$ 10]"> </xsl:if><xsl:if test=".[. $gt$ 0]"> </xsl:if><xsl:value-of/></xsl:for-each> <xsl:choose><xsl:when test="*[@*='z3']"><xsl:for-each select="*[@*='z3']"><xsl:if test=".[. $lt$ 10000]"> </xsl:if><xsl:if test=".[. $lt$ 10]"> </xsl:if><xsl:if test=".[. $gt$ 0]"> </xsl:if><xsl:value-of/></xsl:for-each></xsl:when><xsl:otherwise>   0.0000</xsl:otherwise></xsl:choose> <xsl:for-each select="*[@*='elementType']"><xsl:value-of select="."/><xsl:if test=".[. = 'H']"> </xsl:if><xsl:if test=".[. = 'B']"> </xsl:if><xsl:if test=".[. = 'C']"> </xsl:if><xsl:if test=".[. = 'N']"> </xsl:if><xsl:if test=".[. = 'O']"> </xsl:if><xsl:if test=".[. = 'F']"> </xsl:if><xsl:if test=".[. = 'P']"> </xsl:if><xsl:if test=".[. = 'S']"> </xsl:if><xsl:if test=".[. = 'I']"> </xsl:if><xsl:if test=".[. = 'K']"> </xsl:if><xsl:if test=".[. = 'R']"> </xsl:if><xsl:if test=".[. = 'M']"> </xsl:if><xsl:if test=".[. = 'X']"> </xsl:if></xsl:for-each>  0  0  0  0  0\</xsl:for-each>
<xsl:for-each select="*/bond"><xsl:for-each select="*[@*='atomRef']"><xsl:for-each select="//atom[@id = context()]"><xsl:if expr="(childNumber(this) &lt; 100)"> </xsl:if><xsl:if expr="(childNumber(this) &lt; 10)"> </xsl:if><xsl:eval>formatIndex(childNumber(this), "1")</xsl:eval></xsl:for-each></xsl:for-each><xsl:for-each select="*[@*='order']"><xsl:if test=".[. $lt$ 100]"> </xsl:if><xsl:if test=".[. $lt$ 10]"> </xsl:if><xsl:value-of select="."/></xsl:for-each>  0  0  0\
</xsl:for-each>M  END\
</xsl:for-each></xsl:attribute>
</xsl:element>
<xsl:element name="param"><xsl:attribute name="name">molbg</xsl:attribute><xsl:attribute name="value"><xsl:choose><xsl:when test="../.[@type='coloured']">#EEEEFF</xsl:when><xsl:otherwise>#FFFFFF</xsl:otherwise></xsl:choose></xsl:attribute></xsl:element>
<param name="mag" value="50"/>
<param name="atomsize" value="0.5"/>
<param name="animate" value="all"/>
<param name="dispopts" value="dim=3"/>
	You must have Java turned on!
</xsl:element>
</xsl:template>

<!-- ************************************************************ -->
<!-- ************************* Link: SDA ************************ -->
<!-- ************************************************************ -->
<xsl:template match="docml:link[@type='molecule' and @display='sda']">
<xsl:element name="applet">
<xsl:attribute name="name">ACD-SDA</xsl:attribute>
<xsl:attribute name="code">StructureEditorApplet.class</xsl:attribute>
<xsl:attribute name="archive">applets/sda.jar</xsl:attribute>
<xsl:attribute name="width"><xsl:choose><xsl:when test="@width"><xsl:value-of select="@width"/></xsl:when><xsl:otherwise>400</xsl:otherwise></xsl:choose></xsl:attribute>
<xsl:attribute name="height"><xsl:choose><xsl:when test="@height"><xsl:value-of select="@height"/></xsl:when><xsl:otherwise>400</xsl:otherwise></xsl:choose></xsl:attribute>
<xsl:element name="param"><xsl:attribute name="name">molContent</xsl:attribute><xsl:attribute name="value"><xsl:for-each select="id(@idref)" xml:space="preserve">
<xsl:value-of select="@title"/>|
CMLconvert0828001552<xsl:choose><xsl:when test="*/*/*[@*='z3']">3D</xsl:when><xsl:otherwise>2D</xsl:otherwise></xsl:choose> 1 0.00366  0.00000     0|
From CML - date inaccurate|
<xsl:for-each select="*/atom[end()]"><xsl:if expr="(childNumber(this) &lt; 100)"> </xsl:if><xsl:if expr="(childNumber(this) &lt; 10)"> </xsl:if><xsl:eval>formatIndex(childNumber(this), "1")</xsl:eval></xsl:for-each><xsl:for-each select="*/bond[end()]"><xsl:if expr="(childNumber(this) &lt; 100)"> </xsl:if><xsl:if expr="(childNumber(this) &lt; 10)"> </xsl:if><xsl:eval>formatIndex(childNumber(this), "1")</xsl:eval></xsl:for-each>  0  0  0  0              0 v2000|<xsl:for-each select="*/atom">
<xsl:for-each select="*[@*='x3' or @*='x2']"> <xsl:if test=".[. $lt$ 100]"> </xsl:if><xsl:if test=".[. $lt$ 10]"> </xsl:if><xsl:if test=".[. $gt$ 0]"> </xsl:if><xsl:value-of/></xsl:for-each> <xsl:for-each select="*[@*='y3' or @*='y2']"><xsl:if test=".[. $lt$ 10000]"> </xsl:if><xsl:if test=".[. $lt$ 10]"> </xsl:if><xsl:if test=".[. $gt$ 0]"> </xsl:if><xsl:value-of/></xsl:for-each> <xsl:choose><xsl:when test="*[@*='z3']"><xsl:for-each select="*[@*='z3']"><xsl:if test=".[. $lt$ 10000]"> </xsl:if><xsl:if test=".[. $lt$ 10]"> </xsl:if><xsl:if test=".[. $gt$ 0]"> </xsl:if><xsl:value-of/></xsl:for-each></xsl:when><xsl:otherwise>   0.0000</xsl:otherwise></xsl:choose> <xsl:for-each select="*[@*='elementType']"><xsl:value-of select="."/><xsl:if test=".[. = 'H']"> </xsl:if><xsl:if test=".[. = 'B']"> </xsl:if><xsl:if test=".[. = 'C']"> </xsl:if><xsl:if test=".[. = 'N']"> </xsl:if><xsl:if test=".[. = 'O']"> </xsl:if><xsl:if test=".[. = 'F']"> </xsl:if><xsl:if test=".[. = 'P']"> </xsl:if><xsl:if test=".[. = 'S']"> </xsl:if><xsl:if test=".[. = 'I']"> </xsl:if><xsl:if test=".[. = 'K']"> </xsl:if><xsl:if test=".[. = 'R']"> </xsl:if><xsl:if test=".[. = 'M']"> </xsl:if><xsl:if test=".[. = 'X']"> </xsl:if></xsl:for-each>  0  0  0  0  0|</xsl:for-each>
<xsl:for-each select="*/bond"><xsl:for-each select="*[@*='atomRef']"><xsl:for-each select="//atom[@id = context()]"><xsl:if expr="(childNumber(this) &lt; 100)"> </xsl:if><xsl:if expr="(childNumber(this) &lt; 10)"> </xsl:if><xsl:eval>formatIndex(childNumber(this), "1")</xsl:eval></xsl:for-each></xsl:for-each><xsl:for-each select="*[@*='order']"><xsl:if test=".[. $lt$ 100]"> </xsl:if><xsl:if test=".[. $lt$ 10]"> </xsl:if><xsl:value-of select="."/></xsl:for-each>  0  0  0|
</xsl:for-each>M  END|
</xsl:for-each></xsl:attribute>
	</xsl:element>
	<!-- change PARAMs as needed - more found at http://www.acdlabs.com/products/java/sda/params.html -->
<param name="backgroundColor" value="#CCCCFF"/>
	You must have Java turned on!
</xsl:element>	
</xsl:template>

<!-- ************************************************************ -->
<!-- ************************* Link: Jumbo3 ************************ -->
<!-- ************************************************************ -->
<xsl:template match="docml:link[@type='molecule' and @display='svg']">
<table width="100%">
<tr><td><xsl:attribute name="name">svgcont_<xsl:value-of select="@idref"/></xsl:attribute>
controls
</td><td><xsl:attribute name="name">svgdisp_<xsl:value-of select="@idref"/></xsl:attribute>
<embed name="molecule" width="300" height="300"
			src="display.svg" type="image/svg" />
</td></tr>
</table>
<xml><xsl:attribute name="id">cmlinput_<xsl:value-of select="@idref"/></xsl:attribute>
<xsl:for-each select="id(@idref)"><xsl:apply-templates select="."/></xsl:for-each></xml>
</xsl:template>

<!-- ************************************************************ -->
<!-- ****************** Link: stepwise reaction ***************** -->
<!-- ************************************************************ -->
<xsl:template match="docml:link[@type='reaction' and @display='stepwise']">
<xsl:for-each select="id(@idref)"><table>
<tr>
    <td colspan="2" class="box_coloured"><b>Stepwise Reaction:</b> <xsl:value-of select="@title"/></td>
    <td class="box_coloured"><b>id:</b> <xsl:value-of select="@id"/></td>
</tr>
<tr>
    <td colspan="2" class="box_coloured"><b>Description:</b> <xsl:value-of select="*[@*='description']"/></td>
    <td class="box_coloured"><b>Yield:</b> <xsl:if test="*[@*='yield']"><xsl:value-of select="*[@*='yield']"/> %</xsl:if></td>
</tr>
<tr>
    <td colspan="3" class="box_coloured"><b>Notes:</b> <xsl:value-of select="*[@*='notes']"/></td>
</tr>
<xsl:for-each select="*[@*='reactionStep']">
<tr>
    <td colspan="3" align="center" class="box_coloured">
	<table bgcolor="#FFFFFF">
		<tr>
   		<td align="center">
		<xsl:for-each select="*[@*='reactant']"> 
		 <xsl:for-each select="id(@href)">
		 <xsl:element name="applet">
<xsl:attribute name="code">MView</xsl:attribute>
<xsl:attribute name="archive">applets/marvin.jar</xsl:attribute>
<xsl:attribute name="width">150</xsl:attribute>
<xsl:attribute name="height">150</xsl:attribute>
<xsl:element name="param">
		<xsl:attribute name="name">mol</xsl:attribute>
		<xsl:attribute name="value" xml:space="preserve">
<xsl:value-of select="@title"/>\
CMLconvert0828001552<xsl:choose><xsl:when test="*/*/*[@*='z3']">3D</xsl:when><xsl:otherwise>2D</xsl:otherwise></xsl:choose> 1 0.00366  0.00000     0\
From CML - date inaccurate\
<xsl:for-each select="*/atom[end()]"><xsl:if expr="(childNumber(this) &lt; 100)"> </xsl:if><xsl:if expr="(childNumber(this) &lt; 10)"> </xsl:if><xsl:eval>formatIndex(childNumber(this), "1")</xsl:eval></xsl:for-each><xsl:for-each select="*/bond[end()]"><xsl:if expr="(childNumber(this) &lt; 100)"> </xsl:if><xsl:if expr="(childNumber(this) &lt; 10)"> </xsl:if><xsl:eval>formatIndex(childNumber(this), "1")</xsl:eval></xsl:for-each>  0  0  0  0              0 v2000\<xsl:for-each select="*/atom">
<xsl:for-each select="*[@*='x3' or @*='x2']"> <xsl:if test=".[. $lt$ 100]"> </xsl:if><xsl:if test=".[. $lt$ 10]"> </xsl:if><xsl:if test=".[. $gt$ 0]"> </xsl:if><xsl:value-of/></xsl:for-each> <xsl:for-each select="*[@*='y3' or @*='y2']"><xsl:if test=".[. $lt$ 10000]"> </xsl:if><xsl:if test=".[. $lt$ 10]"> </xsl:if><xsl:if test=".[. $gt$ 0]"> </xsl:if><xsl:value-of/></xsl:for-each> <xsl:choose><xsl:when test="*[@*='z3']"><xsl:for-each select="*[@*='z3']"><xsl:if test=".[. $lt$ 10000]"> </xsl:if><xsl:if test=".[. $lt$ 10]"> </xsl:if><xsl:if test=".[. $gt$ 0]"> </xsl:if><xsl:value-of/></xsl:for-each></xsl:when><xsl:otherwise>   0.0000</xsl:otherwise></xsl:choose> <xsl:for-each select="*[@*='elementType']"><xsl:value-of select="."/><xsl:if test=".[. = 'H']"> </xsl:if><xsl:if test=".[. = 'B']"> </xsl:if><xsl:if test=".[. = 'C']"> </xsl:if><xsl:if test=".[. = 'N']"> </xsl:if><xsl:if test=".[. = 'O']"> </xsl:if><xsl:if test=".[. = 'F']"> </xsl:if><xsl:if test=".[. = 'P']"> </xsl:if><xsl:if test=".[. = 'S']"> </xsl:if><xsl:if test=".[. = 'I']"> </xsl:if><xsl:if test=".[. = 'K']"> </xsl:if><xsl:if test=".[. = 'R']"> </xsl:if><xsl:if test=".[. = 'M']"> </xsl:if><xsl:if test=".[. = 'X']"> </xsl:if></xsl:for-each>  0  0  0  0  0\</xsl:for-each>
<xsl:for-each select="*/bond"><xsl:for-each select="*[@*='atomRef']"><xsl:for-each select="//atom[@id = context()]"><xsl:if expr="(childNumber(this) &lt; 100)"> </xsl:if><xsl:if expr="(childNumber(this) &lt; 10)"> </xsl:if><xsl:eval>formatIndex(childNumber(this), "1")</xsl:eval></xsl:for-each></xsl:for-each><xsl:for-each select="*[@*='order']"><xsl:if test=".[. $lt$ 100]"> </xsl:if><xsl:if test=".[. $lt$ 10]"> </xsl:if><xsl:value-of select="."/></xsl:for-each>  0  0  0\
</xsl:for-each>M  END\
</xsl:attribute>
</xsl:element><param name="molbg" value="#FFFFFF"/></xsl:element>
		 </xsl:for-each>
		</xsl:for-each></td>
 		<td align="center"><img src="images\webimages/arrow.gif" width="120" height="20" alt="arrow" border="0"/><br/>
		<font size="-2">
		<xsl:for-each select="*[@*='reagent']"> 
		<xsl:if test="*[@*='index']"><b><xsl:value-of select="*[@*='index']"/>) </b></xsl:if> 
		<xsl:for-each select="id(@href)"><xsl:element name="applet">
<xsl:attribute name="code">MView</xsl:attribute>
<xsl:attribute name="archive">applets/marvin.jar</xsl:attribute>
<xsl:attribute name="width">80</xsl:attribute>
<xsl:attribute name="height">80</xsl:attribute>
<xsl:element name="param">
		<xsl:attribute name="name">mol</xsl:attribute>
		<xsl:attribute name="value" xml:space="preserve">
<xsl:value-of select="@title"/>\
CMLconvert0828001552<xsl:choose><xsl:when test="*/*/*[@*='z3']">3D</xsl:when><xsl:otherwise>2D</xsl:otherwise></xsl:choose> 1 0.00366  0.00000     0\
From CML - date inaccurate\
<xsl:for-each select="*/atom[end()]"><xsl:if expr="(childNumber(this) &lt; 100)"> </xsl:if><xsl:if expr="(childNumber(this) &lt; 10)"> </xsl:if><xsl:eval>formatIndex(childNumber(this), "1")</xsl:eval></xsl:for-each><xsl:for-each select="*/bond[end()]"><xsl:if expr="(childNumber(this) &lt; 100)"> </xsl:if><xsl:if expr="(childNumber(this) &lt; 10)"> </xsl:if><xsl:eval>formatIndex(childNumber(this), "1")</xsl:eval></xsl:for-each>  0  0  0  0              0 v2000\<xsl:for-each select="*/atom">
<xsl:for-each select="*[@*='x3' or @*='x2']"> <xsl:if test=".[. $lt$ 100]"> </xsl:if><xsl:if test=".[. $lt$ 10]"> </xsl:if><xsl:if test=".[. $gt$ 0]"> </xsl:if><xsl:value-of/></xsl:for-each> <xsl:for-each select="*[@*='y3' or @*='y2']"><xsl:if test=".[. $lt$ 10000]"> </xsl:if><xsl:if test=".[. $lt$ 10]"> </xsl:if><xsl:if test=".[. $gt$ 0]"> </xsl:if><xsl:value-of/></xsl:for-each> <xsl:choose><xsl:when test="*[@*='z3']"><xsl:for-each select="*[@*='z3']"><xsl:if test=".[. $lt$ 10000]"> </xsl:if><xsl:if test=".[. $lt$ 10]"> </xsl:if><xsl:if test=".[. $gt$ 0]"> </xsl:if><xsl:value-of/></xsl:for-each></xsl:when><xsl:otherwise>   0.0000</xsl:otherwise></xsl:choose> <xsl:for-each select="*[@*='elementType']"><xsl:value-of select="."/><xsl:if test=".[. = 'H']"> </xsl:if><xsl:if test=".[. = 'B']"> </xsl:if><xsl:if test=".[. = 'C']"> </xsl:if><xsl:if test=".[. = 'N']"> </xsl:if><xsl:if test=".[. = 'O']"> </xsl:if><xsl:if test=".[. = 'F']"> </xsl:if><xsl:if test=".[. = 'P']"> </xsl:if><xsl:if test=".[. = 'S']"> </xsl:if><xsl:if test=".[. = 'I']"> </xsl:if><xsl:if test=".[. = 'K']"> </xsl:if><xsl:if test=".[. = 'R']"> </xsl:if><xsl:if test=".[. = 'M']"> </xsl:if><xsl:if test=".[. = 'X']"> </xsl:if></xsl:for-each>  0  0  0  0  0\</xsl:for-each>
<xsl:for-each select="*/bond"><xsl:for-each select="*[@*='atomRef']"><xsl:for-each select="//atom[@id = context()]"><xsl:if expr="(childNumber(this) &lt; 100)"> </xsl:if><xsl:if expr="(childNumber(this) &lt; 10)"> </xsl:if><xsl:eval>formatIndex(childNumber(this), "1")</xsl:eval></xsl:for-each></xsl:for-each><xsl:for-each select="*[@*='order']"><xsl:if test=".[. $lt$ 100]"> </xsl:if><xsl:if test=".[. $lt$ 10]"> </xsl:if><xsl:value-of select="."/></xsl:for-each>  0  0  0\
</xsl:for-each>M  END\
</xsl:attribute>
</xsl:element><param name="molbg" value="#FFFFFF"/></xsl:element>
		 , </xsl:for-each>
		<xsl:for-each select="*[@*='solvent']"> <xsl:value-of select="text()"/>, </xsl:for-each>
		<xsl:for-each select="*[@*='temperature']"> <xsl:value-of select="text()"/><xsl:if test=".[@convention='degC']"> <sup>o</sup>C</xsl:if>, </xsl:for-each>
		<xsl:for-each select="*[@*='duration']"> <xsl:value-of select="text()"/> <xsl:value-of select="@convention"/>, </xsl:for-each>
		<xsl:for-each select="*[@*='notes']"> <xsl:value-of select="text()"/>, </xsl:for-each><br/>
		</xsl:for-each>
		</font></td>
    	<td align="center">
		<xsl:for-each select="*[@*='product']"> 
		 <xsl:for-each select="id(@href)"><xsl:element name="applet">
<xsl:attribute name="code">MView</xsl:attribute>
<xsl:attribute name="archive">applets/marvin.jar</xsl:attribute>
<xsl:attribute name="width">150</xsl:attribute>
<xsl:attribute name="height">150</xsl:attribute>
<xsl:element name="param">
		<xsl:attribute name="name">mol</xsl:attribute>
		<xsl:attribute name="value" xml:space="preserve">
<xsl:value-of select="@title"/>\
CMLconvert0828001552<xsl:choose><xsl:when test="*/*/*[@*='z3']">3D</xsl:when><xsl:otherwise>2D</xsl:otherwise></xsl:choose> 1 0.00366  0.00000     0\
From CML - date inaccurate\
<xsl:for-each select="*/atom[end()]"><xsl:if expr="(childNumber(this) &lt; 100)"> </xsl:if><xsl:if expr="(childNumber(this) &lt; 10)"> </xsl:if><xsl:eval>formatIndex(childNumber(this), "1")</xsl:eval></xsl:for-each><xsl:for-each select="*/bond[end()]"><xsl:if expr="(childNumber(this) &lt; 100)"> </xsl:if><xsl:if expr="(childNumber(this) &lt; 10)"> </xsl:if><xsl:eval>formatIndex(childNumber(this), "1")</xsl:eval></xsl:for-each>  0  0  0  0              0 v2000\<xsl:for-each select="*/atom">
<xsl:for-each select="*[@*='x3' or @*='x2']"> <xsl:if test=".[. $lt$ 100]"> </xsl:if><xsl:if test=".[. $lt$ 10]"> </xsl:if><xsl:if test=".[. $gt$ 0]"> </xsl:if><xsl:value-of/></xsl:for-each> <xsl:for-each select="*[@*='y3' or @*='y2']"><xsl:if test=".[. $lt$ 10000]"> </xsl:if><xsl:if test=".[. $lt$ 10]"> </xsl:if><xsl:if test=".[. $gt$ 0]"> </xsl:if><xsl:value-of/></xsl:for-each> <xsl:choose><xsl:when test="*[@*='z3']"><xsl:for-each select="*[@*='z3']"><xsl:if test=".[. $lt$ 10000]"> </xsl:if><xsl:if test=".[. $lt$ 10]"> </xsl:if><xsl:if test=".[. $gt$ 0]"> </xsl:if><xsl:value-of/></xsl:for-each></xsl:when><xsl:otherwise>   0.0000</xsl:otherwise></xsl:choose> <xsl:for-each select="*[@*='elementType']"><xsl:value-of select="."/><xsl:if test=".[. = 'H']"> </xsl:if><xsl:if test=".[. = 'B']"> </xsl:if><xsl:if test=".[. = 'C']"> </xsl:if><xsl:if test=".[. = 'N']"> </xsl:if><xsl:if test=".[. = 'O']"> </xsl:if><xsl:if test=".[. = 'F']"> </xsl:if><xsl:if test=".[. = 'P']"> </xsl:if><xsl:if test=".[. = 'S']"> </xsl:if><xsl:if test=".[. = 'I']"> </xsl:if><xsl:if test=".[. = 'K']"> </xsl:if><xsl:if test=".[. = 'R']"> </xsl:if><xsl:if test=".[. = 'M']"> </xsl:if><xsl:if test=".[. = 'X']"> </xsl:if></xsl:for-each>  0  0  0  0  0\</xsl:for-each>
<xsl:for-each select="*/bond"><xsl:for-each select="*[@*='atomRef']"><xsl:for-each select="//atom[@id = context()]"><xsl:if expr="(childNumber(this) &lt; 100)"> </xsl:if><xsl:if expr="(childNumber(this) &lt; 10)"> </xsl:if><xsl:eval>formatIndex(childNumber(this), "1")</xsl:eval></xsl:for-each></xsl:for-each><xsl:for-each select="*[@*='order']"><xsl:if test=".[. $lt$ 100]"> </xsl:if><xsl:if test=".[. $lt$ 10]"> </xsl:if><xsl:value-of select="."/></xsl:for-each>  0  0  0\
</xsl:for-each>M  END\
</xsl:attribute>
</xsl:element><param name="molbg" value="#FFFFFF"/></xsl:element>
		 </xsl:for-each>
		</xsl:for-each></td>
		</tr>
	</table>
	</td>
</tr>
<tr>
    <td><font size="-1"><xsl:value-of select="*[@*='description']"/></font></td>
    <td><b><xsl:if test="*[@*='yield']"><xsl:value-of select="*[@*='yield']"/> %</xsl:if></b></td>
    <td><font size="-1"><xsl:value-of select="*[@*='notes']"/></font></td>
</tr>
</xsl:for-each>
</table></xsl:for-each>
</xsl:template>

<!-- ************************************************************ -->
<!-- ******************* Link: linear reaction ****************** -->
<!-- ************************************************************ -->
<xsl:template match="docml:link[@type='reaction' and @display='linear']">
<div class="error">/ERROR - linear reaction unsupported/</div>
</xsl:template>

<!-- ************************************************************ -->
<!-- ****************** Link: cycle.4 reaction ***************** -->
<!-- ************************************************************ -->
<xsl:template match="docml:link[@type='reaction' and @display='cycle.4']">
<xsl:for-each select="id(@idref)"><table>
<tr>
    <td colspan="2" class="box_coloured"><b>Cycle 4 Reaction:</b> <xsl:value-of select="@title"/></td>
    <td class="box_coloured"><b>id:</b> <xsl:value-of select="@id"/></td>
</tr>
<tr>
    <td colspan="2" class="box_coloured"><b>Description:</b> <xsl:value-of select="*[@*='description']"/></td>
    <td class="box_coloured"><b>Yield:</b> <xsl:if test="*[@*='yield']"><xsl:value-of select="*[@*='yield']"/> %</xsl:if></td>
</tr>
<tr>
    <td colspan="3" class="box_coloured"><b>Notes:</b> <xsl:value-of select="*[@*='notes']"/></td>
</tr>
<tr>
    <td colspan="3" align="center" class="box">
	<table bgcolor="#FFFFFF">
		<tr>
		<td align="middle" valign="baseline" colspan="2"><xsl:for-each select="list[3]/*[@*='product']/id(@href)"><xsl:apply-templates select="."/></xsl:for-each></td>
		<td></td><td></td><td rowspan="2" align="left"><xsl:for-each select="list[0]/*[@*='reactant']/id(@href)"><xsl:apply-templates select="."/></xsl:for-each></td>
		</tr>
		<tr>
    	<td></td>
    	<td align="center"><img src="writeupdata/tlout.gif" width="190" height="190" alt="reaction arrow" border="0"/></td>
    	<td align="center" valign="top"><xsl:for-each select="list[0]/*[@*='cycleReactant']/id(@href)"><xsl:apply-templates select="."/></xsl:for-each></td>
    	<td align="center"><img src="writeupdata/trin.gif" width="190" height="190" alt="reaction arrow" border="0"/></td>
		</tr>
		<tr>
    	<td></td>
    	<td align="left"><xsl:for-each select="list[3]/*[@*='cycleReactant']/id(@href)"><xsl:apply-templates select="."/></xsl:for-each></td>
 	   	<td></td>
   		<td align="right"><xsl:for-each select="list[1]/*[@*='cycleReactant']/id(@href)"><xsl:apply-templates select="."/></xsl:for-each></td>
   	 	<td></td>
		</tr>
		<tr>
    	<td align="right" rowspan="2"><xsl:for-each select="list[2]/*[@*='reactant']/id(@href)"><xsl:apply-templates select="."/></xsl:for-each></td>
    	<td align="center"><img src="writeupdata/blin.gif" width="190" height="190" alt="reaction arrow" border="0"/></td>
   	 	<td align="center" valign="baseline"><xsl:for-each select="list[2]/*[@*='cycleReactant']/id(@href)"><xsl:apply-templates select="."/></xsl:for-each></td>
    	<td align="center"><img src="writeupdata/brout.gif" width="190" height="190" alt="reaction arrow" border="0"/></td>
    	<td></td>
		</tr>
		<tr>
    	<td></td><td></td>
    	<td align="middle" valign="top" colspan="2"><xsl:for-each select="list[1]/*[@*='product']/id(@href)"><xsl:apply-templates select="."/></xsl:for-each></td>
		</tr>
		</table>
	</td>
</tr>
</table></xsl:for-each>
</xsl:template>

<!-- ************************************************************ -->
<!-- *********************** Link: chooser ********************** -->
<!-- ************************************************************ -->
<xsl:template match="docml:link[@type='chimeral' and @display='chooser']">
<div class="error">/ERROR - chooser is obsolete/</div>
</xsl:template>

<!-- ************************************************************ -->
<!-- *********************** Link: chooser ********************** -->
<!-- ************************************************************ -->
<xsl:template match="docml:link[@type='chimeral' and @display='cgi']">
<script language="JavaScript" type="text/javascript">
function Example(run, file, author, date){
document.form.run.value = run;
document.form.file.value = file;
document.form.author.value = author;
document.form.date.value = date;

if (run == "mol") {
	document.form.content.value = document.form.mol.value;
	}
if (run == "rxn") {
	document.form.content.value = document.form.rxn.value;
	}
if (run == "dx") {
	document.form.content.value = document.form.dx.value;
	}
}
</script>

<b>Converts MDL .mol, REACSS .rxn and JCAMP .dx files to CML</b>
<font size="-1"><br/>Either select an example file or;
<br/>1) Open file in a text editor
<br/>2) Copy and paste file contents into the textarea
<br/>3) Fill in the other fields (they are used in 'id') and select file and display types
<br/>4) Press GO</font>

		<form method="POST" action="http://origin.ch.ic.ac.uk/cgi-bin/convert.pl" name="form">

		<!-- buttons -->
		<div align="center"><hr/><input type="button" value="load .mol example" name="go" onClick="Example('mol', 'example_mol', 'karne', '18/4/00')"/>
		<input type="button" value="load .dx example" name="go" onClick="Example('dx', 'example_dx', 'karne', '18/4/00')"/>
		<input type="button" value="load .rxn example" name="go" onClick="Example('rxn', 'example_rxn', 'karne', '18/4/00')"/><hr/></div>
		
<!-- fields -->		
<table width="100%">
<tr>
	<td><b>File Type:</b></td>
	<td><select name="run" size="1">
		<option value="mol">MDL .mol molecule</option>
		<option value="dx">JCAMP .dx spectrum</option>
		<option value="rxn">REACSS .rxn reaction</option></select></td>
	<td><b>Title:</b></td>
	<td><input type="TEXT" name="file" size="25" maxlength="25"/></td>
</tr>
<tr>
	<td><b>Author:</b></td>
	<td><input type="TEXT" name="author" size="25" maxlength="25"/></td>
	<td><b>Date:</b></td>
	<td><input type="TEXT" name="date" size="25" maxlength="25"/></td>
</tr>
<tr>
	<td colspan="4">
	<b>File:</b><br/><textarea rows="15" cols="80" name="content"></textarea>
	</td>
</tr>
<tr>
	<td colspan="4" align="center">
	<input type="SUBMIT" value="************** GO **************"/>
	</td>
</tr>
</table>
		
		<!-- examples -->
		<input type="hidden" name="mol" value="caffeine.mol


 24 25  0  0  0  0  0  0  0  0  0
   -2.8709   -1.0499    0.1718 C   0  0  0  0  0
   -2.9099    0.2747    0.1062 N   0  0  0  0  0
   -1.8026    0.9662   -0.1184 C   0  0  0  0  0
   -0.6411    0.2954   -0.2316 C   0  0  0  0  0
   -0.6549   -1.0889   -0.1279 C   0  0  0  0  0
   -1.7352   -1.7187    0.0624 N   0  0  0  0  0
    0.6052    0.7432   -0.4434 N   0  0  0  0  0
    1.2863   -0.4175   -0.4514 C   0  0  0  0  0
    0.5994   -1.5633   -0.2698 N   0  0  0  0  0
    1.0875    2.0867   -0.6139 C   0  0  0  0  0
   -1.8349    2.1699   -0.2205 O   0  0  0  0  0
   -4.2178    0.9810    0.2003 C   0  0  0  0  0
   -3.8944   -1.6746    0.3323 O   0  0  0  0  0
   -1.6764   -3.1997    0.1458 C   0  0  0  0  0
    2.3776   -0.4481   -0.6036 H   0  0  0  0  0
    2.1902    2.0944   -0.7699 H   0  0  0  0  0
    0.6074    2.5547   -1.5032 H   0  0  0  0  0
    0.8606    2.6915    0.2934 H   0  0  0  0  0
   -4.0942    2.0097    0.6091 H   0  0  0  0  0
   -4.6699    1.0338   -0.8167 H   0  0  0  0  0
   -4.9101    0.4518    0.8943 H   0  0  0  0  0
   -2.3049   -3.6334   -0.6659 H   0  0  0  0  0
   -0.6444   -3.6030    0.0359 H   0  0  0  0  0
   -2.0682   -3.5218    1.1381 H   0  0  0  0  0
  1  2  1  0  0  0
  1  6  1  0  0  0
  1 13  2  0  0  0
  2  3  1  0  0  0
  2 12  1  0  0  0
  3  4  1  0  0  0
  3 11  2  0  0  0
  4  5  2  0  0  0
  4  7  1  0  0  0
  5  6  1  0  0  0
  5  9  1  0  0  0
  6 14  1  0  0  0
  7  8  1  0  0  0
  7 10  1  0  0  0
  8  9  2  0  0  0
  8 15  1  0  0  0
 10 16  1  0  0  0
 10 17  1  0  0  0
 10 18  1  0  0  0
 12 19  1  0  0  0
 12 20  1  0  0  0
 12 21  1  0  0  0
 14 22  1  0  0  0
 14 23  1  0  0  0
 14 24  1  0  0  0
M  END"/>

		<input type="hidden" name="rxn" value="$RXN

      ISIS     041120001449

  2  2
$MOL

  -ISIS-  04110014492D

  8  8  0  0  0  0  0  0  0  0999 V2000
   -4.1716   -0.8711    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
   -4.8861   -0.4585    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
   -5.5986   -0.8710    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
   -5.5978   -1.6958    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
   -4.8785   -2.1065    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
   -4.1690   -1.6918    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
   -3.4583   -0.4542    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
   -2.7458   -0.8667    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
  4  5  1  0  0  0  0
  1  2  2  0  0  0  0
  5  6  2  0  0  0  0
  6  1  1  0  0  0  0
  3  4  2  0  0  0  0
  1  7  1  0  0  0  0
  2  3  1  0  0  0  0
  7  8  2  0  0  0  0
M  END
$MOL

  -ISIS-  04110014492D

 12 12  0  0  0  0  0  0  0  0999 V2000
   -0.7348   -0.9750    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
   -0.7359   -1.8023    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
   -0.0211   -2.2152    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
    0.6953   -1.8019    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
    0.6925   -0.9713    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
   -0.0229   -0.5622    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
    1.4042   -0.5542    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
    2.1167   -0.9667    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0
    2.8292   -0.5500    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0
    3.5417   -0.9625    0.0000 H   0  0  0  0  0  0  0  0  0  0  0  0
    1.4000    0.2708    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0
   -0.0292   -3.0375    0.0000 Cl  0  0  0  0  0  0  0  0  0  0  0  0
  3  4  2  0  0  0  0
  5  7  1  0  0  0  0
  2  3  1  0  0  0  0
  7  8  1  0  0  0  0
  4  5  1  0  0  0  0
  8  9  1  0  0  0  0
  1  2  2  0  0  0  0
  9 10  1  0  0  0  0
  5  6  2  0  0  0  0
  7 11  2  0  0  0  0
  6  1  1  0  0  0  0
  3 12  1  0  0  0  0
M  END
$MOL

  -ISIS-  04110014492D

  9 10  0  0  0  0  0  0  0  0999 V2000
    8.4076   -1.0878    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
    7.6930   -0.6752    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
    6.9806   -1.0876    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
    6.9814   -1.9125    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
    7.7007   -2.3232    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
    8.4102   -1.9084    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
    9.1208   -0.6708    0.0000 C   0  0  3  0  0  0  0  0  0  0  0  0
    9.8333   -1.0833    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
    9.8333   -0.2542    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0
  1  2  2  0  0  0  0
  5  6  2  0  0  0  0
  6  1  1  0  0  0  0
  3  4  2  0  0  0  0
  1  7  1  0  0  0  0
  2  3  1  0  0  0  0
  7  8  1  0  0  0  0
  4  5  1  0  0  0  0
  7  9  1  0  0  0  0
  9  8  1  0  0  0  0
M  END
$MOL

  -ISIS-  04110014492D

 11 11  0  0  0  0  0  0  0  0999 V2000
   12.3069   -1.0750    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
   12.3016   -1.8982    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
   13.0107   -2.3125    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
   13.7256   -1.9049    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
   13.7270   -1.0785    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
   13.0172   -0.6678    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
   13.0042   -3.1375    0.0000 Cl  0  0  0  0  0  0  0  0  0  0  0  0
   14.4375   -0.6583    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0
   15.0208   -1.2417    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0
   14.4333    0.1667    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0
   15.8458   -1.2417    0.0000 H   0  0  0  0  0  0  0  0  0  0  0  0
  6  1  1  0  0  0  0
  3  4  2  0  0  0  0
  3  7  1  0  0  0  0
  2  3  1  0  0  0  0
  5  8  1  0  0  0  0
  4  5  1  0  0  0  0
  8  9  1  0  0  0  0
  1  2  2  0  0  0  0
  8 10  2  0  0  0  0
  5  6  2  0  0  0  0
  9 11  1  0  0  0  0
M  END
"/>
<input type="hidden" name="dx" value="##TITLE=Caffeine
##JCAMP-DX=4.24
##DATA TYPE=MASS SPECTRUM
##CAS REGISTRY NO=58-08-2
##EPA MASS SPEC NO=250547
##MOLFORM=C8H10N4O2
##MW=194
##ORIGIN=Virginia Division of Forensic Science
##ORIGIN CODE=VIR
##.IONIZATION ENERGY=70
##FIRSTX=14
##LASTX=197
##FIRSTY=70
##MINY=10
##MAXY=9999
##NPOINTS=104
##OWNER=NIST Mass Spectrometry Data Center
##XUNITS=M/Z
##YUNITS=RELATIVE ABUNDANCE
##XFACTOR=1
##YFACTOR=1
##PEAK TABLE=(XY..XY)
14,70 15,840 16,50 17,40 18,60
20,10 25,10 26,50 27,150 28,900
29,150 30,40 31,10 32,150 34,10
38,120 39,190 40,680 41,580 42,1241
43,60 44,10 45,10 50,10 51,130
52,350 53,470 54,570 55,3383 56,730
57,110 58,140 59,10 62,10 63,10
64,30 65,120 66,640 67,4153 68,450
69,170 70,430 71,10 72,10 76,10
77,70 78,70 79,120 80,230 81,740
82,2742 83,330 85,10 91,10 92,20
93,60 94,390 95,130 96,60 97,210
104,10 105,10 106,20 107,70 109,5935
110,750 111,120 112,10 120,10 121,20
122,90 123,50 124,60 125,10 126,10
132,10 133,10 134,10 135,70 136,500
137,460 138,200 139,10 140,10 147,10
148,10 149,50 150,120 151,40 152,40
153,10 161,10 163,20 164,60 165,570
166,90 167,10 179,10 190,10 193,1461
194,9999 195,1050 196,90 197,10
##END=
"/>

</form>
</xsl:template>

</xsl:stylesheet>