/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.TextField;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.StringTokenizer;

public class JME
extends Applet {
    int action;
    int active_an;
    static boolean application = false;
    static final String version = "2000.06b";
    String infoText = "JME Molecular Editor\u00a9, Novartis Pharma AG";
    public int sd = 24;
    static Color bgColor = Color.lightGray;
    static Color brightColor = bgColor.brighter();
    public Font font;
    public Font fontSmall;
    public FontMetrics fontMet;
    public FontMetrics fontSmallMet;
    public int fontSize;
    boolean canonize = true;
    boolean stereo = true;
    boolean multipart = false;
    boolean rButton = false;
    boolean showHydrogens = true;
    boolean query = false;
    boolean reaction = false;
    boolean autoez = false;
    boolean writesmi = false;
    boolean marking = false;
    boolean jmeh = false;
    boolean depict = false;
    boolean nocenter = false;
    public static final Color[] color = new Color[20];
    public static final String[] zlabel = new String[20];
    Dimension dimension;
    Image topMenu;
    Image leftMenu;
    Image infoArea;
    Image molecularArea;
    boolean doMenu = true;
    boolean movePossible;
    static final int ACTIONX = 12;
    static int ACTIONA = 10;
    static final int ACTION_DELETE = 104;
    static final int ACTION_MARK = 105;
    static final int ACTION_DELGROUP = 106;
    static final int ACTION_SMI = 101;
    static final int ACTION_END = 111;
    static final int ACTION_QRY = 107;
    static final int ACTION_UNDO = 110;
    static final int ACTION_REACP = 109;
    static final int ACTION_CLEAR = 102;
    static final int ACTION_NEW = 103;
    static final int ACTION_JME = 112;
    static final int ACTION_CHARGE = 108;
    static final int ACTION_STEREO = 201;
    static final int ACTION_BOND_SINGLE = 202;
    static final int ACTION_BOND_DOUBLE = 203;
    static final int ACTION_BOND_TRIPLE = 204;
    static final int ACTION_CHAIN = 205;
    static final int ACTION_RING_3 = 206;
    static final int ACTION_RING_4 = 207;
    static final int ACTION_RING_5 = 208;
    static final int ACTION_RING_PH = 209;
    static final int ACTION_RING_6 = 210;
    static final int ACTION_RING_7 = 211;
    static final int ACTION_RING_8 = 212;
    static final int ACTION_RING_9 = 222;
    static final int ACTION_GROUP_TBU = 223;
    static final int ACTION_GROUP_NITRO = 224;
    static final int ACTION_GROUP_COO = 225;
    static final int ACTION_GROUP_CF3 = 226;
    static final int ACTION_GROUP_CCL3 = 227;
    static final int ACTION_GROUP_CC = 228;
    static final int ACTION_GROUP_MAX = 250;
    static final int ACTION_AN_C = 301;
    static final int ACTION_AN_N = 401;
    static final int ACTION_AN_O = 501;
    static final int ACTION_AN_S = 601;
    static final int ACTION_AN_F = 701;
    static final int ACTION_AN_CL = 801;
    static final int ACTION_AN_BR = 901;
    static final int ACTION_AN_I = 1001;
    static final int ACTION_AN_P = 1101;
    static final int ACTION_AN_X = 1201;
    static final int ACTION_AN_R = 1301;
    public static final int AN_H = 1;
    public static final int AN_B = 2;
    public static final int AN_C = 3;
    public static final int AN_N = 4;
    public static final int AN_O = 5;
    public static final int AN_SI = 6;
    public static final int AN_P = 7;
    public static final int AN_S = 8;
    public static final int AN_F = 9;
    public static final int AN_CL = 10;
    public static final int AN_BR = 11;
    public static final int AN_I = 12;
    public static final int AN_SE = 13;
    public static final int AN_R = 18;
    public static final int AN_X = 19;
    int lastAction = 0;
    static final int LA_BOND = 1;
    static final int LA_RING = 2;
    static final int LA_GROUP = 3;
    static final int LA_MOVE = 5;
    static final int LA_FAILED = 9;
    boolean newMolecule = false;
    public int xold;
    public int yold;
    boolean afterClear = false;
    boolean mouseShift = false;
    MultiBox multiBox;
    QueryBox queryBox;
    String molText = null;
    JMEmol mol = new JMEmol(this);
    int nmols = 0;
    int actualMolecule = 0;
    int saved = 0;
    JMEmol[] mols = new JMEmol[99];
    JMEmol smol;

    public static void main(String[] stringArray) {
        application = true;
        Frame frame = new Frame("JME Molecular Editor");
        JME jME = new JME();
        jME.init();
        if (stringArray.length > 0) {
            jME.options(stringArray[0]);
        }
        jME.start();
        frame.add("Center", jME);
        frame.resize(432, 384);
        frame.show();
        if (stringArray.length > 1) {
            jME.dimension = jME.size();
            jME.readMolecule(stringArray[1]);
        }
    }

    public synchronized void init() {
        int n;
        this.dimension = this.size();
        this.setLayout(null);
        this.fontSize = 12;
        if (this.font == null) {
            while (true) {
                this.font = new Font("Helvetica", 0, this.fontSize);
                this.fontMet = this.getFontMetrics(this.font);
                n = this.fontMet.getAscent();
                if (this.fontSize <= 8 || n <= 12) break;
                if (n - this.fontSize > 3) {
                    this.fontSize -= 2;
                    continue;
                }
                --this.fontSize;
            }
        }
        n = this.fontSize - 1;
        if (this.fontSmall == null) {
            while (true) {
                this.fontSmall = new Font("Helvetica", 0, n);
                this.fontSmallMet = this.getFontMetrics(this.fontSmall);
                int n2 = this.fontSmallMet.getAscent();
                if (n <= 7 || n2 <= 10) break;
                if (n2 - n > 3) {
                    n -= 2;
                    continue;
                }
                --n;
            }
        }
        this.query = false;
        this.reaction = false;
        this.autoez = false;
        this.stereo = true;
        this.canonize = true;
        this.rButton = false;
        ACTIONA = 10;
        this.showHydrogens = true;
        if (!application) {
            try {
                String string;
                String string2;
                String string3;
                String string4 = this.getParameter("options");
                if (string4 != null) {
                    this.options(string4);
                }
                if ((string3 = this.getParameter("jme")) != null) {
                    this.readMolecule(string3);
                }
                if ((string2 = this.getParameter("mol")) != null) {
                    this.processMolFile(string2);
                }
                if ((string = this.getParameter("text")) != null) {
                    this.molText = string;
                    this.repaint();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.action = 202;
        JME.atomicData();
    }

    public void start() {
    }

    public void stop() {
        if (this.multiBox != null) {
            this.multiBox.dispose();
        }
        if (this.queryBox != null) {
            this.queryBox.dispose();
        }
    }

    public String smiles() {
        String string = this.Smiles();
        this.repaint();
        return string;
    }

    public String nonisomericSmiles() {
        boolean bl = this.stereo;
        this.stereo = false;
        String string = this.Smiles();
        this.stereo = bl;
        this.repaint();
        return string;
    }

    String Smiles() {
        String string = this.reaction ? this.partSmiles(1) + ">" + this.partSmiles(2) + ">" + this.partSmiles(3) : this.partSmiles(0);
        return string;
    }

    String partSmiles(int n) {
        String string = "";
        int n2 = 1;
        while (n2 <= this.nmols) {
            String string2;
            int n3;
            if ((n <= 0 || (n3 = this.mols[n2].reactionPart()) == n) && (string2 = this.mols[n2].createSmiles()).length() > 0) {
                if (string.length() > 0) {
                    string = string + ".";
                }
                string = string + string2;
            }
            ++n2;
        }
        return string;
    }

    public void reset() {
        this.action = 202;
        this.newMolecule = false;
        this.nmols = 0;
        JMEmol.maxMark = 0;
        this.actualMolecule = 0;
        this.mol = new JMEmol(this);
        this.molText = null;
        this.repaint();
    }

    void clear() {
        this.action = 202;
        this.newMolecule = false;
        if (this.nmols == 0) {
            return;
        }
        this.mol.save();
        this.afterClear = true;
        int n = this.actualMolecule;
        while (n < this.nmols) {
            this.mols[n] = this.mols[n + 1];
            ++n;
        }
        --this.nmols;
        this.actualMolecule = this.nmols;
        if (this.nmols > 0) {
            this.mol = this.mols[this.actualMolecule];
        } else {
            this.mol = new JMEmol(this);
            JMEmol.maxMark = 0;
        }
    }

    void mergeMolecules() {
        int n = 1;
        while (n <= this.nmols) {
            ++n;
        }
    }

    public String jmeFile() {
        String string = "";
        string = this.reaction ? this.partJme(1) + ">" + this.partJme(2) + ">" + this.partJme(3) : this.partJme(0);
        return string;
    }

    String partJme(int n) {
        String string = "";
        int n2 = 1;
        while (n2 <= this.nmols) {
            String string2;
            int n3;
            if ((n <= 0 || (n3 = this.mols[n2].reactionPart()) == n) && (string2 = this.mols[n2].createJME()).length() > 0) {
                if (string.length() > 0) {
                    string = string + "|";
                }
                string = string + string2;
            }
            ++n2;
        }
        return string;
    }

    int[][] getReactionParts() {
        int[][] nArray = new int[4][this.nmols + 1];
        int n = 1;
        while (n <= 3) {
            int n2 = 0;
            int n3 = 1;
            while (n3 <= this.nmols) {
                if (this.mols[n3].reactionPart() == n) {
                    nArray[n][++n2] = n3;
                }
                ++n3;
            }
            nArray[n][0] = n2;
            ++n;
        }
        return nArray;
    }

    public void readMolecule(String string) {
        this.reset();
        int n = 0;
        int n2 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|>", true);
        boolean bl = string.indexOf(">") > -1;
        int n3 = 1;
        int n4 = stringTokenizer.countTokens();
        this.nmols = 0;
        int n5 = 1;
        while (n5 <= n4) {
            String string2 = stringTokenizer.nextToken();
            string2.trim();
            if (!string2.equals("|")) {
                if (string2.equals(">")) {
                    if (++n3 == 2) {
                        n = this.nmols;
                    } else if (n3 == 3) {
                        n2 = this.nmols + 1;
                    }
                } else {
                    this.mol = new JMEmol(this, string2, true);
                    if (this.mol.natoms == 0) {
                        this.info("ERROR - problems in reading/processing molecule !");
                        System.err.println("ERROR while processing\n" + string2);
                    } else {
                        this.actualMolecule = ++this.nmols;
                        this.mols[this.nmols] = this.mol;
                        this.newMolecule = false;
                        this.smol = null;
                    }
                }
            }
            ++n5;
        }
        if (n3 == 2) {
            n2 = n + 1;
            this.info("ERROR - strange reaction - fixing !");
            System.err.println("ERROR - reactant and product should be separated by >>\n");
        } else if (n3 > 3) {
            this.info("ERROR - strange reaction !");
            System.err.println("ERROR - strange reaction !\n");
            return;
        }
        if (this.nmols > 1 && !bl) {
            this.options("multipart");
        }
        if (bl && !this.reaction) {
            this.options("reaction");
        }
        if (!bl && this.reaction) {
            this.options("noreaction");
        }
        if (!bl) {
            this.alignMolecules(1, this.nmols, 0);
        } else {
            this.alignMolecules(1, n, 1);
            this.alignMolecules(n + 1, n2 - 1, 2);
            this.alignMolecules(n2, this.nmols, 3);
        }
        this.repaint();
    }

    void alignMolecules(int n, int n2, int n3) {
        if (this.nocenter) {
            return;
        }
        int n4 = n2 - n + 1;
        if (n4 <= 0 || n > this.nmols || n2 > this.nmols) {
            return;
        }
        double[] dArray = new double[4];
        this.mols[n].centerPoint(dArray);
        int n5 = (int)(dArray[0] * 2.0 / (double)n4);
        double d = (double)(-(n4 - 1)) / 2.0 * (double)n5;
        double d2 = 0.0;
        if (n3 == 1) {
            n5 = (int)((dArray[0] - (double)this.sd) / (double)n4);
            d = -((double)n4 - 0.5) * (double)n5 - (double)this.sd;
        } else if (n3 == 2) {
            n5 = (int)(dArray[1] / (double)n4);
            d2 = -((double)n4 - 0.5) * (double)n5;
        } else if (n3 == 3) {
            n5 = (int)((dArray[0] - (double)this.sd) / (double)n4);
            d = (double)this.sd + (double)n5 / 2.0;
        }
        int n6 = 0;
        int n7 = n;
        while (n7 <= n2) {
            int n8 = (int)(d + (double)(n6 * n5));
            int n9 = (int)(d2 + (double)(n6 * n5));
            ++n6;
            int n10 = 1;
            while (n10 <= this.mols[n7].natoms) {
                if (n3 == 2) {
                    int n11 = n10;
                    this.mols[n7].y[n11] = this.mols[n7].y[n11] + (double)n9;
                } else {
                    int n12 = n10;
                    this.mols[n7].x[n12] = this.mols[n7].x[n12] + (double)n8;
                }
                ++n10;
            }
            this.mols[n7].findBondCenters();
            ++n7;
        }
    }

    public String molFile() {
        String string = "";
        if (this.reaction) {
            int[][] nArray = this.getReactionParts();
            string = string + "$RXN\n\n\nJME Molecular Editor\n";
            string = string + JMEmol.iformat(nArray[1][0], 3) + JMEmol.iformat(nArray[3][0], 3) + "\n";
            int n = 1;
            while (n <= nArray[1][0]) {
                string = string + "$MOL\n" + this.mols[nArray[1][n]].createMolFile();
                ++n;
            }
            int n2 = 1;
            while (n2 <= nArray[3][0]) {
                string = string + "$MOL\n" + this.mols[nArray[3][n2]].createMolFile();
                ++n2;
            }
        } else {
            this.mergeMolecules();
            string = this.mol.createMolFile();
        }
        return string;
    }

    public void processMolFile(String string) {
        this.reset();
        if (!string.startsWith("$RXN") && string.indexOf("$$$$") <= -1) {
            this.mol = new JMEmol(this, string);
            if (this.mol.natoms == 0) {
                this.info("ERROR - problems in reading/processing molecule !");
                System.err.println("ERROR while processing\n" + string);
                return;
            }
            ++this.nmols;
            this.actualMolecule = this.nmols;
            this.mols[this.nmols] = this.mol;
            this.newMolecule = false;
            this.smol = null;
        }
        this.repaint();
    }

    public void readTopology(String string) {
        this.clear();
        this.mol = new JMEmol(this, string, false);
        if (this.mol.natoms == 0) {
            this.info("ERROR - problems in reading/processing topology !");
        } else {
            this.info("Topology in !");
        }
    }

    public void options(String string) {
        string.toLowerCase();
        if (string.indexOf("norbutton") > -1) {
            this.rButton = false;
            ACTIONA = 10;
        } else if (string.indexOf("rbutton") > -1) {
            this.rButton = true;
            ACTIONA = 11;
        }
        if (string.indexOf("nohydrogens") > -1) {
            this.showHydrogens = false;
        } else if (string.indexOf("hydrogens") > -1) {
            this.showHydrogens = true;
        }
        if (string.indexOf("noquery") > -1) {
            this.query = false;
        } else if (string.indexOf("query") > -1) {
            this.query = true;
        }
        if (string.indexOf("noreaction") > -1) {
            this.reaction = false;
        } else if (string.indexOf("reaction") > -1) {
            this.reaction = true;
        }
        if (string.indexOf("noautoez") > -1) {
            this.autoez = false;
        } else if (string.indexOf("autoez") > -1) {
            this.autoez = true;
        }
        if (string.indexOf("nostereo") > -1) {
            this.stereo = false;
        } else if (string.indexOf("stereo") > -1) {
            this.stereo = true;
        }
        if (string.indexOf("nocanonize") > -1) {
            this.canonize = false;
        } else if (string.indexOf("canonize") > -1) {
            this.canonize = true;
        }
        if (string.indexOf("nomultipart") > -1) {
            this.multipart = false;
        } else if (string.indexOf("multipart") > -1) {
            this.multipart = true;
        }
        if (string.indexOf("nonumber") > -1) {
            this.marking = false;
        } else if (string.indexOf("number") > -1) {
            this.marking = true;
        }
        if (string.indexOf("depict") > -1) {
            this.depict = true;
            this.sd = 0;
        }
        if (string.indexOf("writesmi") > -1) {
            this.writesmi = true;
        }
        if (string.indexOf("nocenter") > -1) {
            this.nocenter = true;
        }
        if (string.indexOf("jmeh") > -1) {
            this.jmeh = true;
        }
        if (this.reaction) {
            this.marking = true;
            this.multipart = true;
        }
        this.repaint();
    }

    public void setText(String string) {
        this.molText = string;
        this.repaint();
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    public void update(Graphics graphics) {
        Dimension dimension = this.size();
        if (this.dimension == null || dimension.width != this.dimension.width || dimension.height != this.dimension.height || this.molecularArea == null || this.infoArea == null) {
            this.dimension = dimension;
            this.molecularArea = this.createImage(dimension.width - this.sd, dimension.height - this.sd * 3);
            this.drawMolecularArea(graphics);
            if (this.depict) {
                return;
            }
            this.topMenu = this.createImage(dimension.width, this.sd * 2);
            this.drawTopMenu(graphics);
            this.leftMenu = this.createImage(this.sd, dimension.height - this.sd * 2);
            this.drawLeftMenu(graphics);
            this.infoArea = this.createImage(dimension.width - this.sd, this.sd);
            this.drawInfo(graphics);
        } else {
            this.drawMolecularArea(graphics);
            if (this.depict) {
                return;
            }
            this.drawInfo(graphics);
            if (this.doMenu) {
                this.drawTopMenu(graphics);
                this.drawLeftMenu(graphics);
            }
            this.doMenu = true;
        }
    }

    static void atomicData() {
        int n = 0;
        while (n < 20) {
            JME.color[n] = Color.orange;
            JME.zlabel[n] = "X";
            ++n;
        }
        JME.zlabel[1] = "H";
        JME.color[1] = Color.darkGray;
        JME.zlabel[3] = "C";
        JME.color[3] = Color.darkGray;
        JME.zlabel[4] = "N";
        JME.color[4] = Color.blue;
        JME.zlabel[5] = "O";
        JME.color[5] = Color.red;
        JME.zlabel[9] = "F";
        JME.color[9] = Color.magenta;
        JME.zlabel[10] = "Cl";
        JME.color[10] = Color.magenta;
        JME.zlabel[11] = "Br";
        JME.color[11] = Color.magenta;
        JME.zlabel[12] = "I";
        JME.color[12] = Color.magenta;
        JME.zlabel[8] = "S";
        JME.color[8] = Color.yellow.darker();
        JME.zlabel[7] = "P";
        JME.color[7] = Color.orange;
        JME.zlabel[6] = "Si";
        JME.color[6] = Color.darkGray;
        JME.zlabel[13] = "Se";
        JME.color[13] = Color.darkGray;
        JME.zlabel[19] = "X";
        JME.color[19] = Color.darkGray;
        JME.zlabel[18] = "R";
        JME.color[18] = Color.darkGray;
    }

    void drawMolecularArea(Graphics graphics) {
        int n;
        int n2;
        int n3;
        Graphics graphics2 = this.molecularArea.getGraphics();
        int n4 = this.dimension.width - this.sd;
        int n5 = this.dimension.height - this.sd * 3;
        graphics2.setColor(Color.white);
        graphics2.fillRect(0, 0, n4, n5);
        int n6 = 1;
        while (n6 <= this.nmols) {
            this.mols[n6].draw(graphics2);
            ++n6;
        }
        if (!this.depict) {
            graphics2.setColor(bgColor.darker());
            graphics2.drawLine(n4 - 1, 0, n4 - 1, n5 - 1);
            graphics2.setColor(bgColor);
            graphics2.drawLine(n4 - 2, 0, n4 - 2, n5 - 1);
            graphics2.setColor(brightColor);
            graphics2.drawLine(n4 - 3, 0, n4 - 3, n5 - 1);
        }
        if (this.reaction) {
            n3 = this.sd * 2;
            n2 = (n4 - n3) / 2;
            n = this.sd / 4;
            graphics2.setColor(Color.magenta);
            graphics2.drawLine(n2, n5 / 2, n2 + n3, n5 / 2);
            graphics2.drawLine(n2 + n3, n5 / 2, n2 + n3 - n, n5 / 2 + n);
            graphics2.drawLine(n2 + n3, n5 / 2, n2 + n3 - n, n5 / 2 - n);
        }
        if (this.molText != null) {
            this.font = new Font("Helvetica", 0, this.fontSize);
            this.fontMet = this.getFontMetrics(this.font);
            n3 = this.fontMet.stringWidth(this.molText);
            n2 = (int)Math.round((double)(n4 - n3) / 2.0);
            n = n5 - this.fontSize;
            graphics2.setColor(Color.black);
            graphics2.setFont(this.font);
            graphics2.drawString(this.molText, n2, n);
        }
        graphics.drawImage(this.molecularArea, this.sd, this.sd * 2, this);
    }

    void drawTopMenu(Graphics graphics) {
        Graphics graphics2 = this.topMenu.getGraphics();
        int n = this.dimension.width;
        int n2 = this.sd * 2;
        graphics2.setColor(bgColor);
        graphics2.fillRect(0, 0, n, n2);
        graphics2.setColor(bgColor.darker());
        graphics2.drawLine(n - 1, 0, n - 1, n2 - 1);
        graphics2.drawLine(0, n2 - 1, n - 1 - 2, n2 - 1);
        graphics2.setColor(brightColor);
        graphics2.drawLine(0, 0, n - 1, 0);
        graphics2.drawLine(12 * this.sd, 0, 12 * this.sd, n2 - 1);
        int n3 = 1;
        while (n3 <= 12) {
            this.createSquare(graphics2, n3, 1);
            this.createSquare(graphics2, n3, 2);
            ++n3;
        }
        graphics.drawImage(this.topMenu, 0, 0, this);
    }

    void drawLeftMenu(Graphics graphics) {
        Graphics graphics2 = this.leftMenu.getGraphics();
        int n = this.sd;
        int n2 = this.dimension.height - this.sd * 2;
        graphics2.setColor(bgColor);
        graphics2.fillRect(0, 0, n, n2);
        graphics2.setColor(brightColor);
        graphics2.drawLine(0, 0, 0, n2 - 1);
        graphics2.drawLine(0, ACTIONA * this.sd, n2 - 1, ACTIONA * this.sd);
        graphics2.setColor(bgColor.darker());
        graphics2.drawLine(n - 1, 0, n - 1, n2 - 1 - this.sd);
        graphics2.drawLine(0, n2 - 1, n - 1, n2 - 1);
        int n3 = 3;
        while (n3 <= ACTIONA + 2) {
            this.createSquare(graphics2, 1, n3);
            ++n3;
        }
        graphics.drawImage(this.leftMenu, 0, this.sd * 2, this);
    }

    void drawInfo(Graphics graphics) {
        Graphics graphics2 = this.infoArea.getGraphics();
        int n = this.dimension.width - this.sd;
        int n2 = this.sd;
        graphics2.setColor(bgColor);
        graphics2.fillRect(0, 0, n, n2);
        graphics2.setColor(brightColor);
        graphics2.drawLine(0, 0, n - 1 - 2, 0);
        graphics2.setColor(bgColor.darker());
        graphics2.drawLine(0, n2 - 1, n - 1, n2 - 1);
        graphics2.drawLine(n - 1, 0, n - 1, n2 - 1);
        graphics2.setFont(this.fontSmall);
        graphics2.setColor(Color.black);
        if (this.infoText.startsWith("E")) {
            graphics2.setColor(Color.red);
        }
        graphics2.drawString(this.infoText, 10, 15);
        graphics.drawImage(this.infoArea, this.sd, this.dimension.height - this.sd, this);
    }

    void menuAction(int n) {
        block42: {
            block41: {
                if (n == 0) {
                    return;
                }
                int n2 = this.action;
                this.action = n;
                if (n > 300) break block41;
                switch (n) {
                    case 102: {
                        this.clear();
                        break;
                    }
                    case 110: {
                        this.action = n2;
                        if (this.smol == null) {
                            this.actualMolecule = this.nmols;
                            this.clear();
                        } else if (this.afterClear) {
                            this.saved = ++this.nmols;
                            this.afterClear = false;
                        }
                        if (this.smol != null) {
                            this.mol = new JMEmol(this.smol);
                            this.mol.complete();
                            this.mols[this.saved] = this.mol;
                            break;
                        }
                        break block42;
                    }
                    case 101: {
                        if (application) {
                            if (this.writesmi) {
                                String string = this.Smiles();
                                try {
                                    FileOutputStream fileOutputStream = new FileOutputStream("jme.smi");
                                    PrintStream printStream = new PrintStream(fileOutputStream);
                                    printStream.println(string);
                                    printStream.flush();
                                    printStream.close();
                                    System.out.println("Smiles " + string + " saved into jme.smi.");
                                }
                                catch (IOException iOException) {
                                    System.out.println("Problems to save jme.smi file\n" + iOException);
                                    System.exit(-1);
                                }
                                return;
                            }
                            System.out.println(this.molFile());
                        }
                        if (this.multiBox != null) {
                            this.multiBox.hide();
                        }
                        this.multiBox = new MultiBox(1, this);
                        this.action = n2;
                        break;
                    }
                    case 107: {
                        if (this.queryBox != null) {
                            this.queryBox.hide();
                        }
                        this.queryBox = new QueryBox(this);
                        break;
                    }
                    case 112: {
                        if (this.multiBox != null) {
                            this.multiBox.hide();
                        }
                        this.multiBox = new MultiBox(0, this);
                        this.action = n2;
                        break;
                    }
                    case 103: {
                        this.newMolecule = true;
                        this.action = n2;
                        break;
                    }
                    case 105: {
                        break;
                    }
                    case 111: {
                        System.exit(0);
                    }
                    case 109: {
                        int n3;
                        this.action = n2;
                        int n4 = this.mol.reactionPart();
                        if (n4 == 2) {
                            this.info("Copying the agent not possible !");
                            break;
                        }
                        double[] dArray = new double[4];
                        this.mol.centerPoint(dArray);
                        if (this.mouseShift && this.mol.nmarked == 0) {
                            this.mouseShift = false;
                            n3 = 1;
                            while (n3 <= this.mol.natoms) {
                                this.mol.touchedAtom = n3++;
                                this.mol.mark();
                            }
                            this.mol.touchedAtom = 0;
                        }
                        this.mol = new JMEmol(this.mol);
                        n3 = (int)((double)((this.dimension.width - this.sd) / 2) - dArray[0]);
                        int n5 = 1;
                        while (n5 <= this.mol.natoms) {
                            int n6 = n5++;
                            this.mol.x[n6] = this.mol.x[n6] + (double)(n3 * 2);
                        }
                        this.mol.complete();
                        this.mols[++this.nmols] = this.mol;
                        this.actualMolecule = this.nmols;
                        break;
                    }
                }
                break block42;
            }
            switch (n) {
                case 301: {
                    this.active_an = 3;
                    break;
                }
                case 401: {
                    this.active_an = 4;
                    break;
                }
                case 501: {
                    this.active_an = 5;
                    break;
                }
                case 701: {
                    this.active_an = 9;
                    break;
                }
                case 801: {
                    this.active_an = 10;
                    break;
                }
                case 901: {
                    this.active_an = 11;
                    break;
                }
                case 1001: {
                    this.active_an = 12;
                    break;
                }
                case 601: {
                    this.active_an = 8;
                    break;
                }
                case 1101: {
                    this.active_an = 7;
                    break;
                }
                case 1201: {
                    this.active_an = 19;
                    if (this.multiBox != null) {
                        this.multiBox.hide();
                    }
                    this.multiBox = new MultiBox(2, this);
                    break;
                }
                case 1301: {
                    this.active_an = 18;
                }
            }
        }
        this.repaint();
    }

    void createSquare(Graphics graphics, int n, int n2) {
        int n3 = n2 * 100 + n;
        int n4 = (n - 1) * this.sd;
        int n5 = (n2 - 1) * this.sd;
        if (n == 1 && n2 > 2) {
            n5 -= 2 * this.sd;
        }
        graphics.setColor(bgColor);
        if (n3 == this.action) {
            graphics.fill3DRect(n4 + 1, n5 + 1, this.sd, this.sd, false);
        } else {
            graphics.fill3DRect(n4, n5, this.sd, this.sd, true);
        }
        if (n3 == 1301 && !this.rButton) {
            return;
        }
        if (n3 == 111 && !application) {
            return;
        }
        if (n3 == 107 && !this.query) {
            return;
        }
        if (n3 == 201 && !this.stereo) {
            return;
        }
        if (n3 == 103 && !this.multipart) {
            return;
        }
        if (n3 == 105 && !this.marking) {
            return;
        }
        if (n3 == 109 && !this.reaction) {
            return;
        }
        int n6 = this.sd / 4;
        if (n2 < 3) {
            graphics.setColor(Color.black);
            switch (n3) {
                case 101: {
                    graphics.setColor(Color.yellow);
                    graphics.fillOval(n4 + 3, n5 + 3, this.sd - 6, this.sd - 6);
                    graphics.setColor(Color.black);
                    graphics.drawOval(n4 + 3, n5 + 3, this.sd - 6, this.sd - 6);
                    graphics.drawArc(n4 + 6, n5 + 6, this.sd - 12, this.sd - 12, -35, -110);
                    graphics.fillRect(n4 + 9, n5 + 9, 2, 4);
                    graphics.fillRect(n4 + this.sd - 10, n5 + 9, 2, 4);
                    break;
                }
                case 111: {
                    this.squareText(graphics, n4, n5, "END");
                    break;
                }
                case 107: {
                    this.squareText(graphics, n4, n5, "QRY");
                    break;
                }
                case 108: {
                    this.squareText(graphics, n4, n5, "+/-");
                    break;
                }
                case 110: {
                    this.squareText(graphics, n4, n5, "UDO");
                    break;
                }
                case 109: {
                    graphics.drawLine(n4 + n6, n5 + this.sd / 2, n4 + this.sd - n6, n5 + this.sd / 2);
                    graphics.drawLine(n4 + this.sd - n6, n5 + this.sd / 2, n4 + this.sd - n6 * 3 / 2, n5 + this.sd / 2 + n6 / 2);
                    graphics.drawLine(n4 + this.sd - n6, n5 + this.sd / 2, n4 + this.sd - n6 * 3 / 2, n5 + this.sd / 2 - n6 / 2);
                    break;
                }
                case 102: {
                    this.squareText(graphics, n4, n5, "CLR");
                    break;
                }
                case 103: {
                    graphics.setColor(bgColor);
                    if (this.newMolecule) {
                        graphics.fill3DRect(n4 + 1, n5 + 1, this.sd, this.sd, false);
                    }
                    graphics.setColor(Color.black);
                    this.squareText(graphics, n4, n5, "NEW");
                    break;
                }
                case 106: {
                    this.squareText(graphics, n4, n5, "D-R");
                    break;
                }
                case 104: {
                    this.squareText(graphics, n4, n5, "DEL");
                    break;
                }
                case 105: {
                    this.squareText(graphics, n4, n5, "123");
                    break;
                }
                case 112: {
                    this.squareText(graphics, n4, n5, "JME");
                    break;
                }
                case 201: {
                    graphics.drawLine(n4 + n6, n5 + this.sd / 2, n4 + this.sd - n6, n5 + this.sd / 2 + 2);
                    graphics.drawLine(n4 + n6, n5 + this.sd / 2, n4 + this.sd - n6, n5 + this.sd / 2 - 2);
                    graphics.drawLine(n4 + this.sd - n6, n5 + this.sd / 2 + 2, n4 + this.sd - n6, n5 + this.sd / 2 - 2);
                    break;
                }
                case 202: {
                    graphics.drawLine(n4 + n6, n5 + this.sd / 2, n4 + this.sd - n6, n5 + this.sd / 2);
                    break;
                }
                case 203: {
                    graphics.drawLine(n4 + n6, n5 + this.sd / 2 - 2, n4 + this.sd - n6, n5 + this.sd / 2 - 2);
                    graphics.drawLine(n4 + n6, n5 + this.sd / 2 + 2, n4 + this.sd - n6, n5 + this.sd / 2 + 2);
                    break;
                }
                case 204: {
                    graphics.drawLine(n4 + n6, n5 + this.sd / 2, n4 + this.sd - n6, n5 + this.sd / 2);
                    graphics.drawLine(n4 + n6, n5 + this.sd / 2 - 2, n4 + this.sd - n6, n5 + this.sd / 2 - 2);
                    graphics.drawLine(n4 + n6, n5 + this.sd / 2 + 2, n4 + this.sd - n6, n5 + this.sd / 2 + 2);
                    break;
                }
                case 205: {
                    graphics.drawLine(n4 + n6 / 2, n5 + n6 * 2 + n6 / 3, n4 + n6 / 2 * 3, n5 + n6 * 2 - n6 / 3);
                    graphics.drawLine(n4 + n6 / 2 * 3, n5 + n6 * 2 - n6 / 3, n4 + n6 / 2 * 5, n5 + n6 * 2 + n6 / 3);
                    graphics.drawLine(n4 + n6 / 2 * 5, n5 + n6 * 2 + n6 / 3, n4 + n6 / 2 * 7, n5 + n6 * 2 - n6 / 3);
                    break;
                }
                case 206: {
                    this.drawRingIcon(graphics, n4, n5 + 2, 3);
                    break;
                }
                case 207: {
                    this.drawRingIcon(graphics, n4, n5, 4);
                    break;
                }
                case 208: {
                    this.drawRingIcon(graphics, n4, n5, 5);
                    break;
                }
                case 209: {
                    this.drawRingIcon(graphics, n4, n5, 1);
                    break;
                }
                case 210: {
                    this.drawRingIcon(graphics, n4, n5, 6);
                    break;
                }
                case 211: {
                    this.drawRingIcon(graphics, n4, n5, 7);
                    break;
                }
                case 212: {
                    this.drawRingIcon(graphics, n4, n5, 8);
                }
            }
        } else {
            int n7 = 3;
            switch (n3) {
                case 301: {
                    n7 = 3;
                    break;
                }
                case 401: {
                    n7 = 4;
                    break;
                }
                case 501: {
                    n7 = 5;
                    break;
                }
                case 601: {
                    n7 = 8;
                    break;
                }
                case 701: {
                    n7 = 9;
                    break;
                }
                case 801: {
                    n7 = 10;
                    break;
                }
                case 901: {
                    n7 = 11;
                    break;
                }
                case 1001: {
                    n7 = 12;
                    break;
                }
                case 1101: {
                    n7 = 7;
                    break;
                }
                case 1201: {
                    n7 = 19;
                    break;
                }
                case 1301: {
                    n7 = 18;
                }
            }
            int n8 = this.fontMet.getAscent();
            int n9 = this.fontMet.stringWidth(zlabel[n7]);
            graphics.setFont(this.font);
            graphics.setColor(color[n7]);
            graphics.drawString(zlabel[n7], n4 + (this.sd - n9) / 2, n5 + (this.sd - n8) / 2 + n8);
            graphics.drawString(zlabel[n7], n4 + (this.sd - n9) / 2 + 1, n5 + (this.sd - n8) / 2 + n8);
        }
    }

    void squareText(Graphics graphics, int n, int n2, String string) {
        graphics.setFont(this.fontSmall);
        int n3 = this.fontSmallMet.getAscent();
        int n4 = this.fontSmallMet.stringWidth(string);
        graphics.drawString(string, n + (this.sd - n4) / 2, n2 + (this.sd - n3) / 2 + n3);
    }

    void drawRingIcon(Graphics graphics, int n, int n2, int n3) {
        int n4 = this.sd / 4;
        boolean bl = false;
        int[] nArray = new int[9];
        int[] nArray2 = new int[9];
        double d = n + this.sd / 2;
        double d2 = n2 + this.sd / 2;
        int n5 = this.sd / 2 - n4 / 2;
        if (n3 == 1) {
            n3 = 6;
            bl = true;
        }
        int n6 = 0;
        while (n6 <= n3) {
            double d3 = Math.PI * 2 / (double)n3 * ((double)n6 - 0.5);
            nArray[n6] = (int)(d + (double)n5 * Math.sin(d3));
            nArray2[n6] = (int)(d2 + (double)n5 * Math.cos(d3));
            ++n6;
        }
        graphics.drawPolygon(nArray, nArray2, n3 + 1);
        if (bl) {
            int n7 = 0;
            while (n7 <= n3) {
                double d4 = Math.PI * 2 / (double)n3 * ((double)n7 - 0.5);
                nArray[n7] = (int)(d + (double)(n5 - 3) * Math.sin(d4));
                nArray2[n7] = (int)(d2 + (double)(n5 - 3) * Math.cos(d4));
                ++n7;
            }
            graphics.drawLine(nArray[0], nArray2[0], nArray[1], nArray2[1]);
            graphics.drawLine(nArray[2], nArray2[2], nArray[3], nArray2[3]);
            graphics.drawLine(nArray[4], nArray2[4], nArray[5], nArray2[5]);
        }
    }

    void info(String string) {
        this.infoText = string;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (this.depict) {
            return true;
        }
        this.xold = n - this.sd;
        this.yold = n2 - 2 * this.sd;
        this.info("");
        this.mouseShift = event.shiftDown();
        this.movePossible = false;
        if (n < this.sd || n2 < this.sd * 2) {
            int n3 = 0;
            int n4 = 1;
            while (n4 <= 12) {
                if (n < n4 * this.sd) {
                    n3 = n4;
                    break;
                }
                ++n4;
            }
            int n5 = 0;
            int n6 = 1;
            while (n6 <= ACTIONA + 2) {
                if (n2 < n6 * this.sd) {
                    n5 = n6;
                    break;
                }
                ++n6;
            }
            if (n3 == 0 || n5 == 0) {
                return true;
            }
            int n7 = n5 * 100 + n3;
            if (!application && n7 == 111) {
                return true;
            }
            if (!this.query && n7 == 107) {
                return true;
            }
            if (!this.stereo && n7 == 201) {
                return true;
            }
            if (!this.multipart && n7 == 103) {
                return true;
            }
            if (!this.marking && n7 == 105) {
                return true;
            }
            if (!this.reaction && n7 == 109) {
                return true;
            }
            this.menuAction(n7);
        } else {
            if (n2 > this.dimension.height - this.sd - 1) {
                return true;
            }
            this.movePossible = true;
            n -= this.sd;
            n2 -= 2 * this.sd;
            if (this.mol.touchedAtom > 0) {
                if (this.action == 104) {
                    this.mol.save();
                    this.mol.deleteAtom(this.mol.touchedAtom);
                    this.mol.touchedAtom = 0;
                } else {
                    if (this.action == 106) {
                        return true;
                    }
                    if (this.action == 108) {
                        this.mol.changeCharge(this.mol.touchedAtom);
                    } else if (this.action == 202 || this.action == 203 || this.action == 204 || this.action == 201 || this.action == 205) {
                        this.mol.save();
                        this.lastAction = 1;
                        this.mol.addBond();
                        this.mol.touched_org = this.mol.touchedAtom;
                        if (this.action == 205) {
                            this.mol.nchain = 1;
                            this.mol.avoidTouch(1);
                        }
                    } else if (this.action >= 206 && this.action <= 222) {
                        this.mol.save();
                        this.lastAction = 2;
                        this.mol.addRing();
                    } else if (this.action >= 223 && this.action < 250) {
                        this.mol.save();
                        this.mol.addGroup();
                        this.lastAction = 3;
                    } else if (this.action == 107) {
                        if (QueryBox.isBondQuery) {
                            return true;
                        }
                        this.mol.addSpecialAtom(this.mol.touchedAtom, QueryBox.text.getText());
                    } else if (this.action == 105) {
                        this.mol.mark();
                    } else if (this.action > 300 && (this.active_an != this.mol.an[this.mol.touchedAtom] || this.active_an == 19)) {
                        this.mol.save();
                        this.mol.an[this.mol.touchedAtom] = this.active_an;
                        this.mol.q[this.mol.touchedAtom] = 0;
                        if (this.active_an == 19) {
                            this.mol.addSpecialAtom(this.mol.touchedAtom, MultiBox.atomicSymbol.getText());
                        }
                    }
                }
            } else if (this.mol.touchedBond > 0) {
                if (this.action == 104) {
                    this.mol.save();
                    this.mol.deleteBond(this.mol.touchedBond);
                    this.mol.touchedBond = 0;
                } else if (this.action == 106) {
                    this.mol.save();
                    this.mol.deleteGroup(this.mol.touchedBond);
                    this.mol.touchedBond = 0;
                } else if (this.action == 201) {
                    this.mol.stereoBond(this.mol.touchedBond);
                } else if (this.action == 202) {
                    this.mol.nasv[this.mol.touchedBond] = this.mol.nasv[this.mol.touchedBond] == 1 && this.mol.stereob[this.mol.touchedBond] == 0 ? 2 : 1;
                    this.mol.stereob[this.mol.touchedBond] = 0;
                } else if (this.action == 203) {
                    this.mol.nasv[this.mol.touchedBond] = 2;
                    this.mol.stereob[this.mol.touchedBond] = 0;
                } else if (this.action == 204) {
                    this.mol.nasv[this.mol.touchedBond] = 3;
                    this.mol.stereob[this.mol.touchedBond] = 0;
                } else if (this.action >= 206 && this.action <= 222) {
                    this.mol.save();
                    this.lastAction = 2;
                    this.mol.addRing();
                } else if (this.action == 107) {
                    if (!QueryBox.isBondQuery) {
                        return true;
                    }
                    String string = QueryBox.text.getText();
                    this.mol.nasv[this.mol.touchedBond] = 9;
                    if ("~".equals(string)) {
                        this.mol.stereob[this.mol.touchedBond] = 1;
                    }
                    if (":".equals(string)) {
                        this.mol.stereob[this.mol.touchedBond] = 2;
                    }
                    if ("@".equals(string)) {
                        this.mol.stereob[this.mol.touchedBond] = 3;
                    }
                    if ("!@".equals(string)) {
                        this.mol.stereob[this.mol.touchedBond] = 4;
                    }
                } else if (this.action == 105) {
                    this.info("Only atoms may be marked !");
                }
            } else if (this.nmols == 0 || this.newMolecule) {
                if (this.action <= 201) {
                    return true;
                }
                ++this.nmols;
                this.actualMolecule = this.nmols;
                this.mols[this.nmols] = new JMEmol(this);
                this.mol = this.mols[this.nmols];
                this.newMolecule = false;
                this.smol = null;
                if (this.action >= 202 && this.action <= 204 || this.action == 205) {
                    this.mol.createAtom();
                    this.mol.nbonds = 0;
                    this.mol.nv[1] = 0;
                    this.mol.x[1] = n;
                    this.mol.y[1] = n2;
                    this.mol.touchedAtom = 1;
                    this.mol.touched_org = 1;
                    this.lastAction = 1;
                    this.mol.addBond();
                    this.mol.nchain = 2;
                } else if (this.action >= 206 && this.action <= 222) {
                    this.mol.xorg = n;
                    this.mol.yorg = n2;
                    this.lastAction = 2;
                    this.mol.addRing();
                } else if (this.action > 300) {
                    this.mol.createAtom();
                    this.mol.an[1] = this.active_an;
                    this.mol.nbonds = 0;
                    this.mol.nv[1] = 0;
                    this.mol.x[1] = n;
                    this.mol.y[1] = n2;
                    this.mol.touchedAtom = 1;
                    if (this.active_an == 19) {
                        this.mol.addSpecialAtom(1, MultiBox.atomicSymbol.getText());
                    }
                } else if (this.action >= 223 && this.action < 250) {
                    this.mol.createAtom();
                    this.mol.nbonds = 0;
                    this.mol.nv[1] = 0;
                    this.mol.x[1] = n;
                    this.mol.y[1] = n2;
                    this.mol.touchedAtom = 1;
                    this.mol.addGroup();
                } else {
                    System.out.println("error - fall through !");
                }
            }
            this.mol.valenceState();
            this.repaint();
        }
        return true;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        if (this.depict) {
            return true;
        }
        if (this.lastAction == 1) {
            this.mol.checkBond();
            this.mol.findBondCenters();
        } else if (this.lastAction == 5) {
            this.mol.findBondCenters();
        }
        if (this.lastAction > 0) {
            this.doMenu = false;
            this.mol.valenceState();
            this.mol.cleanPolarBonds();
            this.repaint();
            this.lastAction = 0;
            this.afterClear = false;
        }
        return true;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        if (this.depict) {
            return true;
        }
        if (!this.movePossible) {
            return true;
        }
        int n3 = (n -= this.sd) - this.xold;
        int n4 = (n2 -= this.sd * 2) - this.yold;
        if (this.lastAction == 2 || this.lastAction == 3 || this.lastAction == 9) {
            return true;
        }
        if (this.lastAction == 1) {
            this.mol.rubberBanding(n, n2);
        } else if (event.shiftDown() || event.metaDown()) {
            this.mol.rotate(n3);
            this.lastAction = 5;
        } else if (this.mol.touchedAtom == 0 && this.mol.touchedBond == 0) {
            this.mol.move(n3, n4);
            this.lastAction = 5;
        }
        this.doMenu = false;
        this.repaint();
        this.xold = n;
        this.yold = n2;
        return true;
    }

    public boolean mouseMove(Event event, int n, int n2) {
        int n3;
        if (this.depict) {
            return true;
        }
        n -= this.sd;
        n2 -= this.sd * 2;
        boolean bl = false;
        int n4 = 0;
        int n5 = 1;
        while (n5 <= this.nmols) {
            n3 = 0;
            int n6 = 0;
            n3 = this.mols[n5].testAtomTouch(n, n2);
            if (n3 == 0) {
                n6 = this.mols[n5].testBondTouch(n, n2);
            }
            if (n3 > 0) {
                this.mols[n5].touchedAtom = n3;
                this.mols[n5].touchedBond = 0;
                n4 = n5;
                bl = true;
                break;
            }
            if (n6 > 0) {
                this.mols[n5].touchedAtom = 0;
                this.mols[n5].touchedBond = n6;
                n4 = n5;
                bl = true;
                break;
            }
            if (this.mols[n5].touchedAtom > 0 || this.mols[n5].touchedBond > 0) {
                this.mols[n5].touchedAtom = 0;
                this.mols[n5].touchedBond = 0;
                bl = true;
            }
            ++n5;
        }
        if (bl) {
            n3 = this.actualMolecule + 1;
            while (n3 <= this.nmols) {
                this.mols[n3].touchedAtom = 0;
                this.mols[n3].touchedBond = 0;
                ++n3;
            }
            this.doMenu = false;
            this.repaint();
        }
        if (n4 != 0 && n4 != this.actualMolecule) {
            this.actualMolecule = n4;
            this.mol = this.mols[this.actualMolecule];
        }
        return true;
    }

    public boolean keyDown(Event event, int n) {
        if (this.depict) {
            return true;
        }
        int n2 = 0;
        switch (n) {
            case 67: 
            case 99: {
                n2 = 301;
                break;
            }
            case 78: 
            case 110: {
                n2 = 401;
                break;
            }
            case 79: 
            case 111: {
                n2 = 501;
                break;
            }
            case 83: 
            case 115: {
                n2 = 601;
                break;
            }
            case 80: 
            case 112: {
                n2 = 1101;
                break;
            }
            case 70: 
            case 102: {
                n2 = 701;
                break;
            }
            case 76: 
            case 108: {
                n2 = 801;
                break;
            }
            case 66: 
            case 98: {
                n2 = 901;
                break;
            }
            case 73: 
            case 105: {
                n2 = 1001;
                break;
            }
            case 88: 
            case 120: {
                n2 = 1201;
                break;
            }
            case 42: 
            case 72: 
            case 104: {
                n2 = 1201;
                this.active_an = 19;
                this.action = 1201;
                MultiBox.atomicSymbol = n == 42 ? new TextField("*", 8) : new TextField("H", 8);
                if (this.multiBox != null) {
                    this.multiBox.hide();
                }
                this.repaint();
                return true;
            }
            case 82: 
            case 114: {
                if (!this.rButton) break;
                n2 = 1301;
                break;
            }
            case 84: 
            case 116: {
                if (this.action == 701) {
                    n2 = 226;
                    break;
                }
                if (this.action == 801) {
                    n2 = 227;
                    break;
                }
                n2 = 223;
                break;
            }
            case 89: 
            case 121: {
                n2 = 224;
                break;
            }
            case 65: 
            case 97: {
                n2 = 225;
                break;
            }
            case 69: 
            case 101: {
                n2 = 228;
                break;
            }
            case 85: 
            case 117: {
                n2 = 110;
                break;
            }
            case 27: 
            case 45: {
                n2 = 202;
                break;
            }
            case 61: {
                n2 = 203;
                break;
            }
            case 35: {
                n2 = 204;
                break;
            }
            case 51: {
                n2 = 206;
                break;
            }
            case 52: {
                n2 = 207;
                break;
            }
            case 53: {
                n2 = 208;
                break;
            }
            case 48: 
            case 49: {
                n2 = 209;
                break;
            }
            case 54: {
                n2 = 210;
                break;
            }
            case 55: {
                n2 = 211;
                break;
            }
            case 56: {
                n2 = 212;
                break;
            }
            case 57: {
                n2 = 222;
                break;
            }
            case 8: 
            case 68: 
            case 100: 
            case 127: {
                n2 = 104;
            }
        }
        this.menuAction(n2);
        return true;
    }
}

