/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.miniJmol;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Panel;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;
import org.openscience.miniJmol.AtomTypeLookup;
import org.openscience.miniJmol.CMLFile;
import org.openscience.miniJmol.ChemFile;
import org.openscience.miniJmol.PDBFile;
import org.openscience.miniJmol.XYZFile;
import org.openscience.miniJmol.displayPanel;

public class JmolSimpleBean
extends Panel
implements ComponentListener {
    private displayPanel display;
    private ChemFile cf;
    private AtomTypeLookup atomTypeLookup;
    private boolean modelReady = false;
    private boolean typesReady = false;
    private boolean shown = false;

    public JmolSimpleBean() {
        this.setLayout(new BorderLayout());
        this.display = new displayPanel();
        this.display.addComponentListener(this);
        this.add((Component)this.display, "Center");
        this.setBackgroundColour("#FFFFFF");
        this.setForegroundColour("#000000");
    }

    public void addKeyListener(KeyListener keyListener) {
        this.display.addKeyListener(keyListener);
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.display.addMouseListener(mouseListener);
    }

    private void areWeReady() {
        if (this.modelReady && this.typesReady && this.shown) {
            this.setDisplayReady();
        }
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.shown = true;
        this.areWeReady();
    }

    public void componentShown(ComponentEvent componentEvent) {
        this.shown = true;
        this.areWeReady();
    }

    public String getAtomRenderingStyleDescription() {
        if (this.display.getAtomRenderMode() == 0) {
            return "QUICKDRAW";
        }
        if (this.display.getAtomRenderMode() == 1) {
            return "SHADED";
        }
        if (this.display.getAtomRenderMode() == 2) {
            return "WIREFRAME";
        }
        return "NULL";
    }

    public boolean getAtomsShown() {
        return this.display.getShowAtoms();
    }

    public boolean getAutoWireframe() {
        return this.display.getWireframeRotation();
    }

    public Color getBackgroundColour() {
        return this.display.getBackgroundColor();
    }

    public String getBondRenderingStyleDescription() {
        if (this.display.getBondRenderMode() == 0) {
            return "QUICKDRAW";
        }
        if (this.display.getBondRenderMode() == 1) {
            return "SHADED";
        }
        if (this.display.getBondRenderMode() == 3) {
            return "LINE";
        }
        if (this.display.getBondRenderMode() == 2) {
            return "WIREFRAME";
        }
        return "NULL";
    }

    public boolean getBondsShown() {
        return this.display.getShowBonds();
    }

    protected boolean getBooleanFromString(String string) {
        if (string.equalsIgnoreCase("T")) {
            return true;
        }
        if (string.equalsIgnoreCase("F")) {
            return false;
        }
        throw new IllegalArgumentException("Boolean string must be 'T' or 'F'");
    }

    protected Color getColourFromHexString(String string) {
        if (string == null || string.length() != 7) {
            throw new IllegalArgumentException("Colour name: " + string + " is either null ot not seven chars long");
        }
        Color color = null;
        try {
            String string2 = "0x" + string.substring(1, 3);
            String string3 = "0x" + string.substring(3, 5);
            String string4 = "0x" + string.substring(5, 7);
            int n = Integer.decode(string2);
            int n2 = Integer.decode(string3);
            int n3 = Integer.decode(string4);
            color = new Color(n, n2, n3);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("MDLView: Error extracting colour, using white");
            color = new Color(255, 255, 255);
        }
        return color;
    }

    public ChemFile getCurrentFile() {
        return this.cf;
    }

    public Color getForegroundColour() {
        return this.display.getForegroundColor();
    }

    public String getLabelRenderingStyleDescription() {
        if (this.display.getLabelMode() == 0) {
            return "NONE";
        }
        if (this.display.getLabelMode() == 1) {
            return "SYMBOLS";
        }
        if (this.display.getLabelMode() == 2) {
            return "TYPES";
        }
        if (this.display.getLabelMode() == 3) {
            return "NUMBERS";
        }
        return "NULL";
    }

    protected InputStream getStreamForFile(String string) {
        try {
            URL uRL = new URL(string);
            return uRL.openStream();
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException("MalformedURLException: " + malformedURLException);
        }
        catch (IOException iOException) {
            throw new RuntimeException("IOException in getStreamForFile: " + iOException);
        }
    }

    public boolean getVectorsShown() {
        return this.display.getShowVectors();
    }

    private ChemFile loadModel(InputStream inputStream, String string) {
        if (this.atomTypeLookup == null) {
            System.out.println("Atom properties file defaulting to 'AtomTypes' in working directory");
            this.setAtomPropertiesFromFile("AtomTypes");
        }
        try {
            if (string.equalsIgnoreCase("PDB")) {
                return new PDBFile(inputStream, this.atomTypeLookup);
            }
            if (string.equalsIgnoreCase("CML")) {
                return new CMLFile(inputStream, this.atomTypeLookup);
            }
            if (string.equalsIgnoreCase("XYZ")) {
                return new XYZFile(inputStream, this.atomTypeLookup);
            }
            throw new RuntimeException("Unknown file type in loadModel: " + string);
        }
        catch (Exception exception) {
            throw new RuntimeException("Sorry! Unhelpful Exception in loadModel: " + exception);
        }
    }

    private ChemFile loadModelFromFile(String string, String string2) throws FileNotFoundException {
        if (string != null && string2 != null) {
            FileInputStream fileInputStream = new FileInputStream(string);
            return this.loadModel(fileInputStream, string2);
        }
        throw new RuntimeException("Null string passed to loadModelFromFile");
    }

    private ChemFile loadModelFromURL(String string, String string2) {
        if (string != null && string2 != null) {
            InputStream inputStream = this.getStreamForFile(string);
            return this.loadModel(inputStream, string2);
        }
        throw new RuntimeException("Null string passed to loadModelFromURL");
    }

    public void setAtomPropertiesFromFile(String string) {
        try {
            this.atomTypeLookup = new AtomTypeLookup(string, false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.typesReady = true;
        this.areWeReady();
    }

    public void setAtomPropertiesFromURL(String string) {
        try {
            this.atomTypeLookup = new AtomTypeLookup(string, true);
        }
        catch (Exception exception) {}
        this.typesReady = true;
        this.areWeReady();
    }

    public void setAtomPropertiesFromURL(URL uRL) {
        try {
            this.atomTypeLookup = new AtomTypeLookup(uRL);
        }
        catch (Exception exception) {}
        this.typesReady = true;
        this.areWeReady();
    }

    public void setAtomRenderingStyle(String string) {
        if (string.equalsIgnoreCase("QUICKDRAW")) {
            this.display.setAtomQuickDraw();
        } else if (string.equalsIgnoreCase("SHADED")) {
            this.display.setAtomShaded();
        } else if (string.equalsIgnoreCase("WIREFRAME")) {
            this.display.setAtomWireframe();
        } else {
            throw new IllegalArgumentException("Unknown atom rendering style: " + string);
        }
    }

    public void setAtomsShown(String string) {
        this.display.showAtoms(this.getBooleanFromString(string));
    }

    public void setAtomsShown(boolean bl) {
        this.display.showAtoms(bl);
    }

    public void setAutoWireframe(String string) {
        this.display.setWireframeRotation(this.getBooleanFromString(string));
    }

    public void setAutoWireframe(boolean bl) {
        this.display.setWireframeRotation(bl);
    }

    public void setBackgroundColour(Color color) {
        this.display.setBackgroundColor(color);
    }

    public void setBackgroundColour(String string) {
        this.display.setBackgroundColor(this.getColourFromHexString(string));
    }

    public void setBondRenderingStyle(String string) {
        if (string.equalsIgnoreCase("QUICKDRAW")) {
            this.display.setBondQuickDraw();
        } else if (string.equalsIgnoreCase("SHADED")) {
            this.display.setBondShaded();
        } else if (string.equalsIgnoreCase("LINE")) {
            this.display.setBondLine();
        } else if (string.equalsIgnoreCase("WIREFRAME")) {
            this.display.setBondWireframe();
        } else {
            throw new IllegalArgumentException("Unknown bond rendering style: " + string);
        }
    }

    public void setBondsShown(String string) {
        this.display.showBonds(this.getBooleanFromString(string));
    }

    public void setBondsShown(boolean bl) {
        this.display.showBonds(bl);
    }

    private void setDisplayReady() throws IllegalStateException {
        this.display.setChemFile(this.cf);
        this.display.start();
    }

    public void setForegroundColour(Color color) {
        this.display.setForegroundColor(color);
    }

    public void setForegroundColour(String string) {
        this.display.setForegroundColor(this.getColourFromHexString(string));
    }

    public void setLabelRenderingStyle(String string) {
        if (string.equalsIgnoreCase("NONE")) {
            this.display.setLabelsToNone();
        } else if (string.equalsIgnoreCase("SYMBOLS")) {
            this.display.setLabelsToSymbols();
        } else if (string.equalsIgnoreCase("TYPES")) {
            this.display.setLabelsToTypes();
        } else if (string.equalsIgnoreCase("NUMBERS")) {
            this.display.setLabelsToAtomNumbers();
        } else {
            throw new IllegalArgumentException("Unknown label rendering style: " + string);
        }
    }

    public void setModelToRenderFromCMLString(String string) {
        StringBufferInputStream stringBufferInputStream = new StringBufferInputStream(string);
        this.cf = this.loadModel(stringBufferInputStream, "CML");
        this.modelReady = true;
        this.areWeReady();
    }

    public void setModelToRenderFromFile(String string, String string2) throws FileNotFoundException {
        this.cf = this.loadModelFromFile(string, string2);
        this.modelReady = true;
        this.areWeReady();
    }

    public void setModelToRenderFromURL(String string, String string2) {
        this.cf = this.loadModelFromURL(string, string2);
        this.modelReady = true;
        this.areWeReady();
    }

    public void setModelToRenderFromURL(URL uRL, String string) throws IOException {
        if (uRL == null || string == null) {
            throw new RuntimeException("Null string passed to loadModelFromURL");
        }
        InputStream inputStream = uRL.openStream();
        this.cf = this.loadModel(inputStream, string);
        this.modelReady = true;
        this.areWeReady();
    }

    public void setModelToRenderFromXYZString(String string) {
        StringBufferInputStream stringBufferInputStream = new StringBufferInputStream(string);
        this.cf = this.loadModel(stringBufferInputStream, "XYZ");
        this.modelReady = true;
        this.areWeReady();
    }

    public void setVectorsShown(String string) {
        this.display.showVectors(this.getBooleanFromString(string));
    }

    public void setVectorsShown(boolean bl) {
        this.display.showVectors(bl);
    }

    protected String[] tokenize(String string) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        String[] stringArray = new String[vector.size()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = (String)vector.elementAt(n);
            ++n;
        }
        return stringArray;
    }
}

