/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.miniJmol;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.openscience.miniJmol.JmolSimpleBean;

public class JmolApplet
extends Applet
implements MouseListener,
KeyListener {
    JmolSimpleBean myBean;
    int mode;
    int labelMode;
    private String helpMessage = "Keys: Tab- change style; L- Show labels";
    String format = null;

    protected String convertEscapeChars(String string) {
        String string2 = "<";
        char c = string2.charAt(0);
        String string3 = ">";
        char c2 = string3.charAt(0);
        String string4 = "\"";
        char c3 = string4.charAt(0);
        String string5 = "&";
        char c4 = string5.charAt(0);
        String string6 = ";";
        char c5 = string6.charAt(0);
        StringBuffer stringBuffer = new StringBuffer(string);
        StringBuffer stringBuffer2 = new StringBuffer(0);
        boolean bl = false;
        StringBuffer stringBuffer3 = new StringBuffer(0);
        int n = 0;
        while (n < stringBuffer.length()) {
            char c6 = stringBuffer.charAt(n);
            if (!bl) {
                if (c6 == c4) {
                    bl = true;
                    stringBuffer3 = new StringBuffer(0);
                    stringBuffer3.append(c6);
                } else {
                    stringBuffer2.append(c6);
                }
            } else if (c6 == c5) {
                bl = false;
                String string7 = stringBuffer3.toString();
                if (string7.equals("&lt")) {
                    stringBuffer2.append(c);
                } else if (string7.equals("&gt")) {
                    stringBuffer2.append(c2);
                } else if (string7.equals("&quot")) {
                    stringBuffer2.append(c3);
                }
            } else {
                stringBuffer3.append(c6);
            }
            ++n;
        }
        String string8 = stringBuffer2.toString();
        return string8;
    }

    public String getAtomRenderingStyleDescription() {
        return this.getAtomRenderingStyleDescription();
    }

    public String getBondRenderingStyleDescription() {
        return this.myBean.getBondRenderingStyleDescription();
    }

    public String getLabelRenderingStyleDescription() {
        return this.myBean.getLabelRenderingStyleDescription();
    }

    public void init() {
        String string;
        String string2;
        URL uRL;
        String string3;
        this.myBean = new JmolSimpleBean();
        this.format = this.getParameter("FORMAT");
        if (this.format != null) {
            this.format = this.format.toUpperCase();
            this.verifyFormat(this.format);
        }
        if ((string3 = this.getParameter("ATOMTYPES")) == null) {
            string3 = "AtomTypes";
        }
        try {
            uRL = new URL(this.getDocumentBase(), string3);
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException("Got MalformedURL for Atomtypes: " + malformedURLException.toString());
        }
        this.myBean.setAtomPropertiesFromURL(uRL);
        String string4 = this.getParameter("MODEL");
        if (string4 != null) {
            this.loadModel(string4);
        }
        this.myBean.addMouseListener(this);
        this.myBean.addKeyListener(this);
        String string5 = this.getParameter("BCOLOUR");
        if (string5 != null) {
            this.myBean.setBackgroundColour(string5);
        }
        if ((string2 = this.getParameter("FCOLOUR")) != null) {
            this.myBean.setForegroundColour(string2);
        }
        if ((string = this.getParameter("STYLE")) != null) {
            this.myBean.setAtomRenderingStyle(string);
            this.myBean.setBondRenderingStyle(string);
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.myBean, "Center");
        this.myBean.setAtomRenderingStyle("SHADED");
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        String string = KeyEvent.getKeyText(keyEvent.getKeyChar());
        String string2 = new Character(keyEvent.getKeyChar()).toString();
        if (string.equals("Tab")) {
            ++this.mode;
            this.mode %= 3;
            if (this.mode == 0) {
                this.showStatus("JmolApplet: Changing rendering style to QUICKDRAW");
                this.myBean.setAtomRenderingStyle("QUICKDRAW");
                this.myBean.setBondRenderingStyle("QUICKDRAW");
            } else if (this.mode == 1) {
                this.showStatus("JmolApplet: Changing rendering style to WIREFRAME");
                this.myBean.setAtomRenderingStyle("WIREFRAME");
                this.myBean.setBondRenderingStyle("WIREFRAME");
            } else if (this.mode == 2) {
                this.showStatus("JmolApplet: Changing rendering style to SHADED");
                this.myBean.setAtomRenderingStyle("SHADED");
                this.myBean.setBondRenderingStyle("SHADED");
            } else {
                this.showStatus("JmolApplet: Changing rendering style to default");
                this.myBean.setAtomRenderingStyle("WIREFRAME");
                this.myBean.setBondRenderingStyle("WIREFRAME");
            }
        } else if (string2.equals("l") || string2.equals("L")) {
            ++this.labelMode;
            this.labelMode %= 4;
            if (this.labelMode == 0) {
                this.showStatus("JmolApplet: Changing label style to NONE");
                this.myBean.setLabelRenderingStyle("NONE");
            } else if (this.labelMode == 1) {
                this.showStatus("JmolApplet: Changing label style to SYMBOLS");
                this.myBean.setLabelRenderingStyle("SYMBOLS");
            } else if (this.labelMode == 2) {
                this.showStatus("JmolApplet: Changing label style to TYPES");
                this.myBean.setLabelRenderingStyle("TYPES");
            } else if (this.labelMode == 3) {
                this.showStatus("JmolApplet: Changing label style to NUMBERS");
                this.myBean.setLabelRenderingStyle("NUMBERS");
            } else {
                this.showStatus("JmolApplet: Changing label style to default");
                this.myBean.setBondRenderingStyle("NONE");
            }
        }
    }

    private void loadModel(String string) {
        if (this.format == null) {
            throw new RuntimeException("Attempt to load model without setting format");
        }
        if (this.format.equals("CMLSTRING")) {
            String string2 = this.convertEscapeChars(string);
            System.out.println(string2);
            this.myBean.setModelToRenderFromCMLString(string2);
        } else {
            URL uRL;
            try {
                uRL = new URL(this.getDocumentBase(), string);
            }
            catch (MalformedURLException malformedURLException) {
                throw new RuntimeException("Got MalformedURL for model: " + malformedURLException.toString());
            }
            try {
                this.myBean.setModelToRenderFromURL(uRL, this.format);
            }
            catch (IOException iOException) {
                System.out.println("IOException: " + iOException);
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.showStatus(this.helpMessage);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.showStatus(this.helpMessage);
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public String recoverEOLSymbols(String string) {
        String string2 = "%";
        char c = string2.charAt(0);
        String string3 = ".";
        char c2 = string3.charAt(0);
        String string4 = "-";
        char c3 = string4.charAt(0);
        String string5 = " ";
        char c4 = string5.charAt(0);
        String string6 = "\n";
        char c5 = string6.charAt(0);
        StringBuffer stringBuffer = new StringBuffer(string);
        StringBuffer stringBuffer2 = new StringBuffer(0);
        boolean bl = false;
        int n = 0;
        while (n < stringBuffer.length()) {
            char c6 = stringBuffer.charAt(n);
            if (c6 == c) {
                stringBuffer2.append(c5);
                bl = false;
            } else if (c6 == c4) {
                if (!bl) {
                    stringBuffer2.append(c6);
                    bl = true;
                }
            } else if (Character.isLetterOrDigit(c6) || c6 == c2 || c6 == c3) {
                stringBuffer2.append(c6);
                bl = false;
            }
            ++n;
        }
        if (bl) {
            stringBuffer2.setLength(stringBuffer2.length() - 1);
        }
        String string7 = stringBuffer2.toString();
        return string7;
    }

    public void setAtomPropertiesFromFile(String string) {
        this.myBean.setAtomPropertiesFromFile(string);
    }

    public void setAtomPropertiesFromURL(String string) {
        this.myBean.setAtomPropertiesFromURL(string);
    }

    public void setAtomRenderingStyle(String string) {
        this.myBean.setAtomRenderingStyle(string);
    }

    public void setAtomsShown(String string) {
        this.myBean.setAtomsShown(string);
    }

    public void setAutoWireframe(String string) {
        this.myBean.setAutoWireframe(string);
    }

    public void setBackgroundColour(String string) {
        this.myBean.setBackgroundColour(string);
    }

    public void setBondRenderingStyle(String string) {
        this.myBean.setBondRenderingStyle(string);
    }

    public void setBondsShown(String string) {
        this.myBean.setBondsShown(string);
    }

    public void setForegroundColour(String string) {
        this.myBean.setForegroundColour(string);
    }

    public void setLabelRenderingStyle(String string) {
        this.myBean.setLabelRenderingStyle(string);
    }

    public void setModelToRenderFromCMLString(String string) {
        this.myBean.setModelToRenderFromCMLString(string);
    }

    public void setModelToRenderFromFile(String string, String string2) {
        this.setModelToRenderFromFile(string, string2);
    }

    public void setModelToRenderFromURL(String string, String string2) {
        this.myBean.setModelToRenderFromURL(string, string2);
    }

    public void setModelToRenderFromXYZString(String string, String string2) {
        if ((string2 = string2.toUpperCase()).equals("T")) {
            string = this.recoverEOLSymbols(string);
        }
        this.myBean.setModelToRenderFromXYZString(string);
    }

    public void setVectorsShown(String string) {
        this.myBean.setVectorsShown(string);
    }

    private void verifyFormat(String string) {
        if (string.equals("CML") || string.equals("CMLSTRING") || string.equals("XYZ") || string.equals("PDB")) {
            return;
        }
        throw new RuntimeException("Format: " + string + " is not a valid value (CML, CMLSTRING, XYZ, PDB)");
    }
}

