/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.miniJmol;

import java.util.Vector;
import org.openscience.cdopi.CDOInterface;
import org.openscience.miniJmol.ChemFrame;
import org.openscience.miniJmol.FortranFormat;

public final class JMolCDO
implements CDOInterface {
    private Vector allFrames = new Vector();
    private ChemFrame currentFrame = new ChemFrame();
    private int frameNo = 0;
    private String atom_type;
    private String atom_x;
    private String atom_y;
    private String atom_z;

    public void endAnimation() {
    }

    public void endAtom() {
        System.out.println("endAtom: " + this.atom_type + " " + this.atom_x + " " + this.atom_y + " " + this.atom_z);
        double d = FortranFormat.atof(this.atom_x.trim());
        double d2 = FortranFormat.atof(this.atom_y.trim());
        double d3 = FortranFormat.atof(this.atom_z.trim());
        try {
            this.currentFrame.addVert(this.atom_type.trim(), (float)d, (float)d2, (float)d3);
        }
        catch (Exception exception) {
            System.out.println("JMolCDO error while adding atom: " + exception);
        }
    }

    public void endDocument() {
    }

    public void endFragment() {
    }

    public void endFrame() {
        System.out.println("endFrame");
        this.allFrames.addElement(this.currentFrame);
    }

    public void endMolecule() {
    }

    public Vector returnChemFrames() {
        return this.allFrames;
    }

    public void setAtomProperty(String string, String string2) {
        System.out.println("setAtomProp: " + string + "=" + string2);
        if (string.equals("type")) {
            this.atom_type = string2;
        }
        if (string.equals("x3")) {
            this.atom_x = string2;
        }
        if (string.equals("y3")) {
            this.atom_y = string2;
        }
        if (string.equals("z3")) {
            this.atom_z = string2;
        }
    }

    public void setFrameProperty(String string, String string2) {
        System.out.println("setFrameProperty: " + string + "=" + string2);
        if (string.equals("title")) {
            this.currentFrame.setInfo(string2);
        }
    }

    public void startAnimation() {
        System.out.println("startAnimation");
    }

    public void startAtom() {
        System.out.println("startAtom");
        this.atom_type = "";
        this.atom_x = "";
        this.atom_y = "";
        this.atom_z = "";
    }

    public void startDocument() {
    }

    public void startFragment() {
    }

    public void startFrame() {
        System.out.println("startFrame");
        ++this.frameNo;
        this.currentFrame = new ChemFrame();
    }

    public void startMolecule() {
    }
}

