/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.miniJmol;

import java.awt.Canvas;
import java.awt.Graphics;
import java.util.Vector;
import org.openscience.miniJmol.ArrowLine;
import org.openscience.miniJmol.AtomType;
import org.openscience.miniJmol.AtomTypeLookup;
import org.openscience.miniJmol.Bond;
import org.openscience.miniJmol.JmolException;
import org.openscience.miniJmol.Matrix3D;
import org.openscience.miniJmol.PhysicalProperty;

public class ChemFrame {
    private static AtomTypeLookup atomTypeTable;
    private float bondFudge = 1.12f;
    private float ScreenScale;
    private boolean AutoBond = true;
    private boolean ShowBonds = true;
    private boolean ShowAtoms = true;
    private boolean ShowVectors = false;
    private boolean ShowHydrogens = true;
    private Matrix3D mat = new Matrix3D();
    private static boolean[] pickedAtoms;
    private static int napicked;
    private static boolean doingMoveDraw;
    String info;
    float[] vert;
    float[] vect;
    int[] tvert;
    int[] tvect;
    AtomType[] atoms;
    Bond[] bonds;
    Vector[] aProps;
    Vector frameProps;
    boolean hasProperties = false;
    boolean hasVectors = false;
    int[] ZsortMap;
    int nvert = 0;
    int nbonds;
    int maxbonds;
    int maxvert;
    int maxbpa = 10;
    int[] nBpA;
    int[][] inBonds;
    boolean[] bondDrawn;
    int[] bondEnd1;
    int[] bondEnd2;
    float xmin;
    float xmax;
    float ymin;
    float ymax;
    float zmin;
    float zmax;

    static {
        doingMoveDraw = false;
    }

    public ChemFrame() {
        this.mat.xrot(0.0);
        this.mat.yrot(0.0);
        this.maxvert = 100;
        this.frameProps = new Vector();
        this.vert = new float[300];
        this.vect = new float[300];
        this.atoms = new AtomType[100];
        this.aProps = new Vector[100];
        pickedAtoms = new boolean[100];
        this.nBpA = new int[100];
        this.inBonds = new int[100][this.maxbpa];
        int n = 0;
        while (n < 100) {
            this.vert[3 * n] = 0.0f;
            this.vert[3 * n + 1] = 0.0f;
            this.vert[3 * n + 2] = 0.0f;
            this.vect[3 * n] = 0.0f;
            this.vect[3 * n + 1] = 0.0f;
            this.vect[3 * n + 2] = 0.0f;
            ChemFrame.pickedAtoms[n] = false;
            ++n;
        }
    }

    public ChemFrame(int n) {
        this.mat.xrot(0.0);
        this.mat.yrot(0.0);
        this.maxvert = n;
        this.frameProps = new Vector();
        this.vert = new float[n * 3];
        this.vect = new float[n * 3];
        this.atoms = new AtomType[n];
        this.aProps = new Vector[n];
        pickedAtoms = new boolean[n];
        this.nBpA = new int[n];
        this.inBonds = new int[n][this.maxbpa];
        int n2 = 0;
        while (n2 < n) {
            this.vert[3 * n2] = 0.0f;
            this.vert[3 * n2 + 1] = 0.0f;
            this.vert[3 * n2 + 2] = 0.0f;
            this.vect[3 * n2] = 0.0f;
            this.vect[3 * n2 + 1] = 0.0f;
            this.vect[3 * n2 + 2] = 0.0f;
            ChemFrame.pickedAtoms[n2] = false;
            ++n2;
        }
    }

    public int addPropertiedVert(String string, float f, float f2, float f3, Vector vector) throws Exception {
        this.hasProperties = true;
        int n = this.addVert(string, f, f2, f3);
        this.aProps[n] = vector;
        int n2 = 0;
        while (n2 < vector.size()) {
            PhysicalProperty physicalProperty = (PhysicalProperty)vector.elementAt(n2);
            String string2 = physicalProperty.getDescriptor();
            if (string2.equals("Vector")) {
                this.hasVectors = true;
                double[] dArray = new double[3];
                int n3 = n * 3;
                this.vect[n3] = (float)((double)f + dArray[0]);
                this.vect[n3 + 1] = (float)((double)f2 + dArray[1]);
                this.vect[n3 + 2] = (float)((double)f3 + dArray[2]);
            }
            if (this.frameProps.indexOf(string2) < 0) {
                this.frameProps.addElement(string2);
            }
            ++n2;
        }
        return n;
    }

    public int addVert(int n, float f, float f2, float f3) throws Exception {
        AtomType atomType = atomTypeTable.get(n);
        return this.addVert(atomType, f, f2, f3);
    }

    public int addVert(String string, float f, float f2, float f3) throws Exception {
        AtomType atomType = atomTypeTable.get(string);
        return this.addVert(atomType, f, f2, f3);
    }

    public int addVert(AtomType atomType, float f, float f2, float f3) throws Exception {
        Object object;
        int n = this.nvert;
        if (n >= this.maxvert) {
            System.out.println("Increasing vector size!");
            this.maxvert *= 2;
            float[] fArray = new float[this.maxvert * 3];
            System.arraycopy(this.vert, 0, fArray, 0, this.vert.length);
            this.vert = fArray;
            AtomType[] atomTypeArray = new AtomType[this.maxvert];
            System.arraycopy(this.atoms, 0, atomTypeArray, 0, this.atoms.length);
            this.atoms = atomTypeArray;
            Vector[] vectorArray = new Vector[this.maxvert];
            System.arraycopy(this.aProps, 0, vectorArray, 0, this.aProps.length);
            this.aProps = vectorArray;
            float[] fArray2 = new float[this.maxvert * 3];
            System.arraycopy(this.vect, 0, fArray2, 0, this.vect.length);
            this.vect = fArray2;
            boolean[] blArray = new boolean[this.maxvert];
            System.arraycopy(pickedAtoms, 0, blArray, 0, pickedAtoms.length);
            pickedAtoms = blArray;
            object = new int[this.maxvert];
            System.arraycopy(this.nBpA, 0, object, 0, this.nBpA.length);
            this.nBpA = (int[])object;
            int[][] nArray = new int[this.maxvert][this.maxbpa];
            System.arraycopy(this.inBonds, 0, nArray, 0, this.inBonds.length);
            this.inBonds = nArray;
        }
        this.atoms[n] = atomType;
        this.nBpA[n] = 0;
        this.aProps[n] = new Vector();
        int n2 = 0;
        while (n2 < n) {
            float f4 = 0.0f;
            float f5 = this.vert[3 * n2] - f;
            float f6 = this.vert[3 * n2 + 1] - f2;
            float f7 = this.vert[3 * n2 + 2] - f3;
            f4 += f5 * f5 + f6 * f6 + f7 * f7;
            object = this.atoms[n2];
            float f8 = this.bondFudge * ((float)atomType.getCovalentRadius() + (float)((AtomType)object).getCovalentRadius());
            float f9 = f8 * f8;
            if (f4 <= f9) {
                Bond[] bondArray;
                int n3 = this.nbonds;
                if (n3 >= this.maxbonds) {
                    if (this.bonds == null) {
                        this.maxbonds = 100;
                        this.bonds = new Bond[this.maxbonds];
                        this.bondDrawn = new boolean[this.maxbonds];
                        this.bondEnd1 = new int[this.maxbonds];
                        this.bondEnd2 = new int[this.maxbonds];
                    } else {
                        this.maxbonds *= 2;
                        bondArray = new Bond[this.maxbonds];
                        System.arraycopy(this.bonds, 0, bondArray, 0, this.bonds.length);
                        this.bonds = bondArray;
                        boolean[] blArray = new boolean[this.maxbonds];
                        System.arraycopy(this.bondDrawn, 0, blArray, 0, this.bondDrawn.length);
                        this.bondDrawn = blArray;
                        int[] nArray = new int[this.maxbonds];
                        System.arraycopy(this.bondEnd1, 0, nArray, 0, this.bondEnd1.length);
                        this.bondEnd1 = nArray;
                        int[] nArray2 = new int[this.maxbonds];
                        System.arraycopy(this.bondEnd2, 0, nArray2, 0, this.bondEnd2.length);
                        this.bondEnd2 = nArray2;
                    }
                }
                bondArray = new Bond(atomType, (AtomType)object);
                this.bonds[n3] = bondArray;
                this.bondEnd1[n3] = n;
                this.bondEnd2[n3] = n2;
                int n4 = this.nBpA[n] + 1;
                int n5 = this.nBpA[n2] + 1;
                if (n4 >= this.maxbonds) {
                    throw new JmolException("ChemFrame.rebond", "max bonds per atom exceeded");
                }
                if (n5 >= this.maxbonds) {
                    throw new JmolException("ChemFrame.rebond", "max bonds per atom exceeded");
                }
                this.inBonds[n][n4 - 1] = n3;
                this.inBonds[n2][n5 - 1] = n3;
                this.nBpA[n2] = n5;
                this.nBpA[n] = n4;
                ++this.nbonds;
            }
            ++n2;
        }
        this.vert[n *= 3] = f;
        this.vert[n + 1] = f2;
        this.vert[n + 2] = f3;
        return this.nvert++;
    }

    public void deselectAll() {
        if (this.nvert <= 0) {
            return;
        }
        int n = 0;
        while (n < this.nvert) {
            ChemFrame.pickedAtoms[n] = false;
            ++n;
        }
        napicked = 0;
    }

    public void findBB() {
        float f;
        float f2;
        float f3;
        if (this.nvert <= 0) {
            return;
        }
        float[] fArray = this.vert;
        float f4 = f3 = fArray[0];
        float f5 = f2 = fArray[1];
        float f6 = f = fArray[2];
        int n = this.nvert * 3;
        while ((n -= 3) > 0) {
            float f7;
            float f8;
            float f9 = fArray[n];
            if (f9 < f3) {
                f3 = f9;
            }
            if (f9 > f4) {
                f4 = f9;
            }
            if ((f8 = fArray[n + 1]) < f2) {
                f2 = f8;
            }
            if (f8 > f5) {
                f5 = f8;
            }
            if ((f7 = fArray[n + 2]) < f) {
                f = f7;
            }
            if (!(f7 > f6)) continue;
            f6 = f7;
        }
        this.xmax = f4;
        this.xmin = f3;
        this.ymax = f5;
        this.ymin = f2;
        this.zmax = f6;
        this.zmin = f;
    }

    public AtomType getAtomType(int n) {
        AtomType atomType = this.atoms[n];
        return atomType;
    }

    public boolean getAutoBond() {
        return this.AutoBond;
    }

    public float getBondFudge() {
        return this.bondFudge;
    }

    public Vector getFrameProps() {
        return this.frameProps;
    }

    public String getInfo() {
        return this.info;
    }

    public boolean getMovingDrawMode() {
        return doingMoveDraw;
    }

    private int getNearestAtom(int n, int n2) {
        if (this.nvert <= 0) {
            return -1;
        }
        this.transform();
        int[] nArray = this.tvert;
        int n3 = -1;
        int n4 = Integer.MAX_VALUE;
        int n5 = 0;
        while (n5 < this.nvert) {
            int n6 = nArray[3 * n5] - n;
            int n7 = nArray[3 * n5 + 1] - n2;
            int n8 = n6 * n6 + n7 * n7;
            if (n8 < n4) {
                n3 = n5;
                n4 = n8;
            }
            ++n5;
        }
        if (n3 >= 0) {
            return n3;
        }
        return -1;
    }

    public int getNpicked() {
        return napicked;
    }

    public int getNvert() {
        return this.nvert;
    }

    public boolean getShowAtoms() {
        return this.ShowAtoms;
    }

    public boolean getShowBonds() {
        return this.ShowBonds;
    }

    public boolean getShowHydrogens() {
        return this.ShowHydrogens;
    }

    public boolean getShowVectors() {
        return this.ShowVectors;
    }

    public double[] getVertCoords(int n) {
        int n2 = n * 3;
        double[] dArray = new double[]{this.vert[n2], this.vert[n2 + 1], this.vert[n2 + 2]};
        return dArray;
    }

    public Vector getVertProps(int n) {
        Vector vector = this.aProps[n];
        return vector;
    }

    private boolean isAtomInRegion(int n, int n2, int n3, int n4, int n5) {
        int n6 = this.tvert[3 * n];
        int n7 = this.tvert[3 * n + 1];
        return n6 > n2 && n6 < n4 && n7 > n3 && n7 < n5;
    }

    public void matmult(Matrix3D matrix3D) {
        this.mat.mult(matrix3D);
    }

    public void matscale(float f, float f2, float f3) {
        this.mat.scale(f, f2, f3);
    }

    public void mattranslate(float f, float f2, float f3) {
        this.mat.translate(f, f2, f3);
    }

    public void matunit() {
        this.mat.unit();
    }

    public synchronized void paint(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        if (this.vert == null || this.nvert <= 0) {
            return;
        }
        this.transform();
        int[] nArray = this.tvert;
        int[] nArray2 = this.ZsortMap;
        if (nArray2 == null) {
            this.ZsortMap = nArray2 = new int[this.nvert];
            n5 = this.nvert;
            while (--n5 >= 0) {
                nArray2[n5] = n5 * 3;
            }
        }
        if (!doingMoveDraw) {
            n5 = this.nvert - 1;
            while (--n5 >= 0) {
                n4 = 0;
                n3 = 0;
                while (n3 <= n5) {
                    n2 = nArray2[n3];
                    n = nArray2[n3 + 1];
                    if (nArray[n2 + 2] > nArray[n + 2]) {
                        nArray2[n3 + 1] = n2;
                        nArray2[n3] = n;
                        n4 = 1;
                    }
                    ++n3;
                }
                if (n4 == 0) break;
            }
        }
        n5 = 0;
        n4 = this.nvert;
        if (n4 <= 0 || this.nvert <= 0) {
            return;
        }
        n3 = 0;
        while (n3 < this.nbonds) {
            this.bondDrawn[n3] = false;
            ++n3;
        }
        n2 = 0;
        while (n2 < n4) {
            n = nArray2[n2];
            if (this.ShowBonds) {
                int n6 = this.nBpA[n / 3];
                int n7 = 0;
                while (n7 < n6) {
                    int n8 = this.inBonds[n / 3][n7];
                    if (!this.bondDrawn[n8]) {
                        int n9;
                        if (this.bondEnd1[n8] == n / 3) {
                            n9 = 3 * this.bondEnd2[n8];
                            this.bonds[n8].paint(graphics, nArray[n], nArray[n + 1], nArray[n + 2], nArray[n9], nArray[n9 + 1], nArray[n9 + 2], doingMoveDraw);
                        } else {
                            n9 = 3 * this.bondEnd1[n8];
                            this.bonds[n8].paint(graphics, nArray[n9], nArray[n9 + 1], nArray[n9 + 2], nArray[n], nArray[n + 1], nArray[n + 2], doingMoveDraw);
                        }
                    }
                    ++n7;
                }
            }
            if (this.ShowAtoms && !doingMoveDraw) {
                this.atoms[n / 3].paint(graphics, nArray[n], nArray[n + 1], nArray[n + 2], n / 3 + 1, this.aProps[n / 3], pickedAtoms[n / 3]);
            }
            if (this.ShowVectors && this.hasVectors) {
                ArrowLine arrowLine = new ArrowLine(graphics, nArray[n], nArray[n + 1], this.tvect[n], this.tvect[n + 1], false, true, 0, 3 + (int)((float)this.tvect[n + 2] / this.ScreenScale));
            }
            ++n2;
        }
    }

    public int pickMeasuredAtom(int n, int n2) {
        return this.getNearestAtom(n, n2);
    }

    public void rebond() throws Exception {
        this.nbonds = 0;
        int n = 0;
        while (n < this.nvert) {
            this.nBpA[n] = 0;
            ++n;
        }
        int n2 = 0;
        while (n2 < this.nvert - 1) {
            AtomType atomType = this.atoms[n2];
            float f = this.vert[3 * n2];
            float f2 = this.vert[3 * n2 + 1];
            float f3 = this.vert[3 * n2 + 2];
            int n3 = n2;
            while (n3 < this.nvert) {
                float f4 = 0.0f;
                float f5 = this.vert[3 * n3] - f;
                float f6 = this.vert[3 * n3 + 1] - f2;
                float f7 = this.vert[3 * n3 + 2] - f3;
                f4 += f5 * f5 + f6 * f6 + f7 * f7;
                AtomType atomType2 = this.atoms[n3];
                float f8 = this.bondFudge * ((float)atomType.getCovalentRadius() + (float)atomType2.getCovalentRadius());
                float f9 = f8 * f8;
                if (f4 <= f9) {
                    Bond[] bondArray;
                    int n4 = this.nbonds;
                    if (n4 >= this.maxbonds) {
                        if (this.bonds == null) {
                            this.maxbonds = 100;
                            this.bonds = new Bond[this.maxbonds];
                            this.bondDrawn = new boolean[this.maxbonds];
                            this.bondEnd1 = new int[this.maxbonds];
                            this.bondEnd2 = new int[this.maxbonds];
                        } else {
                            this.maxbonds *= 2;
                            bondArray = new Bond[this.maxbonds];
                            System.arraycopy(this.bonds, 0, bondArray, 0, this.bonds.length);
                            this.bonds = bondArray;
                            boolean[] blArray = new boolean[this.maxbonds];
                            System.arraycopy(this.bondDrawn, 0, blArray, 0, this.bondDrawn.length);
                            this.bondDrawn = blArray;
                            int[] nArray = new int[this.maxbonds];
                            System.arraycopy(this.bondEnd1, 0, nArray, 0, this.bondEnd1.length);
                            this.bondEnd1 = nArray;
                            int[] nArray2 = new int[this.maxbonds];
                            System.arraycopy(this.bondEnd2, 0, nArray2, 0, this.bondEnd2.length);
                            this.bondEnd2 = nArray2;
                        }
                    }
                    bondArray = new Bond(atomType, atomType2);
                    this.bonds[n4] = bondArray;
                    this.bondEnd1[n4] = n2;
                    this.bondEnd2[n4] = n3;
                    int n5 = this.nBpA[n2] + 1;
                    int n6 = this.nBpA[n3] + 1;
                    if (n5 >= this.maxbonds) {
                        throw new JmolException("ChemFrame.rebond", "max bonds per atom exceeded");
                    }
                    if (n6 >= this.maxbonds) {
                        throw new JmolException("ChemFrame.rebond", "max bonds per atom exceeded");
                    }
                    this.inBonds[n2][n5 - 1] = n4;
                    this.inBonds[n3][n6 - 1] = n4;
                    this.nBpA[n3] = n6;
                    this.nBpA[n2] = n5;
                    ++this.nbonds;
                }
                ++n3;
            }
            ++n2;
        }
    }

    public void selectAll() {
        if (this.nvert <= 0) {
            return;
        }
        napicked = 0;
        int n = 0;
        while (n < this.nvert) {
            ChemFrame.pickedAtoms[n] = true;
            ++napicked;
            ++n;
        }
    }

    public void selectAtom(int n, int n2) {
        int n3 = this.getNearestAtom(n, n2);
        if (pickedAtoms[n3]) {
            ChemFrame.pickedAtoms[n3] = false;
            napicked = 0;
        } else {
            ChemFrame.pickedAtoms[n3] = true;
            napicked = 1;
        }
        int n4 = 0;
        while (n4 < this.nvert) {
            if (n4 != n3) {
                ChemFrame.pickedAtoms[n4] = false;
            }
            ++n4;
        }
    }

    public void selectRegion(int n, int n2, int n3, int n4) {
        if (this.nvert <= 0) {
            return;
        }
        this.transform();
        int[] nArray = this.tvert;
        napicked = 0;
        int n5 = 0;
        while (n5 < this.nvert) {
            if (this.isAtomInRegion(n5, n, n2, n3, n4)) {
                ChemFrame.pickedAtoms[n5] = true;
                ++napicked;
            } else {
                ChemFrame.pickedAtoms[n5] = false;
            }
            ++n5;
        }
    }

    public void setAtomRenderMode(int n) {
        int n2 = 0;
        while (n2 < this.nvert) {
            this.atoms[n2].setRenderMode(n);
            ++n2;
        }
    }

    public void setAtomScreenScale(float f) {
        int n = 0;
        while (n < this.nvert) {
            this.atoms[n].setScreenScale(f);
            ++n;
        }
    }

    public void setAtomTypeLookup(AtomTypeLookup atomTypeLookup) {
        atomTypeTable = atomTypeLookup;
    }

    public void setAutoBond(boolean bl) {
        this.AutoBond = bl;
    }

    public void setBondFudge(float f) {
        this.bondFudge = f;
    }

    public void setBondRenderMode(int n) {
        int n2 = 0;
        while (n2 < this.nbonds) {
            this.bonds[n2].setRenderMode(n);
            ++n2;
        }
    }

    public void setBondScreenScale(float f) {
        int n = 0;
        while (n < this.nbonds) {
            this.bonds[n].setScreenScale(f);
            ++n;
        }
    }

    public void setBondsToAtomCenters(boolean bl) {
        int n = 0;
        while (n < this.nbonds) {
            this.bonds[n].setBondsToAtomCenters(bl);
            ++n;
        }
    }

    public void setCanvas(Canvas canvas) {
        int n = 0;
        while (n < this.nvert) {
            this.atoms[n].setCanvas(canvas);
            ++n;
        }
    }

    public void setInfo(String string) {
        this.info = string;
    }

    public void setLabelMode(int n) {
        int n2 = 0;
        while (n2 < this.nvert) {
            this.atoms[n2].setLabelMode(n);
            ++n2;
        }
    }

    public void setMovingDrawMode(boolean bl) {
        doingMoveDraw = bl;
    }

    public void setScreenScale(float f) {
        this.ScreenScale = f;
    }

    public void setShowAtoms(boolean bl) {
        this.ShowAtoms = bl;
    }

    public void setShowBonds(boolean bl) {
        this.ShowBonds = bl;
    }

    public void setShowHydrogens(boolean bl) {
        this.ShowHydrogens = bl;
    }

    public void setShowVectors(boolean bl) {
        this.ShowVectors = bl;
    }

    public void setZoffset(int n) {
        int n2 = 0;
        while (n2 < this.nvert) {
            this.atoms[n2].setZoffset(n);
            ++n2;
        }
    }

    public void shiftSelectAtom(int n, int n2) {
        int n3 = this.getNearestAtom(n, n2);
        if (pickedAtoms[n3]) {
            ChemFrame.pickedAtoms[n3] = false;
            --napicked;
        } else {
            ChemFrame.pickedAtoms[n3] = true;
            ++napicked;
        }
    }

    public void shiftSelectRegion(int n, int n2, int n3, int n4) {
        if (this.nvert <= 0) {
            return;
        }
        this.transform();
        int[] nArray = this.tvert;
        int n5 = 0;
        while (n5 < this.nvert) {
            if (this.isAtomInRegion(n5, n, n2, n3, n4) && !pickedAtoms[n5]) {
                ChemFrame.pickedAtoms[n5] = true;
                ++napicked;
            }
            ++n5;
        }
    }

    public void toggleAtoms() {
        this.ShowAtoms ^= true;
    }

    public void toggleBonds() {
        this.ShowBonds ^= true;
    }

    public void toggleBondsToAtomCenters() {
        int n = 0;
        while (n < this.nbonds) {
            this.bonds[n].toggleBondsToAtomCenters();
            ++n;
        }
    }

    public void toggleHydrogens() {
        this.ShowHydrogens ^= true;
    }

    public void toggleVectors() {
        this.ShowVectors ^= true;
    }

    public void transform() {
        if (this.nvert <= 0) {
            return;
        }
        if (this.tvert == null || this.tvert.length < this.nvert * 3) {
            this.tvert = new int[this.nvert * 3];
        }
        this.mat.transform(this.vert, this.tvert, this.nvert);
        if (this.hasVectors) {
            if (this.tvect == null || this.tvect.length < this.nvert * 3) {
                this.tvect = new int[this.nvert * 3];
            }
            this.mat.transform(this.vect, this.tvect, this.nvert);
        }
    }
}

