/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.miniJmol;

import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.openscience.miniJmol.AtomTypeLookup;
import org.openscience.miniJmol.ChemFrame;
import org.openscience.miniJmol.FortranFormat;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class CMLHandler
extends HandlerBase {
    private final int UNKNOWN = -1;
    private final int STRING = 1;
    private final int LINK = 2;
    private final int FLOAT = 3;
    private final int INTEGER = 4;
    private final int STRINGARRAY = 5;
    private final int FLOATARRAY = 6;
    private final int INTEGERARRAY = 7;
    private final int FLOATMATRIX = 8;
    private final int COORDINATE2 = 9;
    private final int COORDINATE3 = 10;
    private final int ANGLE = 11;
    private final int TORSION = 12;
    private final int LIST = 13;
    private final int MOLECULE = 14;
    private final int ATOM = 15;
    private final int ATOMARRAY = 16;
    private final int BOND = 17;
    private final int BONDARRAY = 18;
    private final int ELECTRON = 19;
    private final int REACTION = 20;
    private final int CRYSTAL = 21;
    private final int SEQUENCE = 22;
    private final int FEATURE = 23;
    private final String SYSTEMID = "CML-1999-05-15";
    private int CurrentElement;
    private String BUILTIN = "";
    private ChemFrame cf;
    private Vector cfs = new Vector();
    private int frameNo;
    private Vector elsym;
    private Vector elid;
    private Vector x3;
    private Vector y3;
    private Vector z3;
    private AtomTypeLookup atlu;

    public CMLHandler(AtomTypeLookup atomTypeLookup) {
        this.atlu = atomTypeLookup;
        this.frameNo = 0;
    }

    public void characters(char[] cArray, int n, int n2) {
        String string = this.toString(cArray, n, n2).trim();
        switch (this.CurrentElement) {
            case 1: {
                if (!this.BUILTIN.equals("elementType")) break;
                this.warn("New elementType found.");
                this.elsym.addElement(string);
                break;
            }
            case 10: {
                if (!this.BUILTIN.equals("xyz3")) break;
                this.warn("New coord found." + string);
                try {
                    StringTokenizer stringTokenizer = new StringTokenizer(string);
                    this.x3.addElement(stringTokenizer.nextToken());
                    this.y3.addElement(stringTokenizer.nextToken());
                    this.z3.addElement(stringTokenizer.nextToken());
                }
                catch (Exception exception) {
                    this.notify("CMLParsing error: " + exception, "CML-1999-05-15", 175, 1);
                }
                break;
            }
            case 5: {
                if (this.BUILTIN.equals("id")) {
                    this.warn("New id found.");
                    try {
                        StringTokenizer stringTokenizer = new StringTokenizer(string);
                        while (stringTokenizer.hasMoreTokens()) {
                            this.elid.addElement(stringTokenizer.nextToken());
                        }
                    }
                    catch (Exception exception) {
                        this.notify("CMLParsing error: " + exception, "CML-1999-05-15", 186, 1);
                    }
                    break;
                }
                if (!this.BUILTIN.equals("elementType")) break;
                this.warn("New elementTypes found.");
                try {
                    StringTokenizer stringTokenizer = new StringTokenizer(string);
                    while (stringTokenizer.hasMoreTokens()) {
                        this.elsym.addElement(stringTokenizer.nextToken());
                    }
                }
                catch (Exception exception) {
                    this.notify("CMLParsing error: " + exception, "CML-1999-05-15", 194, 1);
                }
                break;
            }
            case 6: {
                if (this.BUILTIN.equals("x3")) {
                    this.warn("New floatArray found.");
                    try {
                        StringTokenizer stringTokenizer = new StringTokenizer(string);
                        while (stringTokenizer.hasMoreTokens()) {
                            this.x3.addElement(stringTokenizer.nextToken());
                        }
                    }
                    catch (Exception exception) {
                        this.notify("CMLParsing error: " + exception, "CML-1999-05-15", 205, 1);
                    }
                    break;
                }
                if (this.BUILTIN.equals("y3")) {
                    this.warn("New floatArray found.");
                    try {
                        StringTokenizer stringTokenizer = new StringTokenizer(string);
                        while (stringTokenizer.hasMoreTokens()) {
                            this.y3.addElement(stringTokenizer.nextToken());
                        }
                    }
                    catch (Exception exception) {
                        this.notify("CMLParsing error: " + exception, "CML-1999-05-15", 213, 1);
                    }
                    break;
                }
                if (!this.BUILTIN.equals("z3")) break;
                this.warn("New floatArray found.");
                try {
                    StringTokenizer stringTokenizer = new StringTokenizer(string);
                    while (stringTokenizer.hasMoreTokens()) {
                        this.z3.addElement(stringTokenizer.nextToken());
                    }
                }
                catch (Exception exception) {
                    this.notify("CMLParsing error: " + exception, "CML-1999-05-15", 221, 1);
                }
                break;
            }
        }
    }

    public void doctypeDecl(String string, String string2, String string3) throws Exception {
        this.warn("Name: " + string);
        this.warn("PublicId: " + string2);
        this.warn("SystemId: " + string3);
    }

    public void endDocument() {
    }

    public void endElement(String string) {
        this.setCurrentElement(string);
        System.out.println("End ELEMENT " + string);
        this.BUILTIN = "";
        switch (this.CurrentElement) {
            case 14: {
                int n = this.elsym.size();
                if (this.x3.size() == n && this.y3.size() == n && this.z3.size() == n) {
                    this.warn("About to add info to ChemFrame.");
                    Enumeration enumeration = this.elsym.elements();
                    Enumeration enumeration2 = this.x3.elements();
                    Enumeration enumeration3 = this.y3.elements();
                    Enumeration enumeration4 = this.z3.elements();
                    while (enumeration.hasMoreElements()) {
                        String string2 = (String)enumeration.nextElement();
                        double d = FortranFormat.atof((String)enumeration2.nextElement());
                        double d2 = FortranFormat.atof((String)enumeration3.nextElement());
                        double d3 = FortranFormat.atof((String)enumeration4.nextElement());
                        try {
                            System.out.println(String.valueOf(string2) + " " + d);
                            this.cf.addVert(string2, (float)d, (float)d2, (float)d3);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            this.notify("CMLhandler error while adding atom: " + exception, "CML-1999-05-15", 149, 1);
                        }
                    }
                }
                this.warn("About to add ChemFrame to list.");
                this.cfs.addElement(this.cf);
                this.warn("Current size cfs: " + this.cfs.size());
                break;
            }
        }
    }

    public void error(String string, String string2, int n, int n2) throws Exception {
        this.notify(string, string2, n, n2);
    }

    public void notify(String string, String string2, int n, int n2) {
        System.out.println("Message: " + string);
        System.out.println("SystemId: " + string2);
        System.out.println("Line: " + n);
        System.out.println("Column: " + n2);
    }

    public Vector returnChemFrames() {
        return this.cfs;
    }

    private void setCurrentElement(String string) {
        this.CurrentElement = string.equals("string") ? 1 : (string.equals("link") ? 2 : (string.equals("float") ? 3 : (string.equals("integer") ? 4 : (string.equals("stringArray") ? 5 : (string.equals("floatArray") ? 6 : (string.equals("integerArray") ? 7 : (string.equals("floatMatrix") ? 8 : (string.equals("coordinate2") ? 9 : (string.equals("coordinate3") ? 10 : (string.equals("angle") ? 11 : (string.equals("torsion") ? 12 : (string.equals("list") ? 13 : (string.equals("molecule") ? 14 : (string.equals("atom") ? 15 : (string.equals("atomArray") ? 16 : (string.equals("bond") ? 17 : (string.equals("bondArray") ? 18 : (string.equals("electron") ? 19 : (string.equals("reaction") ? 20 : (string.equals("crystal") ? 21 : (string.equals("sequence") ? 22 : (string.equals("feature") ? 23 : -1))))))))))))))))))))));
    }

    public void startDocument() {
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        System.out.println("name = " + string);
        this.setCurrentElement(string);
        switch (this.CurrentElement) {
            case 15: {
                int n = 0;
                while (n < attributeList.getLength()) {
                    if (attributeList.getName(n).equals("id")) {
                        this.elid.addElement(attributeList.getValue(n));
                        this.warn("New atom found: " + attributeList.getValue(n));
                    }
                    ++n;
                }
                break;
            }
            case 10: {
                int n = 0;
                while (n < attributeList.getLength()) {
                    if (attributeList.getName(n).equals("builtin")) {
                        this.BUILTIN = attributeList.getValue(n);
                        this.warn("Valid element coord found, builtin: " + attributeList.getValue(n));
                    }
                    ++n;
                }
                break;
            }
            case 1: {
                int n = 0;
                while (n < attributeList.getLength()) {
                    if (attributeList.getName(n).equals("builtin")) {
                        this.BUILTIN = attributeList.getValue(n);
                    }
                    ++n;
                }
                break;
            }
            case 5: {
                int n = 0;
                while (n < attributeList.getLength()) {
                    if (attributeList.getName(n).equals("builtin")) {
                        this.BUILTIN = attributeList.getValue(n);
                    }
                    ++n;
                }
                break;
            }
            case 6: {
                int n = 0;
                while (n < attributeList.getLength()) {
                    if (attributeList.getName(n).equals("builtin")) {
                        this.BUILTIN = attributeList.getValue(n);
                    }
                    ++n;
                }
                break;
            }
            case 14: {
                this.cf = new ChemFrame();
                this.cf.setAtomTypeLookup(this.atlu);
                this.elsym = new Vector();
                this.elid = new Vector();
                this.x3 = new Vector();
                this.y3 = new Vector();
                this.z3 = new Vector();
                ++this.frameNo;
                int n = 0;
                while (n < attributeList.getLength()) {
                    if (attributeList.getName(n).equals("id")) {
                        this.cf.setInfo(attributeList.getValue(n));
                    }
                    ++n;
                }
                System.out.println("New Frame found: " + this.frameNo);
                break;
            }
            case 13: {
                int n = 0;
                while (n < attributeList.getLength()) {
                    if (attributeList.getName(n).equals("convention")) {
                        this.warn("Convention: " + attributeList.getValue(n));
                    }
                    ++n;
                }
                break;
            }
        }
    }

    private String toString(char[] cArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        while (n3 < n2) {
            stringBuffer.append(cArray[n + n3]);
            ++n3;
        }
        return stringBuffer.toString();
    }

    public void warn(String string) {
        System.out.println(string);
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        sAXParseException.printStackTrace();
    }
}

