/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.miniJmol;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import javax.swing.JPanel;
import org.openscience.miniJmol.AtomType;

public class Bond {
    private JPanel jpanel;
    private float screenScale;
    public static final int QUICKDRAW = 0;
    public static final int SHADING = 1;
    public static final int WIREFRAME = 2;
    public static final int LINE = 3;
    private int DrawMode = 0;
    private boolean bondsToAtomCenters = false;
    private Color outlineColor = Color.black;
    private float Smoothness = 0.7f;
    private double bondwidth = 0.1;
    private AtomType at1;
    private AtomType at2;
    private Color col1;
    private Color col2;

    public Bond(AtomType atomType, AtomType atomType2) {
        this.at1 = atomType;
        this.at2 = atomType2;
        this.col1 = atomType.getColor();
        this.col2 = atomType2.getColor();
    }

    public double getBondWidth() {
        return this.bondwidth;
    }

    public boolean getBondsToAtomCenters() {
        return this.bondsToAtomCenters;
    }

    public Color getOutlineColor() {
        return this.outlineColor;
    }

    public int getRenderMode() {
        return this.DrawMode;
    }

    public void paint(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        this.paint(graphics, n, n2, n3, n4, n5, n6, false);
    }

    public void paint(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        block16: {
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            int n12;
            block15: {
                double d;
                double d2;
                n12 = (n + n4) / 2;
                n11 = (n2 + n5) / 2;
                double d3 = n4 - n;
                double d4 = d3 * d3;
                double d5 = n5 - n2;
                double d6 = d5 * d5;
                double d7 = n6 - n3;
                double d8 = Math.sqrt(d4 + d6) / Math.sqrt(d4 + d6 + d7 * d7);
                if (this.bondsToAtomCenters || bl) {
                    d2 = 0.0;
                    d = 0.0;
                } else {
                    d2 = d8 * (double)this.at1.getCircleRadius(n3);
                    d = d8 * (double)this.at2.getCircleRadius(n6);
                }
                double d9 = d3 * d3 + d5 * d5;
                double d10 = d5 / d3;
                if (d9 <= (d2 + d) * (d2 + d)) {
                    return;
                }
                double d11 = 0.0;
                double d12 = 0.0;
                n10 = 0;
                n9 = 0;
                n8 = 0;
                n7 = 0;
                if (n == n4) {
                    if (n2 > n5) {
                        n9 = -((int)Math.round(d2));
                        n7 = (int)Math.round(d);
                    } else {
                        n9 = (int)Math.round(d2);
                        n7 = -((int)Math.round(d));
                    }
                } else if (n >= n4) {
                    d11 = -Math.sqrt(d2 * d2 / (1.0 + d10 * d10));
                    d12 = -Math.sqrt(d * d / (1.0 + d10 * d10));
                    n10 = (int)Math.round(d11);
                    n8 = -((int)Math.round(d12));
                    n9 = (int)Math.round(d11 * d10);
                    n7 = -((int)Math.round(d12 * d10));
                } else {
                    d11 = Math.sqrt(d2 * d2 / (1.0 + d10 * d10));
                    d12 = Math.sqrt(d * d / (1.0 + d10 * d10));
                    n10 = (int)Math.round(d11);
                    n8 = -((int)Math.round(d12));
                    n9 = (int)Math.round(d11 * d10);
                    n7 = -((int)Math.round(d12 * d10));
                }
                if (this.DrawMode == 3 || bl) {
                    graphics.setColor(this.col1);
                    graphics.drawLine(n + n10, n2 + n9, n12, n11);
                    graphics.setColor(this.col2);
                    graphics.drawLine(n4 + n8, n5 + n7, n12, n11);
                    return;
                }
                double d13 = 0.5 * this.bondwidth * (double)this.screenScale;
                if (!(d13 >= 0.5)) break block15;
                int n13 = 4;
                int[] nArray = new int[n13];
                int[] nArray2 = new int[n13];
                double d14 = -d3 / d5;
                double d15 = Math.sqrt(d13 * d13 / (1.0 + d14 * d14));
                int n14 = (int)Math.round(d15);
                int n15 = n14 == 0 ? (int)Math.round(d13) : (int)Math.round(d15 * d14);
                nArray[0] = n + n10 + n14;
                nArray2[0] = n2 + n9 + n15;
                nArray[1] = n + n10 - n14;
                nArray2[1] = n2 + n9 - n15;
                nArray[2] = n12 - n14;
                nArray2[2] = n11 - n15;
                nArray[3] = n12 + n14;
                nArray2[3] = n11 + n15;
                Polygon polygon = new Polygon(nArray, nArray2, 4);
                nArray[0] = n4 + n8 + n14;
                nArray2[0] = n5 + n7 + n15;
                nArray[1] = n4 + n8 - n14;
                nArray2[1] = n5 + n7 - n15;
                Polygon polygon2 = new Polygon(nArray, nArray2, 4);
                switch (this.DrawMode) {
                    case 2: {
                        graphics.setColor(this.col1);
                        graphics.drawPolygon(polygon);
                        graphics.setColor(this.col2);
                        graphics.drawPolygon(polygon2);
                        break;
                    }
                    case 1: {
                        int n16 = (int)(2.0 * d13);
                        while (n16 > -1) {
                            double d16 = (double)n16 / (2.0 * d13);
                            int n17 = (int)((double)this.col1.getRed() * (1.0 - d16));
                            int n18 = (int)((double)this.col1.getGreen() * (1.0 - d16));
                            int n19 = (int)((double)this.col1.getBlue() * (1.0 - d16));
                            int n20 = 0xFF000000 | n17 << 16 | n18 << 8 | n19;
                            int n21 = (int)((double)this.col2.getRed() * (1.0 - d16));
                            int n22 = (int)((double)this.col2.getGreen() * (1.0 - d16));
                            int n23 = (int)((double)this.col2.getBlue() * (1.0 - d16));
                            int n24 = 0xFF000000 | n21 << 16 | n22 << 8 | n23;
                            double d17 = Math.round(d15);
                            double d18 = (int)d17 == 0 ? (double)Math.round(d13) : (double)Math.round(d15 * d14);
                            int n25 = (int)(2.0 * d17 * d16);
                            int n26 = (int)(2.0 * d18 * d16);
                            graphics.setColor(new Color(n20));
                            nArray[0] = n + n10 + n25;
                            nArray2[0] = n2 + n9 + n26;
                            nArray[1] = n + n10 - n25;
                            nArray2[1] = n2 + n9 - n26;
                            nArray[2] = n12 - n25;
                            nArray2[2] = n11 - n26;
                            nArray[3] = n12 + n25;
                            nArray2[3] = n11 + n26;
                            Polygon polygon3 = new Polygon(nArray, nArray2, 4);
                            graphics.fillPolygon(polygon3);
                            graphics.setColor(new Color(n24));
                            nArray[0] = n4 + n8 + n25;
                            nArray2[0] = n5 + n7 + n26;
                            nArray[1] = n4 + n8 - n25;
                            nArray2[1] = n5 + n7 - n26;
                            Polygon polygon4 = new Polygon(nArray, nArray2, 4);
                            graphics.fillPolygon(polygon4);
                            --n16;
                        }
                        break block16;
                    }
                    default: {
                        graphics.setColor(this.col1);
                        graphics.fillPolygon(polygon);
                        graphics.setColor(this.outlineColor);
                        graphics.drawPolygon(polygon);
                        graphics.setColor(this.col2);
                        graphics.fillPolygon(polygon2);
                        graphics.setColor(this.outlineColor);
                        graphics.drawPolygon(polygon2);
                        break;
                    }
                }
                break block16;
            }
            graphics.setColor(this.col1);
            graphics.drawLine(n + n10, n2 + n9, n12, n11);
            graphics.setColor(this.col2);
            graphics.drawLine(n4 + n8, n5 + n7, n12, n11);
        }
    }

    public void setBondWidth(double d) {
        this.bondwidth = d;
    }

    public void setBondsToAtomCenters(boolean bl) {
        this.bondsToAtomCenters = bl;
    }

    public void setJPanel(JPanel jPanel) {
        this.jpanel = jPanel;
    }

    public void setLine() {
        this.DrawMode = 3;
    }

    public void setOutlineColor(Color color) {
        this.outlineColor = color;
    }

    public void setQuickDraw() {
        this.DrawMode = 0;
    }

    public void setRenderMode(int n) {
        this.DrawMode = n;
    }

    public void setScreenScale(float f) {
        this.screenScale = f;
    }

    public void setShading() {
        this.DrawMode = 1;
    }

    public void setWireFrame() {
        this.DrawMode = 2;
    }

    public void toggleBondsToAtomCenters() {
        this.bondsToAtomCenters ^= true;
    }
}

