/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.miniJmol;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.MemoryImageSource;
import java.util.Vector;
import org.openscience.miniJmol.PhysicalProperty;

public class AtomType {
    private Canvas jpanel;
    private static float[] lightsource = new float[]{1.0f, -1.0f, 2.0f};
    private float screenScale;
    private int zOffset;
    private float depthFactor = 0.33f;
    public static final int QUICKDRAW = 0;
    public static final int SHADING = 1;
    public static final int WIREFRAME = 2;
    private int DrawMode = 0;
    public static final int NOLABELS = 0;
    public static final int SYMBOLS = 1;
    public static final int TYPES = 2;
    public static final int NUMBERS = 3;
    private int LabelMode = 0;
    private String PropsMode = "";
    private boolean drawText = false;
    private Color outlineColor = Color.black;
    private Color pickedColor = Color.orange;
    private Color textColor = Color.black;
    private static double sphereFactor = 0.2;
    private String name;
    private String root;
    private int AtomicNumber;
    private double mass;
    private double vdWRadius;
    private double covalentRadius;
    private int Rl;
    private int Gl;
    private int Bl;
    private Image ball;
    private Color col;

    public AtomType(int n, int n2, int n3) {
        this.Rl = n;
        this.Gl = n2;
        this.Bl = n3;
        this.col = new Color(n, n2, n3);
    }

    public AtomType(String string, String string2, int n, double d, double d2, double d3, int n2, int n3, int n4) {
        this.name = string;
        this.root = string2;
        this.AtomicNumber = n;
        this.mass = d;
        this.vdWRadius = d2;
        this.covalentRadius = d3;
        this.Rl = n2;
        this.Gl = n3;
        this.Bl = n4;
        this.col = new Color(n2, n3, n4);
    }

    private void SphereSetup() {
        float[] fArray = new float[3];
        float[] fArray2 = new float[3];
        int n = 40;
        int n2 = 2 * n + 1;
        int n3 = -1;
        int[] nArray = new int[n2 * n2];
        lightsource = this.normalize(lightsource);
        int n4 = -n;
        while (n4 <= n) {
            int n5 = -n;
            while (n5 <= n) {
                ++n3;
                fArray[0] = n5;
                fArray[1] = n4;
                float f = (float)Math.sqrt(n5 * n5 + n4 * n4);
                if (f <= (float)n) {
                    int n6 = 0;
                    int n7 = 0;
                    int n8 = 0;
                    fArray[2] = (float)n * (float)Math.cos(Math.asin(f / (float)n));
                    float f2 = (float)Math.abs((double)((fArray = this.normalize(fArray))[0] * lightsource[0] + fArray[1] * lightsource[1] + fArray[2] * lightsource[2]));
                    if (f2 < 0.995f) {
                        n6 = (int)((float)this.Rl * f2);
                        n7 = (int)((float)this.Gl * f2);
                        n8 = (int)((float)this.Bl * f2);
                    } else {
                        fArray2[0] = lightsource[0] + 0.0f;
                        fArray2[1] = lightsource[1] + 0.0f;
                        fArray2[2] = lightsource[2] + 1.0f;
                        fArray2 = this.normalize(fArray2);
                        float f3 = fArray[0] * fArray2[0] + fArray[1] * fArray2[1] + fArray[2] * fArray2[2];
                        float f4 = 8.0f * f3 * f3 - 7.0f;
                        float f5 = 100.0f * f4;
                        f5 = Math.max(f5, 0.0f);
                        n6 = (int)((double)((float)(this.Rl * 155) * f2) + 100.0 + (double)f5);
                        n7 = (int)((double)((float)(this.Gl * 155) * f2) + 100.0 + (double)f5);
                        n8 = (int)((double)((float)(this.Bl * 155) * f2) + 100.0 + (double)f5);
                        n6 = Math.min(n6, 255);
                        n7 = Math.min(n7, 255);
                        n8 = Math.min(n8, 255);
                    }
                    nArray[n3] = 0xFF000000 | n6 << 16 | n7 << 8 | n8;
                } else {
                    nArray[n3] = 0;
                }
                ++n5;
            }
            ++n4;
        }
        this.ball = this.jpanel.createImage(new MemoryImageSource(n2, n2, nArray, 0, n2));
    }

    private final int blend(int n, int n2, float f) {
        return (int)((float)n2 + (float)(n - n2) * f);
    }

    public int getAtomicNumber() {
        return this.AtomicNumber;
    }

    public float getCircleRadius(int n) {
        double d = this.vdWRadius * sphereFactor;
        float f = (float)(n - this.zOffset) / (2.0f * (float)this.zOffset);
        float f2 = this.screenScale * ((float)d + this.depthFactor * f);
        return f2 < 0.0f ? 1.0f : f2;
    }

    public Color getColor() {
        return this.col;
    }

    public double getCovalentRadius() {
        return this.covalentRadius;
    }

    public int getLabelMode() {
        return this.LabelMode;
    }

    public double getMass() {
        return this.mass;
    }

    public String getName() {
        return this.name;
    }

    public String getPropsMode() {
        return this.PropsMode;
    }

    public int getRenderMode() {
        return this.DrawMode;
    }

    public String getRoot() {
        return this.root;
    }

    public double getSphereFactor() {
        return sphereFactor;
    }

    public double getvdWRadius() {
        return this.vdWRadius;
    }

    private float[] normalize(float[] fArray) {
        float f = (float)Math.sqrt(fArray[0] * fArray[0] + fArray[1] * fArray[1] + fArray[2] * fArray[2]);
        float[] fArray2 = new float[3];
        if (f == 0.0f) {
            fArray2[0] = 0.0f;
            fArray2[1] = 0.0f;
            fArray2[2] = 0.0f;
        } else {
            fArray2[0] = fArray[0] / f;
            fArray2[1] = fArray[1] / f;
            fArray2[2] = fArray[2] / f;
        }
        return fArray2;
    }

    public void paint(Graphics graphics, int n, int n2, int n3, int n4, Vector vector, boolean bl) {
        int n5;
        Object object;
        Font font;
        int n6;
        int n7 = (int)(2.0f * this.getCircleRadius(n3));
        int n8 = n7 >> 1;
        if (bl) {
            n6 = n8 + 5;
            int n9 = 2 * n6;
            graphics.setColor(this.pickedColor);
            graphics.fillOval(n - n6, n2 - n6, n9, n9);
        }
        switch (this.DrawMode) {
            case 2: {
                graphics.setColor(this.col);
                graphics.drawOval(n - n8, n2 - n8, n7, n7);
                break;
            }
            case 1: {
                Image image = this.ball;
                if (image == null) {
                    this.SphereSetup();
                    image = this.ball;
                }
                Image image2 = image;
                graphics.drawImage(image2, n - n8, n2 - n8, n7, n7, this.jpanel);
                break;
            }
            default: {
                graphics.setColor(this.col);
                graphics.fillOval(n - n8, n2 - n8, n7, n7);
                graphics.setColor(this.outlineColor);
                graphics.drawOval(n - n8, n2 - n8, n7, n7);
            }
        }
        if (this.LabelMode != 0) {
            n6 = 0;
            font = new Font("Helvetica", 0, n8);
            graphics.setFont(font);
            object = graphics.getFontMetrics(font);
            n5 = ((FontMetrics)object).getAscent();
            graphics.setColor(this.textColor);
            switch (this.LabelMode) {
                case 1: {
                    n6 = ((FontMetrics)object).stringWidth(this.root);
                    graphics.drawString(this.root, n - n6 / 2, n2 + n5 / 2);
                    break;
                }
                case 2: {
                    n6 = ((FontMetrics)object).stringWidth(this.name);
                    graphics.drawString(this.name, n - n6 / 2, n2 + n5 / 2);
                    break;
                }
                case 3: {
                    String string = new Integer(n4).toString();
                    n6 = ((FontMetrics)object).stringWidth(string);
                    graphics.drawString(string, n - n6 / 2, n2 + n5 / 2);
                    break;
                }
            }
        }
        if (!this.PropsMode.equals("")) {
            n6 = 0;
            while (n6 < vector.size()) {
                PhysicalProperty physicalProperty = (PhysicalProperty)vector.elementAt(n6);
                if (physicalProperty.getDescriptor().equals(this.PropsMode)) {
                    font = new Font("Helvetica", 0, n8 / 2);
                    graphics.setFont(font);
                    graphics.setColor(this.textColor);
                    object = physicalProperty.stringValue();
                    if (((String)object).length() > 5) {
                        object = ((String)object).substring(0, 5);
                    }
                    n5 = 2 + (int)((float)n8 / 1.4142137f);
                    graphics.drawString((String)object, n + n5, n2 - n5);
                }
                ++n6;
            }
        }
    }

    public void setAtomicNumber(int n) {
        this.AtomicNumber = n;
    }

    public void setCanvas(Canvas canvas) {
        this.jpanel = canvas;
    }

    public void setColor(Color color) {
        this.col = color;
    }

    public void setCovalentRadius(double d) {
        this.covalentRadius = d;
    }

    public void setDepthFactor(float f) {
        this.depthFactor = f;
    }

    public void setLabelMode(int n) {
        this.LabelMode = n;
    }

    public void setMass(double d) {
        this.mass = d;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setOutlineColor(Color color) {
        this.outlineColor = color;
    }

    public void setPickedColor(Color color) {
        this.pickedColor = color;
    }

    public void setPropsMode(String string) {
        this.PropsMode = string;
    }

    public void setQuickDraw() {
        this.DrawMode = 0;
    }

    public void setRenderMode(int n) {
        this.DrawMode = n;
    }

    public void setRoot(String string) {
        this.root = string;
    }

    public void setScreenScale(float f) {
        this.screenScale = f;
    }

    public void setShading() {
        this.DrawMode = 1;
    }

    public void setSphereFactor(double d) {
        sphereFactor = d;
    }

    public void setTextColor(Color color) {
        this.textColor = color;
    }

    public void setWireFrame() {
        this.DrawMode = 2;
    }

    public void setZoffset(int n) {
        this.zOffset = n;
    }

    public void setvdWRadius(double d) {
        this.vdWRadius = d;
    }
}

