/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.miniJmol;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.StringTokenizer;
import java.util.Vector;
import org.openscience.miniJmol.ChemFile;
import org.openscience.miniJmol.ChemFrame;
import org.openscience.miniJmol.Matrix3D;

public class displayPanel
extends Canvas
implements Runnable,
ComponentListener {
    private boolean Perspective;
    private float FieldOfView;
    private boolean painted = false;
    private boolean initialized = false;
    private boolean haveFile = false;
    private boolean rubberband = false;
    private boolean AntiAliased = false;
    private int bx;
    private int by;
    private int rtop;
    private int rbottom;
    private int rleft;
    private int rright;
    private int fileType;
    private int nframes = 0;
    private int prevx;
    private int prevy;
    private int outx;
    private int outy;
    private float xtheta;
    private float ytheta;
    private float ztheta;
    private Matrix3D amat = new Matrix3D();
    private Matrix3D tmat = new Matrix3D();
    private Matrix3D zmat = new Matrix3D();
    private Matrix3D mat = new Matrix3D();
    float[] quat = new float[4];
    double[] mtmp;
    String[] names;
    Color[] colors;
    private double angle;
    private double prevangle;
    ChemFile cf;
    ChemFrame md;
    private float xfac;
    private float xmin;
    private float xmax;
    private float ymin;
    private float ymax;
    private float zmin;
    private float zmax;
    private float scalefudge = 1.0f;
    public static final int ROTATE = 0;
    public static final int ZOOM = 1;
    public static final int XLATE = 2;
    public static final int PICK = 3;
    public static final int DEFORM = 4;
    public static final int MEASURE = 5;
    private int mode = 0;
    private Color backgroundColor = null;
    private boolean mouseDragged = false;
    private boolean WireFrameRotation = false;
    private Image db;
    private int width;
    private int height;

    public displayPanel() {
        this.setBackground(Color.black);
        this.backgroundColor = Color.black;
        this.setForeground(Color.white);
    }

    static /* synthetic */ int access$25(displayPanel displayPanel2) {
        return displayPanel2.outx;
    }

    static /* synthetic */ int access$27(displayPanel displayPanel2) {
        return displayPanel2.outy;
    }

    static /* synthetic */ boolean access$5(displayPanel displayPanel2) {
        return displayPanel2.rubberband;
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.requestFocus();
        Dimension dimension = this.getSize();
        this.width = dimension.width;
        this.height = dimension.height;
        this.db = this.createImage(this.width, this.height);
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public boolean getAntiAliased() {
        return this.AntiAliased;
    }

    public int getAtomRenderMode() {
        return this.md.atoms[0].getRenderMode();
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public int getBondRenderMode() {
        return this.md.bonds[0].getRenderMode();
    }

    public float getFieldOfView() {
        return this.FieldOfView;
    }

    public Color getForegroundColor() {
        return this.getForeground();
    }

    public ChemFrame getFrame() {
        return this.md;
    }

    public int getLabelMode() {
        return this.md.atoms[0].getLabelMode();
    }

    public int getMode() {
        return this.mode;
    }

    public boolean getPerspective() {
        return this.Perspective;
    }

    public boolean getShowAtoms() {
        return this.md.getShowAtoms();
    }

    public boolean getShowBonds() {
        return this.md.getShowBonds();
    }

    public boolean getShowVectors() {
        return this.md.getShowVectors();
    }

    public boolean getWireframeRotation() {
        return this.WireFrameRotation;
    }

    public void init() {
        float f;
        float f2;
        this.md.findBB();
        this.xmin = this.md.xmin;
        this.xmax = this.md.xmax;
        this.ymin = this.md.ymin;
        this.ymax = this.md.ymax;
        this.zmin = this.md.zmin;
        this.zmax = this.md.zmax;
        float f3 = this.md.xmax - this.md.xmin;
        float f4 = this.md.ymax - this.md.ymin;
        float f5 = this.md.zmax - this.md.zmin;
        if (f4 > f3) {
            f3 = f4;
        }
        if (f5 > f3) {
            f3 = f5;
        }
        this.xfac = 0.7f * ((f2 = (float)this.getSize().width / f3) < (f = (float)this.getSize().height / f3) ? f2 : f) * this.scalefudge;
        int n = 0;
        while (n < this.nframes) {
            this.cf.getFrame(n).setAtomScreenScale(this.xfac);
            this.cf.getFrame(n).setBondScreenScale(this.xfac);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.nframes) {
            this.cf.getFrame(n2).setScreenScale(this.xfac);
            ++n2;
        }
        this.repaint();
    }

    public boolean isPainting() {
        return this.painted ^ true;
    }

    public void paint(Graphics graphics) {
        this.paintBuffer(this.db.getGraphics());
        graphics.drawImage(this.db, 0, 0, this);
    }

    public void paintBuffer(Graphics graphics) {
        if (this.backgroundColor == null) {
            this.setBackgroundColor();
        }
        Color color = this.backgroundColor;
        Color color2 = this.getForeground();
        if (this.md == null) {
            graphics.setColor(color);
            graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
        } else {
            if (!this.initialized) {
                this.amat.unit();
                this.tmat.unit();
                this.zmat.unit();
                this.quat[0] = 0.0f;
                this.quat[1] = 0.0f;
                this.quat[2] = 0.0f;
                this.quat[3] = 1.0f;
                this.initialized = true;
            }
            int n = 0;
            while (n < this.nframes) {
                this.cf.getFrame(n).setScreenScale(this.xfac);
                this.cf.getFrame(n).matunit();
                this.cf.getFrame(n).mattranslate(-(this.xmin + this.xmax) / 2.0f, -(this.ymin + this.ymax) / 2.0f, -(this.zmin + this.zmax) / 2.0f);
                this.cf.getFrame(n).matmult(this.amat);
                this.cf.getFrame(n).matscale(this.xfac, -this.xfac, this.xfac);
                this.cf.getFrame(n).matmult(this.tmat);
                this.cf.getFrame(n).matmult(this.zmat);
                this.cf.getFrame(n).mattranslate(this.getSize().width / 2, this.getSize().height / 2, this.getSize().width / 2);
                this.cf.getFrame(n).setZoffset(this.getSize().width / 2);
                ++n;
            }
            graphics.setColor(color);
            graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
            graphics.setColor(color2);
            this.md.paint(graphics);
            if (this.rubberband) {
                graphics.setColor(color2);
                graphics.drawRect(this.rleft, this.rtop, this.rright - this.rleft, this.rbottom - this.rtop);
            }
            this.painted = true;
        }
    }

    public void rebond() throws Exception {
        if (this.md != null) {
            this.md.rebond();
        }
    }

    public void run() {
        try {
            Thread.currentThread().setPriority(1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.repaint();
    }

    public void setAntiAliased(boolean bl) {
        this.AntiAliased = bl;
    }

    public void setAtomQuickDraw() {
        int n = 0;
        while (n < this.nframes) {
            this.cf.getFrame(n).setAtomRenderMode(0);
            ++n;
        }
        if (this.painted) {
            this.painted = false;
        }
        this.repaint();
    }

    public void setAtomShaded() {
        int n = 0;
        while (n < this.nframes) {
            this.cf.getFrame(n).setAtomRenderMode(1);
            ++n;
        }
        if (this.painted) {
            this.painted = false;
        }
        this.repaint();
    }

    public void setAtomWireframe() {
        int n = 0;
        while (n < this.nframes) {
            this.cf.getFrame(n).setAtomRenderMode(2);
            ++n;
        }
        if (this.painted) {
            this.painted = false;
        }
        this.repaint();
    }

    public void setBackgroundColor() {
        this.setBackgroundColor(this.backgroundColor);
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    public void setBondLine() {
        int n = 0;
        while (n < this.nframes) {
            this.cf.getFrame(n).setBondRenderMode(3);
            ++n;
        }
        if (this.painted) {
            this.painted = false;
        }
        this.repaint();
    }

    public void setBondQuickDraw() {
        int n = 0;
        while (n < this.nframes) {
            this.cf.getFrame(n).setBondRenderMode(0);
            ++n;
        }
        if (this.painted) {
            this.painted = false;
        }
        this.repaint();
    }

    public void setBondShaded() {
        int n = 0;
        while (n < this.nframes) {
            this.cf.getFrame(n).setBondRenderMode(1);
            ++n;
        }
        if (this.painted) {
            this.painted = false;
        }
        this.repaint();
    }

    public void setBondWireframe() {
        int n = 0;
        while (n < this.nframes) {
            this.cf.getFrame(n).setBondRenderMode(2);
            ++n;
        }
        if (this.painted) {
            this.painted = false;
        }
        this.repaint();
    }

    public void setChemFile(ChemFile chemFile) {
        this.cf = chemFile;
        this.haveFile = true;
        this.nframes = chemFile.nFrames();
        this.md = chemFile.getFrame(0);
        this.init();
    }

    public void setFieldOfView(float f) {
        this.FieldOfView = f;
    }

    public void setForegroundColor(Color color) {
        this.setForeground(color);
    }

    public void setFrame(int n) {
        if (this.haveFile) {
            if (n < this.nframes) {
                this.md = this.cf.getFrame(n);
            }
            this.repaint();
        }
    }

    public void setLabelsToAtomNumbers() {
        int n = 0;
        while (n < this.nframes) {
            this.cf.getFrame(n).setLabelMode(3);
            ++n;
        }
        if (this.painted) {
            this.painted = false;
        }
        this.repaint();
    }

    public void setLabelsToNone() {
        int n = 0;
        while (n < this.nframes) {
            this.cf.getFrame(n).setLabelMode(0);
            ++n;
        }
        if (this.painted) {
            this.painted = false;
        }
        this.repaint();
    }

    public void setLabelsToSymbols() {
        int n = 0;
        while (n < this.nframes) {
            this.cf.getFrame(n).setLabelMode(1);
            ++n;
        }
        if (this.painted) {
            this.painted = false;
        }
        this.repaint();
    }

    public void setLabelsToTypes() {
        int n = 0;
        while (n < this.nframes) {
            this.cf.getFrame(n).setLabelMode(2);
            ++n;
        }
        if (this.painted) {
            this.painted = false;
        }
        this.repaint();
    }

    public void setMode(int n) {
        this.mode = n;
    }

    public void setPerspective(boolean bl) {
        this.Perspective = bl;
    }

    public void setWireframeRotation(boolean bl) {
        this.WireFrameRotation = bl;
    }

    public void showAtoms(boolean bl) {
        int n = 0;
        while (n < this.nframes) {
            this.cf.getFrame(n).setShowAtoms(bl);
            this.cf.getFrame(n).setBondsToAtomCenters(bl ^ true);
            ++n;
        }
        if (this.painted) {
            this.painted = false;
        }
        this.repaint();
    }

    public void showBonds(boolean bl) {
        int n = 0;
        while (n < this.nframes) {
            this.cf.getFrame(n).setShowBonds(bl);
            ++n;
        }
        if (this.painted) {
            this.painted = false;
        }
        this.repaint();
    }

    public void showVectors(boolean bl) {
        int n = 0;
        while (n < this.nframes) {
            this.cf.getFrame(n).setShowVectors(bl);
            ++n;
        }
        if (this.painted) {
            this.painted = false;
        }
        this.repaint();
    }

    public void start() {
        new Thread(this).start();
        int n = 0;
        while (n < this.nframes) {
            this.cf.getFrame(n).setCanvas(this);
            ++n;
        }
        this.addMouseListener(new MyAdapter());
        this.addComponentListener(this);
        this.addMouseMotionListener(new MyMotionAdapter());
        this.addKeyListener(new MyKeyListener());
        Dimension dimension = this.getSize();
        this.width = dimension.width;
        this.height = dimension.height;
        this.db = this.createImage(this.width, this.height);
    }

    public void stop() {
    }

    protected String[] tokenize(String string) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        String[] stringArray = new String[vector.size()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = (String)vector.elementAt(n);
            ++n;
        }
        return stringArray;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    class MyAdapter
    extends MouseAdapter {
        MyAdapter() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (displayPanel.this.mode == 3 && displayPanel.this.haveFile) {
                if (mouseEvent.isShiftDown()) {
                    displayPanel.this.md.shiftSelectAtom(mouseEvent.getX(), mouseEvent.getY());
                } else {
                    displayPanel.this.md.selectAtom(mouseEvent.getX(), mouseEvent.getY());
                }
                displayPanel.this.repaint();
                int n = displayPanel.this.md.getNpicked();
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            displayPanel.this.requestFocus();
        }

        public void mousePressed(MouseEvent mouseEvent) {
            displayPanel.this.prevx = mouseEvent.getX();
            displayPanel.this.prevy = mouseEvent.getY();
            if (displayPanel.this.mode == 3) {
                displayPanel.this.rubberband = true;
                displayPanel.this.bx = mouseEvent.getX();
                displayPanel.this.rright = displayPanel.this.bx;
                displayPanel.this.rleft = displayPanel.this.bx;
                displayPanel.this.by = mouseEvent.getY();
                displayPanel.this.rtop = displayPanel.this.by;
                displayPanel.this.rbottom = displayPanel.this.by;
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (displayPanel.this.mouseDragged && displayPanel.this.WireFrameRotation) {
                displayPanel.this.md.setMovingDrawMode(false);
                if (displayPanel.this.painted) {
                    displayPanel.this.painted = false;
                    displayPanel.this.repaint();
                }
                displayPanel.this.mouseDragged = false;
            }
            displayPanel.this.outx = mouseEvent.getX();
            displayPanel.this.outy = mouseEvent.getY();
            if (displayPanel.this.mode == 3) {
                displayPanel.this.rubberband = false;
                displayPanel.this.repaint();
            }
        }
    }

    class MyMotionAdapter
    extends MouseMotionAdapter {
        MyMotionAdapter() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            float f;
            float f2;
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (displayPanel.this.WireFrameRotation) {
                displayPanel.this.md.setMovingDrawMode(true);
                displayPanel.this.mouseDragged = true;
            }
            if (displayPanel.this.mode == 0) {
                displayPanel.this.xtheta = (float)(displayPanel.this.prevy - n2) * (360.0f / (float)displayPanel.this.getSize().width);
                displayPanel.this.ytheta = (float)(n - displayPanel.this.prevx) * (360.0f / (float)displayPanel.this.getSize().height);
                displayPanel.this.amat.xrot(displayPanel.this.xtheta);
                displayPanel.this.amat.yrot(displayPanel.this.ytheta);
                displayPanel.this.mat.mult(displayPanel.this.amat);
            }
            if (displayPanel.this.mode == 2) {
                f2 = n - displayPanel.this.prevx;
                f = n2 - displayPanel.this.prevy;
                displayPanel.this.tmat.translate(f2, f, 0.0f);
                displayPanel.this.mat.mult(displayPanel.this.tmat);
            }
            if (displayPanel.this.mode == 1) {
                f2 = 1.0f + (float)(n - displayPanel.this.prevx) / (float)displayPanel.this.getSize().width;
                f = 1.0f + (float)(displayPanel.this.prevy - n2) / (float)displayPanel.this.getSize().height;
                float f3 = (f2 + f) / 2.0f;
                displayPanel.this.zmat.scale(f3, f3, f3);
                displayPanel.this.mat.mult(displayPanel.this.zmat);
                displayPanel displayPanel2 = displayPanel.this;
                displayPanel2.xfac = displayPanel2.xfac * (f3 * f3);
                int n3 = 0;
                while (n3 < displayPanel.this.nframes) {
                    displayPanel.this.cf.getFrame(n3).setAtomScreenScale(displayPanel.this.xfac);
                    displayPanel.this.cf.getFrame(n3).setBondScreenScale(displayPanel.this.xfac);
                    displayPanel.this.cf.getFrame(n3).setScreenScale(displayPanel.this.xfac);
                    ++n3;
                }
            }
            if (displayPanel.this.mode == 3) {
                if (n < displayPanel.this.bx) {
                    displayPanel.this.rleft = n;
                    displayPanel.this.rright = displayPanel.this.bx;
                } else {
                    displayPanel.this.rleft = displayPanel.this.bx;
                    displayPanel.this.rright = n;
                }
                if (n2 < displayPanel.this.by) {
                    displayPanel.this.rtop = n2;
                    displayPanel.this.rbottom = displayPanel.this.by;
                } else {
                    displayPanel.this.rtop = displayPanel.this.by;
                    displayPanel.this.rbottom = n2;
                }
                if (displayPanel.this.haveFile) {
                    if (mouseEvent.isShiftDown()) {
                        displayPanel.this.md.shiftSelectRegion(displayPanel.this.rleft, displayPanel.this.rtop, displayPanel.this.rright, displayPanel.this.rbottom);
                    } else {
                        displayPanel.this.md.selectRegion(displayPanel.this.rleft, displayPanel.this.rtop, displayPanel.this.rright, displayPanel.this.rbottom);
                    }
                    displayPanel.this.repaint();
                    int n4 = displayPanel.this.md.getNpicked();
                }
            }
            if (displayPanel.this.painted) {
                displayPanel.this.painted = false;
                displayPanel.this.repaint();
            }
            displayPanel.this.prevx = n;
            displayPanel.this.prevy = n2;
        }
    }

    class MyKeyListener
    extends KeyAdapter {
        MyKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 16) {
                displayPanel.this.mode = 1;
            } else if (keyEvent.getKeyCode() == 17) {
                displayPanel.this.mode = 2;
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
            displayPanel.this.mode = 0;
        }
    }
}

