/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.miniJmol;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.openscience.miniJmol.AtomTypeLookup;
import org.openscience.miniJmol.ChemFile;
import org.openscience.miniJmol.ChemFrame;
import org.openscience.miniJmol.FortranFormat;

public class PDBFile
extends ChemFile {
    private AtomTypeLookup atlu;

    public PDBFile(InputStream inputStream, AtomTypeLookup atomTypeLookup) throws Exception {
        this.atlu = atomTypeLookup;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream), 1024);
        try {
            ChemFrame chemFrame = this.readFrame(bufferedReader);
            this.frames.addElement(chemFrame);
            ++this.nframes;
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
    }

    public ChemFrame readFrame(BufferedReader bufferedReader) throws Exception {
        ChemFrame chemFrame;
        block5: {
            String string;
            chemFrame = new ChemFrame();
            chemFrame.setAtomTypeLookup(this.atlu);
            do {
                String string2;
                try {
                    string2 = bufferedReader.readLine();
                }
                catch (IOException iOException) {
                    break block5;
                }
                if (string2 == null) break block5;
                try {
                    string = new String(string2.substring(0, 6).trim());
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    break block5;
                }
                if (!string.equalsIgnoreCase("ATOM") && !string.equalsIgnoreCase("HETATM")) continue;
                String string3 = new String(string2.substring(13, 14).trim());
                String string4 = new String(string2.substring(29, 38).trim());
                String string5 = new String(string2.substring(38, 46).trim());
                String string6 = new String(string2.substring(46, 54).trim());
                double d = FortranFormat.atof(string4);
                double d2 = FortranFormat.atof(string5);
                double d3 = FortranFormat.atof(string6);
                chemFrame.addVert(string3, (float)d, (float)d2, (float)d3);
            } while (!string.equalsIgnoreCase("END"));
            return chemFrame;
        }
        return chemFrame;
    }
}

