/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.miniJmol;

import java.awt.Color;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.openscience.miniJmol.AtomType;

class AtomTypesModel
extends AbstractTableModel {
    protected static int NUM_COLUMNS = 7;
    protected static int START_NUM_ROWS = 5;
    protected int nextEmptyRow = 0;
    protected int numRows = 0;
    public static final String[] names = new String[]{"Atom Type", "Base\nAtom Type", "Atomic\nNumber", "Atomic\nMass", "Van derWaals\nRadius", "Covalent\nRadius", "Color"};
    protected Vector data = new Vector();

    public synchronized void clear() {
        int n = this.numRows;
        this.numRows = START_NUM_ROWS;
        this.data.removeAllElements();
        this.nextEmptyRow = 0;
        if (n > START_NUM_ROWS) {
            this.fireTableRowsDeleted(START_NUM_ROWS, n - 1);
        }
        this.fireTableRowsUpdated(0, START_NUM_ROWS - 1);
    }

    public synchronized Enumeration elements() {
        return this.data.elements();
    }

    public AtomType get(int n) {
        Enumeration enumeration = this.data.elements();
        while (enumeration.hasMoreElements()) {
            AtomType atomType = (AtomType)enumeration.nextElement();
            if (n != atomType.getAtomicNumber()) continue;
            return atomType;
        }
        return null;
    }

    public AtomType get(String string) {
        Enumeration enumeration = this.data.elements();
        while (enumeration.hasMoreElements()) {
            AtomType atomType = (AtomType)enumeration.nextElement();
            if (!string.equalsIgnoreCase(atomType.getName())) continue;
            return atomType;
        }
        return null;
    }

    public Class getColumnClass(int n) {
        String string = "0";
        Integer n2 = new Integer(0);
        Double d = new Double(0.0);
        Color color = new Color(0, 0, 0);
        switch (n) {
            case 2: {
                return n2.getClass();
            }
            case 3: {
                return d.getClass();
            }
            case 4: {
                return d.getClass();
            }
            case 5: {
                return d.getClass();
            }
            case 6: {
                return color.getClass();
            }
        }
        return string.getClass();
    }

    public synchronized int getColumnCount() {
        return NUM_COLUMNS;
    }

    public String getColumnName(int n) {
        return names[n];
    }

    public synchronized int getRowCount() {
        if (this.numRows < START_NUM_ROWS) {
            return START_NUM_ROWS;
        }
        return this.numRows;
    }

    public synchronized Object getValueAt(int n, int n2) {
        try {
            AtomType atomType = (AtomType)this.data.elementAt(n);
            switch (n2) {
                case 0: {
                    return atomType.getName();
                }
                case 1: {
                    return atomType.getRoot();
                }
                case 2: {
                    return new Integer(atomType.getAtomicNumber());
                }
                case 3: {
                    return new Double(atomType.getMass());
                }
                case 4: {
                    return new Double(atomType.getvdWRadius());
                }
                case 5: {
                    return new Double(atomType.getCovalentRadius());
                }
                case 6: {
                    return atomType.getColor();
                }
                default: {
                    return "";
                }
            }
        }
        catch (Exception exception) {
            return "";
        }
    }

    public boolean isCellEditable(int n, int n2) {
        return n >= START_NUM_ROWS || n <= this.numRows;
    }

    /*
     * Exception decompiling
     */
    public void setValueAt(Object var1_1, int var2_2, int var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Extractable last case doesn't follow previous, and can't clone.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:611)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public synchronized void updateAtomType(AtomType atomType) {
        String string = atomType.getName();
        AtomType atomType2 = null;
        int n = -1;
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        while (!bl && n2 < this.nextEmptyRow) {
            atomType2 = (AtomType)this.data.elementAt(n2);
            if (string.equals(atomType2.getName())) {
                bl = true;
                n = n2;
                continue;
            }
            ++n2;
        }
        if (bl) {
            this.data.setElementAt(atomType, n);
        } else {
            if (this.numRows <= this.nextEmptyRow) {
                ++this.numRows;
                bl2 = true;
            }
            n = this.nextEmptyRow;
            this.data.addElement(atomType);
        }
        ++this.nextEmptyRow;
        if (bl2) {
            this.fireTableRowsInserted(n, n);
        } else {
            this.fireTableRowsUpdated(n, n);
        }
    }
}

