/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.miniJmol;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.openscience.miniJmol.AtomType;
import org.openscience.miniJmol.AtomTypesModel;
import org.openscience.miniJmol.JmolException;

public class AtomTypeLookup {
    private boolean DEBUG = false;
    AtomTypesModel atModel = new AtomTypesModel();
    static AtomType defaultAtomType;

    public AtomTypeLookup(String string, boolean bl) {
        if (bl) {
            URL uRL;
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                throw new RuntimeException("Properties URL is malformed: " + malformedURLException);
            }
            try {
                this.ReadAtypes(uRL.openStream());
            }
            catch (Exception exception) {
                throw new RuntimeException("Got Exception trying to read properties: " + exception);
            }
        }
        try {
            this.ReadAtypes(new FileInputStream(string));
        }
        catch (Exception exception) {
            throw new RuntimeException("Got Exception trying to read properties: " + exception);
        }
    }

    public AtomTypeLookup(URL uRL) {
        try {
            this.ReadAtypes(uRL.openStream());
        }
        catch (Exception exception) {
            throw new RuntimeException("Got Exception trying to read properties: " + exception);
        }
    }

    void ReadAtypes(InputStream inputStream) throws Exception {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream), 1024);
        this.atModel.clear();
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                if (string.startsWith("#")) continue;
                String string2 = "";
                String string3 = "";
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                double d = 0.0;
                double d2 = 0.0;
                double d3 = 0.0;
                StringTokenizer stringTokenizer = new StringTokenizer(string, "\t ,;");
                int n5 = stringTokenizer.countTokens();
                if (n5 == 9) {
                    string2 = stringTokenizer.nextToken();
                    string3 = stringTokenizer.nextToken();
                    String string4 = stringTokenizer.nextToken();
                    String string5 = stringTokenizer.nextToken();
                    String string6 = stringTokenizer.nextToken();
                    String string7 = stringTokenizer.nextToken();
                    String string8 = stringTokenizer.nextToken();
                    String string9 = stringTokenizer.nextToken();
                    String string10 = stringTokenizer.nextToken();
                    try {
                        d = new Double(string5);
                        d2 = new Double(string6);
                        d3 = new Double(string7);
                        n = new Integer(string4);
                        n2 = new Integer(string8);
                        n3 = new Integer(string9);
                        n4 = new Integer(string10);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new JmolException("AtomTypeTable.ReadAtypes", "Malformed Number");
                    }
                    AtomType atomType = new AtomType(string2, string3, n, d, d2, d3, n2, n3, n4);
                    this.atModel.updateAtomType(atomType);
                    continue;
                }
                throw new JmolException("AtomTypeTable.ReadAtypes", "Wrong Number of fields");
            }
            inputStream.close();
        }
        catch (IOException iOException) {}
    }

    public synchronized Enumeration elements() {
        return this.atModel.elements();
    }

    public AtomType get(int n) {
        return this.atModel.get(n);
    }

    public AtomType get(String string) {
        return this.atModel.get(string);
    }
}

