/*
 * Decompiled with CFR 0.152.
 */
import acd.StructureDrawing.StructureEditor;
import acd.rwt.Box;
import acd.rwt.BoxContainer;
import acd.rwt.BoxPanel;
import acd.rwt.EventHandler;
import acd.rwt.ImageButton;
import acd.rwt.MuscatEvent;
import acd.rwt.PlatformServiceProvider;
import acd.rwt.ServiceWindow;
import acd.rwt.ToolbarBox;
import acd.rwt.Utils;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.Font;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class StructureEditorApplet
extends Applet
implements EventHandler,
Runnable {
    public static final String product = "Structure Drawing Applet";
    public static final String appletVersion = "1.30";
    public static final String packageVersion = "1.6";
    public static final String DEFAULT_TEMPLATES_PATH = "data/templates";
    public static final String DEFAULT_TOOLBAR_IMAGE = "images/toolbars.gif";
    private boolean added;
    Thread serverThread;
    Vector taskQueue = new Vector();
    static final int TOP_TOOLBAR_HEIGHT = 34;
    static final int ATOM_TOOLBAR_WIDTH = 30;
    static final int TEMPLATE_TOOLBAR_WIDTH = 51;
    static final int SCROLLBAR_SIZE = 15;
    BoxContainer boxContainer;
    BoxContainer topToolbar;
    BoxContainer leftToolbar;
    BoxContainer rightToolbar;
    BoxPanel boxPanel;
    BoxPanel attachButtonPanel;
    ImageButton attachButton;
    ServiceWindow deattachedWindow;
    Box tipBox;
    StructureEditor structureEditor;
    boolean maximized;
    boolean floating;
    boolean alwaysFloat;

    public void init() {
        super.init();
        PlatformServiceProvider.init((Applet)this, null, (String)product, (String)appletVersion, (String)packageVersion);
        String string = this.getParameter("maximizeScreen");
        this.maximized = string != null && string.equalsIgnoreCase("yes");
        this.alwaysFloat = this.size().width < 3 || this.size().height < 3;
        this.setLayout(new BorderLayout());
        this.setBackground(new Color(0xC0C0C0));
        this._init();
    }

    public void _init() {
        String string;
        this.floating = false;
        this.boxContainer = new BoxContainer(100);
        this.boxContainer.transparent = true;
        this.boxContainer.borderX = 0;
        this.boxContainer.borderY = 0;
        this.boxPanel = new BoxPanel((Box)this.boxContainer);
        this.layout();
        String string2 = this.getParameter("toolbarImg");
        if (string2 == null) {
            string2 = DEFAULT_TOOLBAR_IMAGE;
        }
        ToolbarBox.initImageArchive((BoxPanel)this.boxPanel, (String)string2);
        this.tipBox = new Box();
        this.tipBox.about = "http://www.acdlabs.com/products/java/sda/";
        this.tipBox.setName("");
        this.tipBox.fitable = true;
        this.tipBox.raisedBorder = false;
        this.tipBox.nameColor = new Color(0, 0, 128);
        this.tipBox.setBuffered(true);
        this.tipBox.distributeProperties(new Font("Helvetica", 1, 10), true);
        this.topToolbar = new BoxContainer(7);
        this.topToolbar.borderX = 2;
        this.topToolbar.borderY = 1;
        this.leftToolbar = new BoxContainer(1);
        this.leftToolbar.borderX = 1;
        this.leftToolbar.borderY = 1;
        this.rightToolbar = new BoxContainer(1);
        this.attachButton = new ImageButton((EventHandler)this, 0, "Float", 19, 24, 4, null);
        this.attachButton.setState(true);
        this.attachButton.setTipBox(this.tipBox);
        ToolbarBox.getStandartImageArchive().setNotification((EventHandler)this.attachButton, (short)60);
        this.attachButtonPanel = new BoxPanel((Box)this.attachButton);
        if (!this.alwaysFloat) {
            this.topToolbar.addFlowBox((Box)this.attachButton, (short)2, 0);
        }
        if ((string = this.getParameter("templates")) == null) {
            string = DEFAULT_TEMPLATES_PATH;
        }
        this.structureEditor = new StructureEditor((Applet)this, this.boxPanel, string, this.getParameter("molFile"), this.getParameter("allowSubstructure"), this.getParameter("molContent"), this.getParameter("cleanPath"), this.getParameter("templatesList"), this.getParameter("gif_print_server"));
        this.structureEditor.setVersions(product, appletVersion);
        this.boxContainer.addBorderBox((Box)this.structureEditor, (short)5, 0);
        this.setControls(this.maximized);
        this.structureEditor.setCurrentEnvironment(this.topToolbar, this.leftToolbar, this.rightToolbar, this.tipBox);
        this.structureEditor.init();
        this.boxContainer.addBorderBox((Box)this.structureEditor, (short)5, 0);
        this.topToolbar.addFlowBox(this.tipBox, (short)2, 5);
        if (this.alwaysFloat) {
            this.createFlowWindow(500, 400);
        } else {
            this.add("Center", (Component)this.boxPanel);
        }
        this.structureEditor.start();
    }

    public boolean handleEvent(short s, Event event, Object object) {
        MuscatEvent muscatEvent = new MuscatEvent((Object)this, s, event, object);
        return this.handleEvent((Event)muscatEvent);
    }

    public boolean handleEvent(Event event) {
        if (event instanceof MuscatEvent) {
            if (event.id == 2006 && event.arg == this.attachButton) {
                this.remove((Component)this.boxPanel);
                this.setBackground(Utils.getHtmlColor((String)this.getParameter("backgroundColor"), (String)"#C0C0C0"));
                this.repaint();
                this.createFlowWindow(this.size().width + this.leftToolbar.width, this.size().height + this.topToolbar.height);
                return true;
            }
            if (this.deattachedWindow != null && event.id == 2005 && event.arg == this.attachButton) {
                this.setBackground(new Color(0xC0C0C0));
                this.deattachedWindow.close();
                this.floating = false;
                if (this.maximized) {
                    this.setControls(true);
                }
                this.add("Center", (Component)this.boxPanel);
                this.layout();
                return true;
            }
            if (this.deattachedWindow != null && event.id == 2015 && event.arg == this.deattachedWindow) {
                if (this.alwaysFloat) {
                    return false;
                }
                this.attachButton.setState(true);
                return true;
            }
            if (event.id == 2013 && event.arg == this.structureEditor.fatalWindow) {
                this.restart();
                return true;
            }
            return false;
        }
        if (event.arg instanceof Properties) {
            this.taskQueue.addElement(event.arg);
            return false;
        }
        return super.handleEvent(event);
    }

    private void setControls(boolean bl) {
        if (bl) {
            if (this.boxContainer.haveBox((Box)this.topToolbar)) {
                this.boxContainer.removeBox((Box)this.topToolbar);
            }
            if (this.boxContainer.haveBox((Box)this.leftToolbar)) {
                this.boxContainer.removeBox((Box)this.leftToolbar);
            }
            this.structureEditor.drawPlace.lock(null);
            this.structureEditor.drawPlace.add((Component)this.attachButtonPanel);
            this.attachButtonPanel.reshape(0, 0, 19, 24);
            this.attachButton.mouseIn = true;
            return;
        }
        this.structureEditor.drawPlace.remove((Component)this.attachButtonPanel);
        this.structureEditor.drawPlace.unlock();
        this.boxContainer.addBorderBox((Box)this.topToolbar, (short)1, 30);
        this.boxContainer.addBorderBox((Box)this.leftToolbar, (short)3, 30);
    }

    private void removeAllControls() {
    }

    public void onLoad() {
        String string = this.getParameter("onLoadTarget");
        String string2 = this.getParameter("onLoadURL");
        if (string != null && string2 != null) {
            URL uRL = null;
            try {
                uRL = new URL(this.getCodeBase(), string2);
            }
            catch (MalformedURLException malformedURLException) {
                PlatformServiceProvider.fatal((EventHandler)this, (String)"", (Exception)malformedURLException);
                return;
            }
            this.getAppletContext().showDocument(uRL, string);
        }
    }

    public void createFlowWindow(int n, int n2) {
        this.deattachedWindow = new ServiceWindow((Component)this, (EventHandler)this, "Structure Drawing", null, null, null, null, true);
        if (this.alwaysFloat) {
            this.deattachedWindow.closeOnDestroy = false;
        }
        this.deattachedWindow.resize(n, n2);
        this.showFlowWindow();
        this.floating = true;
        if (this.maximized) {
            this.setControls(false);
        }
        this.deattachedWindow.add("Center", (Component)this.boxPanel);
        this.deattachedWindow.layout();
    }

    public void restart() {
        System.out.println("Restarting.");
        this.structureEditor.fatalWindow.close();
        this.removeAll();
        this._init();
        System.gc();
        this.layout();
    }

    private void showFlowWindow() {
        try {
            this.added = true;
            this.add((Component)this.deattachedWindow);
            this.deattachedWindow.show();
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.added = false;
            this.deattachedWindow.show();
            return;
        }
    }

    private void hideFlowWindow() {
        if (this.added) {
            this.remove((Component)this.deattachedWindow);
            return;
        }
        this.deattachedWindow.hide();
    }

    public void destroy() {
        if (this.deattachedWindow != null) {
            this.deattachedWindow.dispose();
        }
        int n = 1;
        while (n <= 3) {
            System.gc();
            ++n;
        }
    }

    public void start() {
        if (this.serverThread == null) {
            this.serverThread = new Thread(this);
        }
        this.serverThread.start();
        if (this.floating) {
            this.showFlowWindow();
        }
        this.onLoad();
    }

    public void stop() {
        this.serverThread.stop();
        if (this.floating) {
            if (this.added) {
                this.remove((Component)this.deattachedWindow);
                return;
            }
            this.deattachedWindow.hide();
        }
    }

    public void run() {
        Hashtable hashtable = null;
        Thread thread = Thread.currentThread();
        thread.setPriority(1);
        while (true) {
            try {
                while (true) {
                    Object object;
                    Object object2;
                    Thread.sleep(500L);
                    if (this.taskQueue.size() == 0) continue;
                    hashtable = (Properties)this.taskQueue.elementAt(0);
                    this.taskQueue.removeElementAt(0);
                    if (hashtable.get("PrintURL") != null) {
                        object2 = (URL)hashtable.get("PrintURL");
                        object = ((URL)object2).openConnection();
                        System.out.println("URLConnection: " + object);
                        hashtable.put("result", object);
                        continue;
                    }
                    if (hashtable.get("PrintOutputStream") != null) {
                        object2 = (URLConnection)hashtable.get("PrintOutputStream");
                        System.out.println("URLConnection: " + object2);
                        object = ((URLConnection)object2).getOutputStream();
                        hashtable.put("result", object);
                        continue;
                    }
                    if (hashtable.get("PrintInputStream") != null) {
                        object2 = (URLConnection)hashtable.get("PrintInputStream");
                        System.out.println("URLConnection: " + object2);
                        object = ((URLConnection)object2).getInputStream();
                        hashtable.put("result", object);
                        continue;
                    }
                    object2 = (URL)hashtable.get("URL");
                    if (object2 == null) continue;
                    object = ((URL)object2).openConnection();
                    if (((Boolean)hashtable.get("CONNECT")).booleanValue()) {
                        ((URLConnection)object).connect();
                    }
                    hashtable.put("result", object);
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            catch (Exception exception) {
                hashtable.put("result", exception);
                PlatformServiceProvider.fatal((EventHandler)this, (String)"", (Exception)exception);
                continue;
            }
            break;
        }
    }

    public String getMolDescription() {
        return this.structureEditor.getMolContent(true);
    }

    public String getACDMolDescription() {
        return this.structureEditor.getMolContent(false);
    }

    public void setMolFile(String string) {
        this.structureEditor.setFile(string, true);
    }

    public boolean hasAtomLabels() {
        return this.structureEditor.hasAtomLabels();
    }

    public void setMolContent(String string) {
        this.structureEditor.setMolContent(string);
    }

    public void setLineanMolContent(String string) {
        this.structureEditor.setMolContent(string.replace('|', '\n'));
    }
}

